/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.Hideable;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.Pragma;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.baraye.EntityImp;
import net.sourceforge.plantuml.baraye.IEntity;
import net.sourceforge.plantuml.baraye.IGroup;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.CucaNote;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPort;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArrow;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkMiddleDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.NoteLinkStrategy;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DotSplines;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.descdiagram.command.StringWithArrow;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.USymbolFolder;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.posimo.BezierUtils;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.posimo.PositionableUtils;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.svek.ArithmeticStrategySum;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.GuideLine;
import net.sourceforge.plantuml.svek.Kal;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.Oscillator;
import net.sourceforge.plantuml.svek.PointAndAngle;
import net.sourceforge.plantuml.svek.PointListIterator;
import net.sourceforge.plantuml.svek.Side;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.SvgResult;
import net.sourceforge.plantuml.svek.extremity.Extremity;
import net.sourceforge.plantuml.svek.extremity.ExtremityArrow;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactory;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryExtends;
import net.sourceforge.plantuml.svek.extremity.ExtremityOther;
import net.sourceforge.plantuml.svek.image.EntityImageNoteLink;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGroupType;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColors;

public class SvekLine
implements Moveable,
Hideable,
GuideLine {
    private static final XDimension2D CONSTRAINT_SPOT = new XDimension2D(10.0, 10.0);
    private final Cluster ltail;
    private final Cluster lhead;
    private final Link link;
    private final EntityPort startUid;
    private final EntityPort endUid;
    private final TextBlock startTailText;
    private final TextBlock endHeadText;
    private final TextBlock labelText;
    private boolean divideLabelWidthByTwo = false;
    private final int lineColor;
    private final int noteLabelColor;
    private final int startTailColor;
    private final int endHeadColor;
    private final StringBounder stringBounder;
    private final Bibliotekon bibliotekon;
    private DotPath dotPath;
    private Positionable startTailLabelXY;
    private Positionable endHeadLabelXY;
    private Positionable labelXY;
    private UDrawable extremity2;
    private UDrawable extremity1;
    private double dx;
    private double dy;
    private boolean opale;
    private Cluster projectionCluster;
    private final Pragma pragma;
    private final HColor backgroundColor;
    private final boolean useRankSame;
    private final UStroke defaultThickness;
    private HColor arrowLollipopColor;
    private final ISkinParam skinParam;
    private final double labelShield;
    private Kal kal1;
    private Kal kal2;

    public String toString() {
        return super.toString() + " color=" + this.lineColor;
    }

    @Override
    public Direction getArrowDirection() {
        if (this.getLinkArrow() == LinkArrow.BACKWARD) {
            return this.getArrowDirectionInternal().getInv();
        }
        return this.getArrowDirectionInternal();
    }

    private Direction getArrowDirectionInternal() {
        if (this.isAutolink()) {
            double startAngle = this.dotPath.getStartAngle();
            return Direction.LEFT;
        }
        XPoint2D start = this.dotPath.getStartPoint();
        XPoint2D end = this.dotPath.getEndPoint();
        double ang = Math.atan2(end.getX() - start.getX(), end.getY() - start.getY());
        if (ang > -0.7853981633974483 && ang < 0.7853981633974483) {
            return Direction.DOWN;
        }
        if (ang > 2.356194490192345 || ang < -2.356194490192345) {
            return Direction.UP;
        }
        return end.getX() > start.getX() ? Direction.RIGHT : Direction.LEFT;
    }

    @Override
    public double getArrowDirection2() {
        if (this.getLinkArrow() == LinkArrow.BACKWARD) {
            return Math.PI + this.getArrowDirectionInternal2();
        }
        return this.getArrowDirectionInternal2();
    }

    private double getArrowDirectionInternal2() {
        if (this.isAutolink()) {
            double startAngle = this.dotPath.getStartAngle();
            return startAngle;
        }
        XPoint2D start = this.dotPath.getStartPoint();
        XPoint2D end = this.dotPath.getEndPoint();
        double ang = Math.atan2(end.getX() - start.getX(), end.getY() - start.getY());
        return ang;
    }

    private Cluster getCluster2(Bibliotekon bibliotekon, IEntity entityMutable) {
        for (Cluster cl : bibliotekon.allCluster()) {
            if (!cl.getGroups().contains(entityMutable)) continue;
            return cl;
        }
        throw new IllegalArgumentException();
    }

    public SvekLine(Link link, ColorSequence colorSequence, ISkinParam skinParam, StringBounder stringBounder, FontConfiguration font, Bibliotekon bibliotekon, Pragma pragma, GraphvizVersion graphvizVersion) {
        CucaNote note;
        TextBlock labelOnly;
        if (graphvizVersion.useShieldForQuantifier() && link.getLinkArg().getQuantifier1() != null) {
            ((EntityImp)link.getEntity1()).ensureMargins(Margins.uniform(16.0));
        }
        if (graphvizVersion.useShieldForQuantifier() && link.getLinkArg().getQuantifier2() != null) {
            ((EntityImp)link.getEntity2()).ensureMargins(Margins.uniform(16.0));
        }
        if (link.getLinkArg().getKal1() != null) {
            this.kal1 = new Kal(this, link.getLinkArg().getKal1(), font, skinParam, (EntityImp)link.getEntity1(), link, stringBounder);
        }
        if (link.getLinkArg().getKal2() != null) {
            this.kal2 = new Kal(this, link.getLinkArg().getKal2(), font, skinParam, (EntityImp)link.getEntity2(), link, stringBounder);
        }
        this.link = Objects.requireNonNull(link);
        this.skinParam = skinParam;
        this.useRankSame = skinParam.useRankSame();
        this.startUid = link.getEntityPort1(bibliotekon);
        this.endUid = link.getEntityPort2(bibliotekon);
        Cluster ltail = null;
        if (this.startUid.startsWith("za")) {
            ltail = this.getCluster2(bibliotekon, link.getEntity1());
        }
        Cluster lhead = null;
        if (this.endUid.startsWith("za")) {
            lhead = this.getCluster2(bibliotekon, link.getEntity2());
        }
        if (link.getColors() != null) {
            skinParam = link.getColors().mute(skinParam);
            font = font.mute(link.getColors());
        }
        this.backgroundColor = skinParam.getBackgroundColor();
        this.defaultThickness = skinParam.getThickness(LineParam.arrow, null);
        this.arrowLollipopColor = skinParam.getHtmlColor(ColorParam.arrowLollipop, null, false);
        if (this.arrowLollipopColor == null) {
            this.arrowLollipopColor = this.backgroundColor;
        }
        this.pragma = pragma;
        this.bibliotekon = bibliotekon;
        this.stringBounder = stringBounder;
        this.ltail = ltail;
        this.lhead = lhead;
        this.lineColor = colorSequence.getValue();
        this.noteLabelColor = colorSequence.getValue();
        this.startTailColor = colorSequence.getValue();
        this.endHeadColor = colorSequence.getValue();
        if (Display.isNull(link.getLabel())) {
            labelOnly = TextBlockUtils.EMPTY_TEXT_BLOCK;
            if (this.getLinkArrow() != LinkArrow.NONE_OR_SEVERAL) {
                labelOnly = StringWithArrow.addMagicArrow(labelOnly, this, font);
            }
        } else {
            HorizontalAlignment alignment = this.getMessageTextAlignment(link.getUmlDiagramType(), skinParam);
            boolean hasSeveralGuideLines = link.getLabel().hasSeveralGuideLines();
            TextBlock block = hasSeveralGuideLines ? StringWithArrow.addSeveralMagicArrows(link.getLabel(), this, font, alignment, skinParam) : link.getLabel().create0(font, alignment, skinParam, skinParam.maxMessageSize(), CreoleMode.SIMPLE_LINE, null, null);
            labelOnly = this.addVisibilityModifier(block, link, skinParam);
            if (this.getLinkArrow() != LinkArrow.NONE_OR_SEVERAL && !hasSeveralGuideLines) {
                labelOnly = StringWithArrow.addMagicArrow(labelOnly, this, font);
            }
        }
        if ((note = link.getNote()) == null) {
            this.labelText = labelOnly;
        } else {
            EntityImageNoteLink noteOnly = new EntityImageNoteLink(note.getDisplay(), note.getColors(), skinParam, link.getStyleBuilder());
            if (note.getStrategy() == NoteLinkStrategy.HALF_NOT_PRINTED || note.getStrategy() == NoteLinkStrategy.HALF_PRINTED_FULL) {
                this.divideLabelWidthByTwo = true;
            }
            this.labelText = note.getPosition() == Position.LEFT ? TextBlockUtils.mergeLR(noteOnly, labelOnly, VerticalAlignment.CENTER) : (note.getPosition() == Position.RIGHT ? TextBlockUtils.mergeLR(labelOnly, noteOnly, VerticalAlignment.CENTER) : (note.getPosition() == Position.TOP ? TextBlockUtils.mergeTB((TextBlock)noteOnly, labelOnly, HorizontalAlignment.CENTER) : TextBlockUtils.mergeTB(labelOnly, noteOnly, HorizontalAlignment.CENTER)));
        }
        this.startTailText = link.getQuantifier1() == null ? null : Display.getWithNewlines(link.getQuantifier1()).create(font, HorizontalAlignment.CENTER, skinParam);
        this.endHeadText = link.getQuantifier2() == null ? null : Display.getWithNewlines(link.getQuantifier2()).create(font, HorizontalAlignment.CENTER, skinParam);
        this.labelShield = link.getType().getMiddleDecor() == LinkMiddleDecor.NONE ? 0.0 : 7.0;
    }

    private TextBlock addVisibilityModifier(TextBlock block, Link link, ISkinParam skinParam) {
        VisibilityModifier visibilityModifier = link.getVisibilityModifier();
        if (visibilityModifier != null) {
            Rose rose = new Rose();
            HColor fore = rose.getHtmlColor(skinParam, visibilityModifier.getForeground());
            TextBlock visibility = visibilityModifier.getUBlock(skinParam.classAttributeIconSize(), fore, null, false);
            visibility = TextBlockUtils.withMargin(visibility, 0.0, 1.0, 2.0, 0.0);
            block = TextBlockUtils.mergeLR(visibility, block, VerticalAlignment.CENTER);
        }
        double marginLabel = this.startUid.equalsId(this.endUid) ? 6.0 : 1.0;
        return TextBlockUtils.withMargin(block, marginLabel, marginLabel);
    }

    private HorizontalAlignment getMessageTextAlignment(UmlDiagramType umlDiagramType, ISkinParam skinParam) {
        if (umlDiagramType == UmlDiagramType.STATE) {
            return skinParam.getHorizontalAlignment(AlignmentParam.stateMessageAlignment, null, false, null);
        }
        return skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER);
    }

    public boolean hasNoteLabelText() {
        return this.labelText != null && this.labelText != TextBlockUtils.EMPTY_TEXT_BLOCK;
    }

    private LinkArrow getLinkArrow() {
        return this.link.getLinkArrow();
    }

    public void appendLine(GraphvizVersion graphvizVersion, StringBuilder sb, DotMode dotMode, DotSplines dotSplines) {
        sb.append(this.startUid.getFullString());
        sb.append("->");
        sb.append(this.endUid.getFullString());
        sb.append("[");
        LinkType linkType = this.link.getTypePatchCluster();
        Object decoration = linkType.getSpecificDecorationSvek();
        if (((String)decoration).length() > 0 && !((String)decoration).endsWith(",")) {
            decoration = (String)decoration + ",";
        }
        sb.append((String)decoration);
        int length = this.link.getLength();
        if (graphvizVersion.ignoreHorizontalLinks() && length == 1) {
            length = 2;
        }
        if (this.useRankSame) {
            if (this.pragma.horizontalLineBetweenDifferentPackageAllowed() || this.link.isInvis() || length != 1) {
                sb.append("minlen=" + (length - 1));
                sb.append(",");
            }
        } else {
            sb.append("minlen=" + (length - 1));
            sb.append(",");
        }
        sb.append("color=\"" + StringUtils.sharp000000(this.lineColor) + "\"");
        if (this.hasNoteLabelText() || this.link.getLinkConstraint() != null) {
            sb.append(",");
            if (graphvizVersion.useXLabelInsteadOfLabel() || dotMode == DotMode.NO_LEFT_RIGHT_AND_XLABEL || dotSplines == DotSplines.ORTHO) {
                sb.append("xlabel=<");
            } else {
                sb.append("label=<");
            }
            XDimension2D dimNote = this.hasNoteLabelText() ? this.labelText.calculateDimension(this.stringBounder) : CONSTRAINT_SPOT;
            dimNote = dimNote.delta(2.0 * this.labelShield);
            SvekLine.appendTable(sb, this.eventuallyDivideByTwo(dimNote), this.noteLabelColor, graphvizVersion);
            sb.append(">");
        }
        if (this.startTailText != null) {
            sb.append(",");
            sb.append("taillabel=<");
            SvekLine.appendTable(sb, this.startTailText.calculateDimension(this.stringBounder), this.startTailColor, graphvizVersion);
            sb.append(">");
        }
        if (this.endHeadText != null) {
            sb.append(",");
            sb.append("headlabel=<");
            SvekLine.appendTable(sb, this.endHeadText.calculateDimension(this.stringBounder), this.endHeadColor, graphvizVersion);
            sb.append(">");
        }
        if (this.link.isInvis()) {
            sb.append(",");
            sb.append("style=invis");
        }
        if (!this.link.isConstraint() || this.link.hasTwoEntryPointsSameContainer()) {
            sb.append(",constraint=false");
        }
        if (this.link.getSametail() != null) {
            sb.append(",sametail=" + this.link.getSametail());
        }
        sb.append("];");
        SvekUtils.println(sb);
    }

    private XDimension2D eventuallyDivideByTwo(XDimension2D dim) {
        if (this.divideLabelWidthByTwo) {
            return new XDimension2D(dim.getWidth() / 2.0, dim.getHeight());
        }
        return dim;
    }

    public String rankSame() {
        if (!this.pragma.horizontalLineBetweenDifferentPackageAllowed() && this.link.getLength() == 1) {
            return "{rank=same; " + this.getStartUidPrefix() + "; " + this.getEndUidPrefix() + "}";
        }
        return null;
    }

    public static void appendTable(StringBuilder sb, XDimension2D dim, int col, GraphvizVersion graphvizVersion) {
        int w = (int)dim.getWidth();
        int h = (int)dim.getHeight();
        SvekLine.appendTable(sb, w, h, col);
    }

    public static void appendTable(StringBuilder sb, int w, int h, int col) {
        sb.append("<TABLE ");
        sb.append("BGCOLOR=\"" + StringUtils.sharp000000(col) + "\" ");
        sb.append("FIXEDSIZE=\"TRUE\" WIDTH=\"" + w + "\" HEIGHT=\"" + h + "\">");
        sb.append("<TR");
        sb.append(">");
        sb.append("<TD");
        sb.append(">");
        sb.append("</TD>");
        sb.append("</TR>");
        sb.append("</TABLE>");
    }

    public final String getStartUidPrefix() {
        return this.startUid.getPrefix();
    }

    public final String getEndUidPrefix() {
        return this.endUid.getPrefix();
    }

    private UDrawable getExtremity(LinkDecor decor, PointListIterator pointListIterator, final XPoint2D center, double angle, Cluster cluster, SvekNode nodeContact) {
        ExtremityFactory extremityFactory = decor.getExtremityFactory(this.backgroundColor);
        if (cluster != null) {
            if (extremityFactory != null) {
                return extremityFactory.createUDrawable(center, angle, null);
            }
            if (decor == LinkDecor.EXTENDS) {
                return new ExtremityFactoryExtends(this.backgroundColor).createUDrawable(center, angle, null);
            }
            return null;
        }
        if (extremityFactory != null) {
            List points = (List)pointListIterator.next();
            if (points.size() == 0) {
                return extremityFactory.createUDrawable(center, angle, null);
            }
            XPoint2D p0 = (XPoint2D)points.get(0);
            XPoint2D p1 = (XPoint2D)points.get(1);
            XPoint2D p2 = (XPoint2D)points.get(2);
            Side side = null;
            if (nodeContact != null) {
                side = nodeContact.getClusterPosition().getClosestSide(p1);
            }
            return extremityFactory.createUDrawable(p0, p1, p2, side);
        }
        if (decor == LinkDecor.NONE) {
            UPolygon sh = new UPolygon((List)pointListIterator.cloneMe().next());
            final XPoint2D contact = sh.checkMiddleContactForSpecificTriangle(center);
            if (contact != null) {
                return new UDrawable(){

                    @Override
                    public void drawU(UGraphic ug) {
                        ULine line = new ULine(contact.getX() - center.getX(), contact.getY() - center.getY());
                        ug = ug.apply(new UTranslate(center));
                        ug.draw(line);
                    }
                };
            }
        } else if (decor != LinkDecor.NONE) {
            UPolygon sh = new UPolygon((List)pointListIterator.next());
            return new ExtremityOther(sh);
        }
        return null;
    }

    public void solveLine(SvgResult fullSvg) {
        XPoint2D pos;
        if (this.link.isInvis()) {
            return;
        }
        int idx = fullSvg.getIndexFromColor(this.lineColor);
        if (idx == -1) {
            return;
        }
        if ((idx = fullSvg.indexOf("d=\"", idx)) == -1) {
            throw new IllegalStateException();
        }
        int end = fullSvg.indexOf("\"", idx + 3);
        SvgResult path = fullSvg.substring(idx + 3, end);
        if (!DotPath.isPathConsistent(path.getSvg())) {
            return;
        }
        this.dotPath = new DotPath(path);
        if (this.projectionCluster != null) {
            this.projectionCluster.manageEntryExitPoint(this.stringBounder);
        }
        this.dotPath = this.dotPath.simulateCompound(this.lhead, this.ltail);
        SvgResult lineSvg = fullSvg.substring(end);
        PointListIterator pointListIterator = lineSvg.getPointsWithThisColor(this.lineColor);
        LinkType linkType = this.link.getType();
        this.extremity1 = this.getExtremity(linkType.getDecor2(), pointListIterator, this.dotPath.getStartPoint(), this.dotPath.getStartAngle() + Math.PI, this.ltail, this.bibliotekon.getNode(this.link.getEntity1()));
        this.extremity2 = this.getExtremity(linkType.getDecor1(), pointListIterator, this.dotPath.getEndPoint(), this.dotPath.getEndAngle(), this.lhead, this.bibliotekon.getNode(this.link.getEntity2()));
        if (this.link.getEntity1().getLeafType() == LeafType.LOLLIPOP_HALF) {
            this.bibliotekon.getNode(this.link.getEntity1()).addImpact(this.dotPath.getStartAngle() + Math.PI);
        }
        if (this.link.getEntity2().getLeafType() == LeafType.LOLLIPOP_HALF) {
            this.bibliotekon.getNode(this.link.getEntity2()).addImpact(this.dotPath.getEndAngle());
        }
        if (this.extremity1 instanceof Extremity && this.extremity2 instanceof Extremity) {
            XPoint2D p1 = ((Extremity)this.extremity1).somePoint();
            XPoint2D p2 = ((Extremity)this.extremity2).somePoint();
            if (p1 != null && p2 != null) {
                double dist1start = p1.distance(this.dotPath.getStartPoint());
                double dist1end = p1.distance(this.dotPath.getEndPoint());
                double dist2start = p2.distance(this.dotPath.getStartPoint());
                double dist2end = p2.distance(this.dotPath.getEndPoint());
                if (dist1start > dist1end && dist2end > dist2start) {
                    pointListIterator = lineSvg.getPointsWithThisColor(this.lineColor);
                    this.extremity2 = this.getExtremity(linkType.getDecor1(), pointListIterator, this.dotPath.getEndPoint(), this.dotPath.getEndAngle(), this.lhead, this.bibliotekon.getNode(this.link.getEntity2()));
                    this.extremity1 = this.getExtremity(linkType.getDecor2(), pointListIterator, this.dotPath.getStartPoint(), this.dotPath.getStartAngle() + Math.PI, this.ltail, this.bibliotekon.getNode(this.link.getEntity1()));
                }
            }
        }
        if ((this.hasNoteLabelText() || this.link.getLinkConstraint() != null) && (pos = this.getXY(fullSvg, this.noteLabelColor)) != null) {
            Positionable positionable = this.labelXY = this.hasNoteLabelText() ? TextBlockUtils.asPositionable(this.labelText, this.stringBounder, pos) : TextBlockUtils.asPositionable(CONSTRAINT_SPOT, this.stringBounder, pos);
        }
        if (this.startTailText != null && (pos = this.getXY(fullSvg, this.startTailColor)) != null) {
            this.startTailLabelXY = TextBlockUtils.asPositionable(this.startTailText, this.stringBounder, pos);
        }
        if (this.endHeadText != null && (pos = this.getXY(fullSvg, this.endHeadColor)) != null) {
            this.endHeadLabelXY = TextBlockUtils.asPositionable(this.endHeadText, this.stringBounder, pos);
        }
        if (!this.isOpalisable()) {
            this.setOpale(false);
        }
    }

    private boolean isOpalisable() {
        return this.dotPath.getBeziers().size() <= 1;
    }

    private XPoint2D getXY(SvgResult svgResult, int color) {
        int idx = svgResult.getIndexFromColor(color);
        if (idx == -1) {
            return null;
        }
        return SvekUtils.getMinXY(svgResult.substring(idx).extractList("points=\""));
    }

    public void drawU(UGraphic ug, Set<String> ids, UStroke suggestedStroke, Rainbow rainbow) {
        Cluster endCluster;
        Cluster cl;
        if (this.opale) {
            return;
        }
        if (this.link.isInvis()) {
            return;
        }
        if (this.dotPath == null) {
            Log.info("DotPath is null for " + this);
            return;
        }
        ug.draw(this.link.commentForSvg());
        EnumMap<UGroupType, String> typeIDent = new EnumMap<UGroupType, String>(UGroupType.class);
        typeIDent.put(UGroupType.CLASS, "link " + this.link.getEntity1().getCode() + " " + this.link.getEntity2().getCode() + " selected");
        typeIDent.put(UGroupType.ID, "link_" + this.link.getEntity1().getCode() + "_" + this.link.getEntity2().getCode());
        ug.startGroup(typeIDent);
        double x = 0.0;
        double y = 0.0;
        Url url = this.link.getUrl();
        if (url != null) {
            ug.startUrl(url);
        }
        if (this.link.isAutoLinkOfAGroup() && (cl = this.bibliotekon.getCluster((IGroup)this.link.getEntity1())) != null) {
            x += cl.getClusterPosition().getWidth();
            x -= this.dotPath.getStartPoint().getX() - cl.getClusterPosition().getMinX();
        }
        x += this.dx;
        y += this.dy;
        HColor arrowHeadColor = rainbow.getArrowHeadColor();
        HColor color = rainbow.getColor();
        if (this.link.getColors() != null) {
            HColor newColor = this.link.getColors().getColor(ColorType.ARROW, ColorType.LINE);
            if (newColor != null) {
                arrowHeadColor = color = newColor;
            }
        } else if (this.link.getSpecificColor() != null) {
            arrowHeadColor = color = this.link.getSpecificColor();
        }
        ug = ug.apply(HColors.none().bg()).apply(color);
        LinkType linkType = this.link.getType();
        UStroke stroke = suggestedStroke == null || !linkType.getStyle().isNormal() ? linkType.getStroke3(this.defaultThickness) : linkType.getStroke3(suggestedStroke);
        if (this.link.getColors() != null && this.link.getColors().getSpecificLineStroke() != null) {
            stroke = this.link.getColors().getSpecificLineStroke();
        }
        ug = ug.apply(stroke);
        DotPath todraw = this.dotPath;
        if (this.link.getEntity2().isGroup() && this.link.getEntity2().getUSymbol() instanceof USymbolFolder && (endCluster = this.bibliotekon.getCluster((IGroup)this.link.getEntity2())) != null) {
            double deltaFolderH = endCluster.checkFolderPosition(this.dotPath.getEndPoint(), ug.getStringBounder());
            todraw = this.dotPath.copy();
            todraw.moveEndPoint(0.0, deltaFolderH);
        }
        if (this.extremity1 instanceof Extremity && this.extremity2 instanceof Extremity) {
            XPoint2D p2;
            XPoint2D p1 = ((Extremity)this.extremity1).isTooSmallSoGiveThePointCloserToThisOne(todraw.getStartPoint());
            if (p1 != null) {
                todraw.forceStartPoint(p1.getX(), p1.getY());
            }
            if ((p2 = ((Extremity)this.extremity2).isTooSmallSoGiveThePointCloserToThisOne(todraw.getEndPoint())) != null) {
                todraw.forceEndPoint(p2.getX(), p2.getY());
            }
        }
        String comment = this.link.idCommentForSvg();
        String tmp = this.uniq(ids, comment);
        todraw.setCommentAndCodeLine(tmp, this.link.getCodeLine());
        this.drawRainbow(ug.apply(new UTranslate(x, y)), color, arrowHeadColor, todraw, this.link.getSupplementaryColors(), stroke);
        ug = ug.apply(new UStroke()).apply(color);
        if (this.hasNoteLabelText() && this.labelXY != null && (this.link.getNote() == null || this.link.getNote().getStrategy() != NoteLinkStrategy.HALF_NOT_PRINTED)) {
            this.labelText.drawU(ug.apply(new UTranslate(x + this.labelXY.getPosition().getX() + this.labelShield, y + this.labelXY.getPosition().getY() + this.labelShield)));
        }
        if (this.startTailText != null && this.startTailLabelXY != null && this.startTailLabelXY.getPosition() != null) {
            this.startTailText.drawU(ug.apply(new UTranslate(x + this.startTailLabelXY.getPosition().getX(), y + this.startTailLabelXY.getPosition().getY())));
        }
        if (this.endHeadText != null && this.endHeadLabelXY != null && this.endHeadLabelXY.getPosition() != null) {
            this.endHeadText.drawU(ug.apply(new UTranslate(x + this.endHeadLabelXY.getPosition().getX(), y + this.endHeadLabelXY.getPosition().getY())));
        }
        if (linkType.getMiddleDecor() != LinkMiddleDecor.NONE) {
            PointAndAngle middle = this.dotPath.getMiddle();
            double angleRad = middle.getAngle();
            double angleDeg = -angleRad * 180.0 / Math.PI;
            UDrawable mi = linkType.getMiddleDecor().getMiddleFactory(this.arrowLollipopColor, this.backgroundColor).createUDrawable(angleDeg - 45.0);
            mi.drawU(ug.apply(new UTranslate(x + middle.getX(), y + middle.getY())));
        }
        if (url != null) {
            ug.closeUrl();
        }
        if (this.link.getLinkConstraint() != null) {
            double xConstraint = x + this.labelXY.getPosition().getX();
            double yConstraint = y + this.labelXY.getPosition().getY();
            List<XPoint2D> square = this.getSquare(xConstraint, yConstraint);
            Set<XPoint2D> bez = this.dotPath.sample();
            XPoint2D minPt = null;
            double minDist = Double.MAX_VALUE;
            for (XPoint2D pt : square) {
                for (XPoint2D pt2 : bez) {
                    double distance = pt2.distance(pt);
                    if (minPt != null && !(distance < minDist)) continue;
                    minPt = pt;
                    minDist = distance;
                }
            }
            this.link.getLinkConstraint().setPosition(this.link, minPt);
            this.link.getLinkConstraint().drawMe(ug, this.skinParam);
        }
        ug.closeGroup();
    }

    public void computeKal() {
        UTranslate tr;
        if (this.kal1 != null) {
            tr = new UTranslate(this.dotPath.getStartPoint()).compose(new UTranslate(this.dx, this.dy));
            this.kal1.setTranslate(tr, this.extremity1);
        }
        if (this.kal2 != null) {
            tr = new UTranslate(this.dotPath.getEndPoint()).compose(new UTranslate(this.dx, this.dy));
            this.kal2.setTranslate(tr, this.extremity2);
        }
    }

    private List<XPoint2D> getSquare(double x, double y) {
        ArrayList<XPoint2D> result = new ArrayList<XPoint2D>();
        result.add(new XPoint2D(x, y));
        result.add(new XPoint2D(x + 5.0, y));
        result.add(new XPoint2D(x + 10.0, y));
        result.add(new XPoint2D(x, y + 5.0));
        result.add(new XPoint2D(x + 10.0, y + 5.0));
        result.add(new XPoint2D(x, y + 10.0));
        result.add(new XPoint2D(x + 5.0, y + 10.0));
        result.add(new XPoint2D(x + 10.0, y + 10.0));
        return result;
    }

    private String uniq(Set<String> ids, String comment) {
        boolean changed = ids.add(comment);
        if (changed) {
            return comment;
        }
        int i = 1;
        String candidate;
        while (!(changed = ids.add(candidate = comment + "-" + i))) {
            ++i;
        }
        return candidate;
    }

    private void drawRainbow(UGraphic ug, HColor color, HColor headColor, DotPath todraw, List<Colors> supplementaryColors, UStroke stroke) {
        UGraphic ugHead;
        ug.draw(todraw);
        LinkType linkType = this.link.getType();
        if (headColor.isTransparent()) {
            if (this.extremity1 instanceof ExtremityArrow) {
                ugHead = ug.apply(color).apply(stroke.onlyThickness());
                ((ExtremityArrow)this.extremity1).drawLineIfTransparent(ugHead);
            }
        } else if (this.extremity1 != null) {
            ugHead = ug.apply(headColor).apply(stroke.onlyThickness());
            ugHead = linkType.getDecor2().isFill() ? ugHead.apply(color.bg()) : ugHead.apply(HColors.none().bg());
            this.extremity1.drawU(ugHead);
        }
        if (headColor.isTransparent()) {
            if (this.extremity2 instanceof ExtremityArrow) {
                ugHead = ug.apply(color).apply(stroke.onlyThickness());
                ((ExtremityArrow)this.extremity2).drawLineIfTransparent(ugHead);
            }
        } else if (this.extremity2 != null) {
            ugHead = ug.apply(headColor).apply(stroke.onlyThickness());
            ugHead = linkType.getDecor1().isFill() ? ugHead.apply(color.bg()) : ugHead.apply(HColors.none().bg());
            this.extremity2.drawU(ugHead);
        }
        int i = 0;
        for (Colors colors : supplementaryColors) {
            ug.apply(new UTranslate(2 * (i + 1), 2 * (i + 1))).apply(colors.getColor(ColorType.LINE)).draw(todraw);
            ++i;
        }
    }

    public boolean isInverted() {
        return this.link.isInverted();
    }

    private double getDecorDzeta() {
        LinkType linkType = this.link.getType();
        int size1 = linkType.getDecor1().getMargin();
        int size2 = linkType.getDecor2().getMargin();
        return size1 + size2;
    }

    public double getHorizontalDzeta(StringBounder stringBounder) {
        if (this.startUid.equalsId(this.endUid)) {
            return this.getDecorDzeta();
        }
        if (!this.isHorizontal()) {
            return 0.0;
        }
        ArithmeticStrategySum strategy = new ArithmeticStrategySum();
        if (this.hasNoteLabelText()) {
            strategy.eat(this.labelText.calculateDimension(stringBounder).getWidth());
        }
        if (this.startTailText != null) {
            strategy.eat(this.startTailText.calculateDimension(stringBounder).getWidth());
        }
        if (this.endHeadText != null) {
            strategy.eat(this.endHeadText.calculateDimension(stringBounder).getWidth());
        }
        return strategy.getResult() + this.getDecorDzeta();
    }

    private boolean isHorizontal() {
        return this.link.getLength() == 1;
    }

    public double getVerticalDzeta(StringBounder stringBounder) {
        if (this.startUid.equalsId(this.endUid)) {
            return this.getDecorDzeta();
        }
        if (this.isHorizontal()) {
            return 0.0;
        }
        ArithmeticStrategySum strategy = new ArithmeticStrategySum();
        if (this.hasNoteLabelText()) {
            strategy.eat(this.labelText.calculateDimension(stringBounder).getHeight());
        }
        if (this.startTailText != null) {
            strategy.eat(this.startTailText.calculateDimension(stringBounder).getHeight());
        }
        if (this.endHeadText != null) {
            strategy.eat(this.endHeadText.calculateDimension(stringBounder).getHeight());
        }
        return strategy.getResult() + this.getDecorDzeta();
    }

    public void manageCollision(Collection<SvekNode> allNodes) {
        for (SvekNode sh : allNodes) {
            Positionable cl = PositionableUtils.addMargin(sh, 8.0, 8.0);
            if (this.startTailText != null && this.startTailLabelXY != null && PositionableUtils.intersect(cl, this.startTailLabelXY)) {
                this.startTailLabelXY = PositionableUtils.moveAwayFrom(cl, this.startTailLabelXY);
            }
            if (this.endHeadText == null || this.endHeadLabelXY == null || !PositionableUtils.intersect(cl, this.endHeadLabelXY)) continue;
            this.endHeadLabelXY = PositionableUtils.moveAwayFrom(cl, this.endHeadLabelXY);
        }
    }

    private XPoint2D avoid2(XPoint2D move, Positionable pos, SvekNode sh) {
        Oscillator oscillator = new Oscillator();
        XPoint2D orig = new XPoint2D(move.x, move.y);
        while (this.cut(pos, sh)) {
            XPoint2D m = oscillator.nextPosition();
            move = new XPoint2D(orig.x + m.x, orig.y + m.y);
        }
        return move;
    }

    private boolean cut(Positionable pos, SvekNode sh) {
        return BezierUtils.intersect(pos, sh) || this.tooClose(pos);
    }

    private boolean tooClose(Positionable pos) {
        XDimension2D dim;
        double dist = this.dotPath.getMinDist(BezierUtils.getCenter(pos));
        return dist < (dim = pos.getSize()).getWidth() / 2.0 + 2.0 || dist < dim.getHeight() / 2.0 + 2.0;
    }

    @Override
    public void moveSvek(double deltaX, double deltaY) {
        this.dx += deltaX;
        this.dy += deltaY;
    }

    public final DotPath getDotPath() {
        DotPath result = this.dotPath.copy();
        result.moveSvek(this.dx, this.dy);
        return result;
    }

    public int getLength() {
        return this.link.getLength();
    }

    public void setOpale(boolean opale) {
        this.link.setOpale(opale);
        this.opale = opale;
    }

    public boolean isOpale() {
        return this.opale;
    }

    public boolean isHorizontalSolitary() {
        return this.link.isHorizontalSolitary();
    }

    public boolean isLinkFromOrTo(IEntity group) {
        return this.link.getEntity1() == group || this.link.getEntity2() == group;
    }

    public boolean hasEntryPoint() {
        return this.link.hasEntryPoint();
    }

    public void setProjectionCluster(Cluster cluster) {
        this.projectionCluster = cluster;
    }

    @Override
    public boolean isHidden() {
        return this.link.isHidden();
    }

    public boolean sameConnections(SvekLine other) {
        return this.link.sameConnections(other.link);
    }

    private boolean isAutolink() {
        return this.link.getEntity1() == this.link.getEntity2();
    }

    public XPoint2D getMyPoint(IEntity entity) {
        if (this.link.getEntity1() == entity) {
            return this.moveDelta(this.dotPath.getStartPoint());
        }
        if (this.link.getEntity2() == entity) {
            return this.moveDelta(this.dotPath.getEndPoint());
        }
        throw new IllegalArgumentException();
    }

    private XPoint2D moveDelta(XPoint2D pt) {
        return new XPoint2D(pt.getX() + this.dx, pt.getY() + this.dy);
    }

    public boolean isLink(Link link) {
        return this.link == link;
    }

    public XPoint2D getStartContactPoint() {
        if (this.dotPath == null) {
            return null;
        }
        XPoint2D start = this.dotPath.getStartPoint();
        if (start == null) {
            return null;
        }
        return new XPoint2D(this.dx + start.getX(), this.dy + start.getY());
    }

    public XPoint2D getEndContactPoint() {
        XPoint2D end = this.dotPath.getEndPoint();
        if (end == null) {
            return null;
        }
        return new XPoint2D(this.dx + end.getX(), this.dy + end.getY());
    }

    public IEntity getOther(IEntity entity) {
        if (this.link.contains(entity)) {
            return this.link.getOther(entity);
        }
        return null;
    }

    public StyleBuilder getCurrentStyleBuilder() {
        return this.link.getStyleBuilder();
    }

    public Stereotype getStereotype() {
        return this.link.getStereotype();
    }

    public void moveStartPoint(double dx, double dy) {
        this.dotPath.moveStartPoint(dx, dy);
    }

    public void moveEndPoint(double dx, double dy) {
        this.dotPath.moveEndPoint(dx, dy);
    }
}

