/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import net.sourceforge.plantuml.ugraphic.UChange;

public class UStroke
implements UChange {
    private final double dashVisible;
    private final double dashSpace;
    private final double thickness;

    public int hashCode() {
        return Double.hashCode(this.dashVisible) + Double.hashCode(this.dashSpace) + Double.hashCode(this.thickness);
    }

    public boolean equals(Object obj) {
        UStroke other = (UStroke)obj;
        return this.dashVisible == other.dashVisible && this.dashSpace == other.dashSpace && this.thickness == other.thickness;
    }

    public String toString() {
        return this.dashVisible + "-" + this.dashSpace + "-" + this.thickness;
    }

    public UStroke(double dashVisible, double dashSpace, double thickness) {
        this.dashVisible = dashVisible;
        this.dashSpace = dashSpace;
        this.thickness = thickness;
    }

    public UStroke(double thickness) {
        this(0.0, 0.0, thickness);
    }

    public UStroke() {
        this(1.0);
    }

    public UStroke onlyThickness() {
        return new UStroke(this.thickness);
    }

    private UStroke applyThickness(UStroke thickness) {
        if (thickness == null) {
            return this;
        }
        return new UStroke(this.dashVisible, this.dashSpace, thickness.thickness);
    }

    public double getDashVisible() {
        return this.dashVisible;
    }

    public double getDashSpace() {
        return this.dashSpace;
    }

    public double getThickness() {
        return this.thickness;
    }

    public String getDasharraySvg() {
        if (this.dashVisible == 0.0) {
            return null;
        }
        return this.dashVisible + "," + this.dashSpace;
    }

    public String getDashTikz() {
        if (this.dashVisible == 0.0) {
            return null;
        }
        return "on " + this.dashVisible + "pt off " + this.dashSpace + "pt";
    }
}

