/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.color;

import java.awt.Color;
import net.sourceforge.plantuml.ugraphic.color.ColorOrder;
import net.sourceforge.plantuml.ugraphic.color.ColorUtils;
import net.sourceforge.plantuml.ugraphic.color.HColorSimple;

public abstract class ColorMapper {
    public static final ColorMapper IDENTITY = new ColorMapper(){

        @Override
        public Color fromColorSimple(HColorSimple simple) {
            return simple.getAwtColor();
        }
    };
    public static final ColorMapper DARK_MODE = new ColorMapper(){

        @Override
        public Color fromColorSimple(HColorSimple simple) {
            return ((HColorSimple)simple.darkSchemeTheme()).getAwtColor();
        }
    };
    public static final ColorMapper LIGTHNESS_INVERSE = new ColorMapper(){

        @Override
        public Color fromColorSimple(HColorSimple simple) {
            return ColorUtils.getReversed(simple.getAwtColor());
        }
    };
    public static final ColorMapper MONOCHROME = new ColorMapper(){

        @Override
        public Color fromColorSimple(HColorSimple simple) {
            return ColorUtils.getGrayScaleColor(simple.getAwtColor());
        }
    };
    public static final ColorMapper MONOCHROME_REVERSE = new ColorMapper(){

        @Override
        public Color fromColorSimple(HColorSimple simple) {
            return ColorUtils.getGrayScaleColorReverse(simple.getAwtColor());
        }
    };

    private ColorMapper() {
    }

    public abstract Color fromColorSimple(HColorSimple var1);

    public static ColorMapper reverse(final ColorOrder order) {
        return new ColorMapper(){

            @Override
            public Color fromColorSimple(HColorSimple simple) {
                return order.getReverse(simple.getAwtColor());
            }
        };
    }
}

