/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering.writers;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DelegatingWriter
extends Writer {
    protected final List<Writer> delegates;

    public DelegatingWriter(Writer ... delegates) {
        ArrayList<Writer> writers = new ArrayList<Writer>(Objects.requireNonNull(delegates, "Delegates were null!").length);
        for (Writer delegate : delegates) {
            writers.add(Objects.requireNonNull(delegate, "Delegate writer was null!"));
        }
        this.delegates = Collections.unmodifiableList(writers);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        ArrayList<Exception> writeExceptions = new ArrayList<Exception>(this.delegates.size());
        for (Writer delegate : this.delegates) {
            try {
                delegate.write(cbuf, off, len);
            }
            catch (IOException | RuntimeException writeException) {
                writeExceptions.add(writeException);
            }
        }
        if (!writeExceptions.isEmpty()) {
            throw this.mergeExceptions("writing", writeExceptions);
        }
    }

    @Override
    public void flush() throws IOException {
        ArrayList<Exception> flushExceptions = new ArrayList<Exception>(this.delegates.size());
        for (Writer delegate : this.delegates) {
            try {
                delegate.flush();
            }
            catch (IOException | RuntimeException flushException) {
                flushExceptions.add(flushException);
            }
        }
        if (!flushExceptions.isEmpty()) {
            throw this.mergeExceptions("flushing", flushExceptions);
        }
    }

    @Override
    public void close() throws IOException {
        ArrayList<Exception> closeExceptions = new ArrayList<Exception>(this.delegates.size());
        for (Writer delegate : this.delegates) {
            try {
                delegate.close();
            }
            catch (IOException | RuntimeException closeException) {
                closeExceptions.add(closeException);
            }
        }
        if (!closeExceptions.isEmpty()) {
            throw this.mergeExceptions("closing", closeExceptions);
        }
    }

    private IOException mergeExceptions(String actionVerb, Collection<Exception> exceptions) {
        if (exceptions.size() == 1) {
            Exception singleException = exceptions.iterator().next();
            if (singleException instanceof RuntimeException) {
                throw (RuntimeException)singleException;
            }
            if (singleException instanceof IOException) {
                return (IOException)singleException;
            }
        }
        IOException ioe = new IOException("Error " + actionVerb + " " + exceptions.size() + " delegate writers!");
        for (Exception suppressed : exceptions) {
            ioe.addSuppressed(suppressed);
        }
        return ioe;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.delegates;
    }
}

