/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.uml;

import java.io.IOException;
import java.util.Objects;
import nl.talsmasoftware.umldoclet.configuration.TypeDisplay;
import nl.talsmasoftware.umldoclet.uml.Namespace;

public class TypeName {
    public final String simple;
    public final String qualified;
    private final TypeName[] generics;

    public TypeName(String simpleName, String qualifiedName, TypeName ... generics) {
        this.simple = simpleName;
        this.qualified = Objects.requireNonNull(qualifiedName, "Type has no qualified name");
        this.generics = (TypeName[])generics.clone();
    }

    public TypeName[] getGenerics() {
        return (TypeName[])this.generics.clone();
    }

    private static boolean isQualified(TypeDisplay display) {
        return display != null && display.name().startsWith("QUALIFIED");
    }

    protected String toUml(TypeDisplay display, Namespace namespace) {
        StringBuilder output = new StringBuilder();
        if (display == null) {
            display = TypeDisplay.SIMPLE;
        }
        if (!TypeDisplay.NONE.equals((Object)display)) {
            try {
                if (namespace != null && this.qualified.startsWith(namespace.name + ".")) {
                    String name = this.qualified.substring(namespace.name.length() + 1);
                    if (name.indexOf(46) > 0) {
                        name = this.qualified;
                    }
                    output.append(name);
                } else if (TypeName.isQualified(display)) {
                    output.append(this.qualified);
                } else {
                    output.append(this.simple);
                }
                this.writeGenericsTo(output, TypeDisplay.QUALIFIED_GENERICS.equals((Object)display) ? display : TypeDisplay.SIMPLE);
            }
            catch (IOException ioe) {
                throw new IllegalStateException("I/O error writing type name \"" + this.qualified + "\" to the output: " + ioe.getMessage(), ioe);
            }
        }
        return output.toString();
    }

    private <A extends Appendable> A writeGenericsTo(A output, TypeDisplay genericDisplay) throws IOException {
        if (this.generics.length > 0) {
            StringBuilder buffer = new StringBuilder();
            String sep = "<";
            for (TypeName generic : this.generics) {
                buffer.append(sep).append(generic.toUml(genericDisplay, null));
                sep = ", ";
            }
            Object res = buffer.toString();
            if (TypeName.isMarkupTag((String)res)) {
                res = "<\u200b" + ((String)res).substring(1);
            }
            output.append((CharSequence)res).append(">");
        }
        return output;
    }

    private static boolean isMarkupTag(String value) {
        return value.equalsIgnoreCase("<u") || value.equalsIgnoreCase("<b") || value.equalsIgnoreCase("<i");
    }

    public int hashCode() {
        return this.qualified.hashCode();
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass().equals(other.getClass()) && this.qualified.equals(((TypeName)other).qualified);
    }

    public String toString() {
        return this.toUml(TypeDisplay.SIMPLE, null);
    }

    public static class Variable
    extends TypeName {
        private final String variable;
        private final boolean isExtends;

        private Variable(String variable, TypeName bound, boolean isExtends) {
            super(bound.simple, bound.qualified, bound.generics);
            this.variable = variable;
            this.isExtends = isExtends;
        }

        public static Variable extendsBound(String variable, TypeName bound) {
            return new Variable(variable, Objects.requireNonNull(bound, "Upper bound is <null>."), true);
        }

        public static Variable superBound(String variable, TypeName bound) {
            return new Variable(variable, Objects.requireNonNull(bound, "Lower bound is <null>."), false);
        }

        @Override
        protected String toUml(TypeDisplay display, Namespace namespace) {
            return String.format("%s %s %s", this.variable, this.isExtends ? "extends" : "super", super.toUml(display, namespace));
        }

        @Override
        public boolean equals(Object other) {
            return super.equals(other) && this.isExtends == ((Variable)other).isExtends;
        }
    }

    public static class Array
    extends TypeName {
        private Array(TypeName componentType) {
            super(componentType.simple, componentType.qualified, componentType.generics);
        }

        public static Array of(TypeName componentType) {
            return new Array(Objects.requireNonNull(componentType, "Component type of array is <null>."));
        }

        @Override
        protected String toUml(TypeDisplay display, Namespace namespace) {
            return super.toUml(display, namespace) + "[]";
        }
    }
}

