/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.html;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import nl.talsmasoftware.umldoclet.configuration.Configuration;
import nl.talsmasoftware.umldoclet.html.DiagramCollector;
import nl.talsmasoftware.umldoclet.html.DiagramFile;
import nl.talsmasoftware.umldoclet.html.HtmlFile;

public class HtmlPostprocessor {
    private final Configuration config;

    public HtmlPostprocessor(Configuration config) {
        this.config = Objects.requireNonNull(config, "Configuration is <null>.");
    }

    public boolean postProcessHtml() {
        try {
            File destinationDir = new File(this.config.destinationDirectory());
            if (!destinationDir.isDirectory() || !destinationDir.canRead()) {
                throw new IllegalStateException("Cannot read from configured destination directory \"" + destinationDir + "\"!");
            }
            Collection<DiagramFile> diagrams = new DiagramCollector(this.config).collectDiagrams();
            long count = Files.walk(destinationDir.toPath(), new FileVisitOption[0]).filter(HtmlFile::isHtmlFile).map(path -> new HtmlFile(this.config, (Path)path)).map(htmlFile -> htmlFile.process(diagrams)).filter(Boolean::booleanValue).count();
            return true;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("I/O exception postprocessing HTML files in " + this.config.destinationDirectory() + ": " + ioe.getMessage(), ioe);
        }
    }
}

