/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.html;

import java.io.File;
import nl.talsmasoftware.umldoclet.configuration.ImageConfig;
import nl.talsmasoftware.umldoclet.html.DiagramFile;
import nl.talsmasoftware.umldoclet.html.HtmlFile;
import nl.talsmasoftware.umldoclet.html.Postprocessor;
import nl.talsmasoftware.umldoclet.util.FileUtils;

final class PackageDiagramInserter
extends DiagramFile {
    private final String extension;
    private final String pathToCompare;

    PackageDiagramInserter(File basedir, File diagramFile, ImageConfig.Format format, boolean hasImagesDirectory) {
        super(basedir, diagramFile, format);
        String fileName = diagramFile.getName();
        int dotIdx = fileName.lastIndexOf(46);
        this.extension = fileName.substring(dotIdx);
        this.pathToCompare = hasImagesDirectory ? fileName.substring(0, dotIdx).replace('.', '/') + this.extension : FileUtils.relativePath(this.basedir, this.diagramFile);
    }

    private String changeHtmlFileNameToDiagram(String htmlFileName) {
        return htmlFileName.replaceFirst("package-summary.html$", "package" + this.extension);
    }

    @Override
    boolean matches(HtmlFile html) {
        return this.pathToCompare.equals(this.changeHtmlFileNameToDiagram(FileUtils.relativePath(this.basedir, html.path.toFile())));
    }

    @Override
    public Postprocessor.Inserter newInserter(String relativePathToDiagram) {
        return new Inserter(relativePathToDiagram, ImageConfig.Format.SVG.equals((Object)this.format));
    }

    private static final class Inserter
    extends Postprocessor.Inserter {
        private static final String CENTER_STYLE = "style=\"display:block;margin-left:auto;margin-right:auto;max-width:100%;\"";
        private final boolean insertAsObject;

        private Inserter(String relativePath, boolean insertAsObject) {
            super(relativePath);
            this.insertAsObject = insertAsObject;
        }

        @Override
        String process(String line) {
            if (!this.inserted) {
                int idx = line.indexOf("<table");
                if (idx >= 0) {
                    this.inserted = true;
                    return line.substring(0, idx) + this.getImageTag() + System.lineSeparator() + line.substring(idx);
                }
                idx = line.indexOf("<section class=\"summary\">");
                if (idx >= 0) {
                    this.inserted = true;
                    idx = line.indexOf(62, idx) + 1;
                    return line.substring(0, idx) + System.lineSeparator() + this.getImageTag() + System.lineSeparator() + line.substring(idx);
                }
            }
            return line;
        }

        private String getImageTag() {
            if (this.insertAsObject) {
                return "<object type=\"image/svg+xml\" data=\"" + this.relativePath + "\" style=\"display:block;margin-left:auto;margin-right:auto;max-width:100%;\"></object>";
            }
            return "<img src=\"" + this.relativePath + "\" alt=\"Package summary UML Diagram\" style=\"display:block;margin-left:auto;margin-right:auto;max-width:100%;\"/>";
        }
    }
}

