/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.javadoc;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.Reporter;
import nl.talsmasoftware.umldoclet.configuration.Configuration;
import nl.talsmasoftware.umldoclet.configuration.FieldConfig;
import nl.talsmasoftware.umldoclet.configuration.ImageConfig;
import nl.talsmasoftware.umldoclet.configuration.MethodConfig;
import nl.talsmasoftware.umldoclet.configuration.TypeDisplay;
import nl.talsmasoftware.umldoclet.configuration.Visibility;
import nl.talsmasoftware.umldoclet.javadoc.ExternalLink;
import nl.talsmasoftware.umldoclet.javadoc.LocalizedReporter;
import nl.talsmasoftware.umldoclet.javadoc.UMLOptions;
import nl.talsmasoftware.umldoclet.logging.Logger;
import nl.talsmasoftware.umldoclet.logging.Message;
import nl.talsmasoftware.umldoclet.rendering.indent.Indentation;

public class DocletConfig
implements Configuration {
    private final UMLOptions options;
    private volatile LocalizedReporter reporter;
    String plantumlServerUrl = null;
    String delegateDoclet = "jdk.javadoc.doclet.StandardDoclet";
    String destDirName = "";
    boolean renderPumlFile = false;
    boolean quiet = false;
    boolean verbose = false;
    String umlencoding;
    String docencoding;
    String encoding;
    final ImageCfg images = new ImageCfg();
    final FieldCfg fieldConfig = new FieldCfg();
    final MethodCfg methodConfig = new MethodCfg();
    List<String> excludedReferences = new ArrayList<String>(Arrays.asList("java.lang.Object", "java.lang.Enum", "java.lang.annotation.Annotation"));
    List<String> excludedPackageDependencies = new ArrayList<String>(Arrays.asList("java", "javax"));
    boolean failOnCyclicPackageDependencies = false;
    List<ExternalLink> externalLinks = new ArrayList<ExternalLink>();
    List<String> customPlantumlDirectives = new ArrayList<String>();
    private Indentation indentation = Indentation.DEFAULT;

    public DocletConfig() {
        this.options = new UMLOptions(this);
        this.reporter = new LocalizedReporter(this, null, null);
    }

    public void init(Locale locale, Reporter reporter) {
        this.reporter = new LocalizedReporter(this, reporter, locale);
    }

    public Set<Doclet.Option> mergeOptionsWith(Set<? extends Doclet.Option> standardOptions) {
        return this.options.mergeWith(standardOptions);
    }

    @Override
    public Optional<String> plantumlServerUrl() {
        return Optional.ofNullable(this.plantumlServerUrl);
    }

    @Override
    public Optional<String> delegateDocletName() {
        return Optional.ofNullable(this.delegateDoclet).filter(name -> !"false".equalsIgnoreCase((String)name));
    }

    @Override
    public Logger logger() {
        return this.reporter;
    }

    @Override
    public Indentation indentation() {
        return this.indentation;
    }

    @Override
    public String destinationDirectory() {
        return this.destDirName;
    }

    @Override
    public boolean renderPumlFile() {
        return this.renderPumlFile || !this.quiet && this.verbose;
    }

    @Override
    public ImageConfig images() {
        return this.images;
    }

    @Override
    public FieldConfig fields() {
        return this.fieldConfig;
    }

    @Override
    public MethodConfig methods() {
        return this.methodConfig;
    }

    @Override
    public List<String> excludedTypeReferences() {
        return this.excludedReferences;
    }

    @Override
    public List<String> excludedPackageDependencies() {
        return this.excludedPackageDependencies;
    }

    @Override
    public boolean failOnCyclicPackageDependencies() {
        return this.failOnCyclicPackageDependencies;
    }

    @Override
    public Optional<URI> resolveExternalLinkToType(String packageName, String type) {
        return this.externalLinks.stream().map(link -> link.resolveType(packageName, type)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    public List<String> customPlantumlDirectives() {
        return this.customPlantumlDirectives;
    }

    @Override
    public Charset umlCharset() {
        return this.umlencoding != null ? Charset.forName(this.umlencoding) : this.htmlCharset();
    }

    @Override
    public Charset htmlCharset() {
        return this.docencoding != null ? Charset.forName(this.docencoding) : (this.encoding != null ? Charset.forName(this.encoding) : Charset.defaultCharset());
    }

    private Set<Visibility> parseVisibility(String value) {
        if ("private".equals(value) || "all".equals(value)) {
            return EnumSet.allOf(Visibility.class);
        }
        if ("package".equals(value)) {
            return EnumSet.of(Visibility.PACKAGE_PRIVATE, Visibility.PROTECTED, Visibility.PUBLIC);
        }
        if ("protected".equals(value)) {
            return EnumSet.of(Visibility.PUBLIC, Visibility.PROTECTED);
        }
        if ("public".equals(value)) {
            return EnumSet.of(Visibility.PUBLIC);
        }
        this.reporter.warn(Message.WARNING_UNKNOWN_VISIBILITY, value);
        return this.parseVisibility("protected");
    }

    void showMembers(String value) {
        Set<Visibility> visibility = this.parseVisibility(value);
        this.fieldConfig.visibilities = visibility;
        this.methodConfig.visibilities = visibility;
    }

    final class ImageCfg
    implements ImageConfig {
        String directory = null;
        Collection<ImageConfig.Format> formats = null;

        ImageCfg() {
        }

        @Override
        public Optional<String> directory() {
            return Optional.ofNullable(this.directory);
        }

        void addImageFormat(String imageFormat) {
            if (imageFormat != null) {
                if (this.formats == null) {
                    this.formats = new LinkedHashSet<ImageConfig.Format>();
                }
                Stream.of(imageFormat.split("[,;]")).map(String::trim).map(String::toUpperCase).map(s -> s.replaceFirst("^\\.", "")).filter(s -> !s.isEmpty() && !"NONE".equals(s)).map(this::parseFormat).filter(Objects::nonNull).forEach(this.formats::add);
            }
        }

        private ImageConfig.Format parseFormat(String format) {
            try {
                return ImageConfig.Format.valueOf(format);
            }
            catch (IllegalArgumentException unrecognizedFormat) {
                DocletConfig.this.logger().warn(Message.WARNING_UNRECOGNIZED_IMAGE_FORMAT, format);
                return null;
            }
        }

        @Override
        public Collection<ImageConfig.Format> formats() {
            return Optional.ofNullable(this.formats).orElseGet(() -> Collections.singleton(ImageConfig.Format.SVG));
        }
    }

    static final class FieldCfg
    implements FieldConfig {
        TypeDisplay typeDisplay = TypeDisplay.SIMPLE;
        Set<Visibility> visibilities = EnumSet.of(Visibility.PROTECTED, Visibility.PUBLIC);

        FieldCfg() {
        }

        @Override
        public TypeDisplay typeDisplay() {
            return this.typeDisplay;
        }

        @Override
        public boolean include(Visibility visibility) {
            return this.visibilities.contains((Object)visibility);
        }
    }

    static final class MethodCfg
    implements MethodConfig {
        MethodConfig.ParamNames paramNames = MethodConfig.ParamNames.NONE;
        TypeDisplay paramTypes = TypeDisplay.SIMPLE;
        TypeDisplay returnType = TypeDisplay.SIMPLE;
        Set<Visibility> visibilities = EnumSet.of(Visibility.PROTECTED, Visibility.PUBLIC);
        boolean javaBeanPropertiesAsFields = false;

        MethodCfg() {
        }

        @Override
        public MethodConfig.ParamNames paramNames() {
            return this.paramNames;
        }

        @Override
        public TypeDisplay paramTypes() {
            return this.paramTypes;
        }

        @Override
        public TypeDisplay returnType() {
            return this.returnType;
        }

        @Override
        public boolean include(Visibility visibility) {
            return this.visibilities.contains((Object)visibility);
        }

        @Override
        public boolean javaBeanPropertiesAsFields() {
            return this.javaBeanPropertiesAsFields;
        }
    }
}

