/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering.indent;

import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import nl.talsmasoftware.umldoclet.rendering.indent.Indentation;

public class IndentingWriter
extends Writer {
    private final Appendable delegate;
    private final Indentation indentation;
    private final AtomicBoolean addWhitespace = new AtomicBoolean(false);
    private char lastWritten = (char)10;

    protected IndentingWriter(Appendable delegate, Indentation indentation) {
        this(delegate, indentation, '\n', false);
    }

    private IndentingWriter(Appendable delegate, Indentation indentation, char lastWritten, boolean addWhitespace) {
        super(Objects.requireNonNull(delegate, "Delegate writer is required."));
        this.delegate = delegate;
        this.indentation = indentation == null ? Indentation.DEFAULT : indentation;
        this.lastWritten = lastWritten;
        this.addWhitespace.set(addWhitespace);
    }

    public static IndentingWriter wrap(Appendable delegate, Indentation indentation) {
        return delegate instanceof IndentingWriter ? ((IndentingWriter)delegate).withIndentation(indentation) : new IndentingWriter(delegate, indentation);
    }

    public IndentingWriter withIndentation(Indentation newIndentation) {
        return newIndentation == null || this.indentation.equals(newIndentation) ? this : new IndentingWriter(this.delegate, newIndentation, this.lastWritten, this.addWhitespace.get());
    }

    protected Indentation getIndentation() {
        return this.indentation;
    }

    public IndentingWriter indent() {
        return this.withIndentation(this.getIndentation().increase());
    }

    public IndentingWriter unindent() {
        return this.withIndentation(this.getIndentation().decrease());
    }

    public IndentingWriter whitespace() {
        this.addWhitespace.set(true);
        return this;
    }

    private static boolean isEol(char ch) {
        return ch == '\r' || ch == '\n';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            char ch = cbuf[off];
            Object object = this.lock;
            synchronized (object) {
                if (this.addWhitespace.compareAndSet(true, false) && !Character.isWhitespace(this.lastWritten) && !Character.isWhitespace(ch)) {
                    this.delegate.append(' ');
                    this.lastWritten = (char)32;
                }
                for (int i = 0; i < len; ++i) {
                    ch = cbuf[off + i];
                    if (IndentingWriter.isEol(this.lastWritten) && !IndentingWriter.isEol(ch)) {
                        this.delegate.append(this.indentation);
                    }
                    this.delegate.append(ch);
                    this.lastWritten = ch;
                }
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.delegate instanceof Flushable) {
            ((Flushable)((Object)this.delegate)).flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.delegate instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.delegate)).close();
            }
            catch (IOException | RuntimeException rethrowable) {
                throw rethrowable;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unexpected exception closing " + this + ": " + e.getMessage(), e);
            }
        }
    }

    public String toString() {
        return this.delegate.toString();
    }
}

