/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.uml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;
import nl.talsmasoftware.umldoclet.uml.Namespace;
import nl.talsmasoftware.umldoclet.uml.TypeName;
import nl.talsmasoftware.umldoclet.uml.UMLNode;

public class Reference
extends UMLNode {
    public final Side from;
    public final Side to;
    public final String type;
    public final Collection<String> notes;

    public Reference(Side from, String type, Side to, String ... notes) {
        this(from, type, to, notes == null ? Collections.emptySet() : Arrays.asList(notes));
    }

    private Reference(Side from, String type, Side to, Collection<String> notes) {
        super(null);
        this.from = Objects.requireNonNull(from, "Reference \"from\" side is <null>.");
        this.type = Objects.requireNonNull(type, "Reference type is <null>.").trim();
        if (this.type.isEmpty()) {
            throw new IllegalArgumentException("Reference type is empty.");
        }
        this.to = Objects.requireNonNull(to, "Reference \"to\" side is <null>.");
        this.notes = notes.stream().filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Side from(String qualifiedName, String cardinality) {
        return new Side(qualifiedName, cardinality, true);
    }

    public static Side to(String qualifiedName, String cardinality) {
        return new Side(qualifiedName, cardinality, false);
    }

    public boolean isSelfReference() {
        return this.from.qualifiedName.equals(this.to.qualifiedName);
    }

    public Reference addNote(String note) {
        String trimmed;
        String string = trimmed = note != null ? note.trim() : "";
        if (trimmed.isEmpty() || this.notes.contains(trimmed)) {
            return this;
        }
        ArrayList<String> newNotes = new ArrayList<String>(this.notes.size() + 1);
        newNotes.addAll(this.notes);
        newNotes.add(trimmed);
        return new Reference(this.from, this.type, this.to, newNotes);
    }

    private Reference inverse() {
        return new Reference(Reference.from(this.to.qualifiedName, this.to.cardinality), this.reverseType(), Reference.to(this.from.qualifiedName, this.from.cardinality), this.notes);
    }

    public Reference canonical() {
        return this.type.startsWith("<-") || this.type.startsWith("<..") || this.type.endsWith("-|>") || this.type.endsWith("..|>") || this.type.endsWith("-*") || this.type.endsWith("-o") || this.type.endsWith("-+") ? this.inverse() : this;
    }

    @Override
    public <IPW extends IndentingPrintWriter> IPW writeTo(IPW output) {
        Namespace namespace = this.findParent(Namespace.class).orElse(null);
        output.append(this.from.toString(namespace)).whitespace().append(this.type).whitespace().append(this.to.toString(namespace));
        if (!this.notes.isEmpty()) {
            output.append(": ").append(String.join((CharSequence)"\\n", this.notes));
        }
        output.newline();
        return output;
    }

    public boolean contains(TypeName typeName) {
        return this.from.matches(typeName) || this.to.matches(typeName);
    }

    public int hashCode() {
        Reference ref = this.canonical();
        return Objects.hash(ref.from, ref.type, ref.to);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Reference)) {
            return false;
        }
        Reference t_c = this.canonical();
        Reference o_c = ((Reference)other).canonical();
        return t_c.from.equals(o_c.from) && t_c.type.equals(o_c.type) && t_c.to.equals(o_c.to);
    }

    private String reverseType() {
        char[] chars = this.type.toCharArray();
        int j = chars.length - 1;
        for (int i = 0; i < j; ++i) {
            char swap = chars[i];
            chars[i] = Reference.reverseChar(chars[j]);
            chars[j--] = Reference.reverseChar(swap);
        }
        return String.valueOf(chars);
    }

    private static char reverseChar(char ch) {
        return (char)(ch == '<' ? 62 : (ch == '>' ? 60 : (ch == '{' ? 125 : (ch == '}' ? 123 : (int)ch))));
    }

    public static final class Side {
        private final boolean nameFirst;
        private final String qualifiedName;
        private final String cardinality;

        private Side(String qualifiedName, String cardinality, boolean nameFirst) {
            Objects.requireNonNull(qualifiedName, "Name of referred object is <null>.");
            this.qualifiedName = qualifiedName.substring(0, Side.indexOrLengthOf(qualifiedName, '<')).trim();
            if (this.qualifiedName.isEmpty()) {
                throw new IllegalArgumentException("Name of referred object is empty.");
            }
            this.cardinality = cardinality == null ? "" : cardinality.trim();
            this.nameFirst = nameFirst;
        }

        private boolean matches(TypeName typeName) {
            return typeName != null && this.qualifiedName.equals(typeName.qualified);
        }

        public int hashCode() {
            return Objects.hash(this.qualifiedName, this.cardinality);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Side && this.qualifiedName.equals(((Side)other).qualifiedName) && this.cardinality.equals(((Side)other).cardinality);
        }

        private String toString(Namespace namespace) {
            String name = this.qualifiedName;
            if (namespace != null && name.startsWith(namespace.name + ".") && (name = name.substring(namespace.name.length() + 1)).indexOf(46) > 0) {
                name = this.qualifiedName;
            }
            return this.cardinality.isEmpty() ? name : (this.nameFirst ? name + " \"" + this.cardinality + "\"" : "\"" + this.cardinality + "\" " + name);
        }

        public String toString() {
            return this.toString(null);
        }

        private static int indexOrLengthOf(String value, char ch) {
            int idx = value.indexOf(ch);
            return idx >= 0 ? idx : value.length();
        }
    }
}

