/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.uml;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import nl.talsmasoftware.umldoclet.configuration.Configuration;
import nl.talsmasoftware.umldoclet.rendering.indent.Indentation;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;
import nl.talsmasoftware.umldoclet.uml.Diagram;

public abstract class UMLNode {
    private UMLNode parent;
    private final List<UMLNode> children = new ArrayList<UMLNode>();

    protected UMLNode(UMLNode parent) {
        this.parent = parent;
    }

    public UMLNode getParent() {
        return this.parent;
    }

    public void setParent(UMLNode parent) {
        this.parent = parent;
    }

    protected <U extends UMLNode> Optional<U> findParent(Class<U> nodeType) {
        Set traversed = Collections.newSetFromMap(new IdentityHashMap());
        for (UMLNode parent = this.getParent(); parent != null && traversed.add(parent); parent = parent.getParent()) {
            if (!nodeType.isInstance(parent)) continue;
            return Optional.of((UMLNode)nodeType.cast(parent));
        }
        return Optional.empty();
    }

    public List<UMLNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public <T extends UMLNode> List<T> getChildren(Class<T> type) {
        return Collections.unmodifiableList(this.getChildren().stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList()));
    }

    public void addChild(UMLNode child) {
        this.children.add(child);
        child.setParent(this);
    }

    public boolean removeChildren(Predicate<? super UMLNode> condition) {
        return this.children.removeIf(condition);
    }

    protected Configuration getConfiguration() {
        return this.findParent(Diagram.class).map(Diagram::getConfiguration).orElseThrow(() -> new IllegalStateException("Cannot obtain configuration!"));
    }

    protected abstract <IPW extends IndentingPrintWriter> IPW writeTo(IPW var1);

    protected <IPW extends IndentingPrintWriter> IPW writeChildrenTo(IPW output) {
        this.getChildren().forEach(child -> child.writeTo(output));
        return output;
    }

    public String toString() {
        return this.writeTo(IndentingPrintWriter.wrap(new StringWriter(), this.indentation())).toString();
    }

    private Indentation indentation() {
        try {
            return Objects.requireNonNull(this.getConfiguration().indentation());
        }
        catch (RuntimeException noConfig) {
            return Indentation.DEFAULT;
        }
    }
}

