/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.uml.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import nl.talsmasoftware.umldoclet.configuration.Visibility;
import nl.talsmasoftware.umldoclet.uml.Field;
import nl.talsmasoftware.umldoclet.uml.Method;
import nl.talsmasoftware.umldoclet.uml.Parameters;
import nl.talsmasoftware.umldoclet.uml.Type;
import nl.talsmasoftware.umldoclet.uml.TypeMember;
import nl.talsmasoftware.umldoclet.uml.TypeName;
import nl.talsmasoftware.umldoclet.uml.UMLNode;

public class JavaBeanProperty {
    private final String name;
    private Field field;
    private Method getter;
    private Method setter;

    private JavaBeanProperty(String name) {
        this.name = name;
    }

    public static Collection<JavaBeanProperty> detectFrom(Type type) {
        if (type == null) {
            return Collections.emptySet();
        }
        LinkedHashMap propertiesByName = new LinkedHashMap();
        type.getChildren().stream().filter(TypeMember.class::isInstance).map(TypeMember.class::cast).filter(typeMember -> Visibility.PUBLIC.equals((Object)typeMember.getVisibility())).forEach(typeMember -> JavaBeanProperty.propertyNameOf(typeMember).ifPresent(propertyName -> propertiesByName.computeIfAbsent(propertyName, JavaBeanProperty::new).add((TypeMember)typeMember)));
        return propertiesByName.values();
    }

    private static Optional<String> propertyNameOf(TypeMember member) {
        Optional<String> propertyName = Optional.empty();
        if (member instanceof Field) {
            propertyName = Optional.of(member.name);
        } else if (member instanceof Method) {
            propertyName = JavaBeanProperty.propertyNameOfAccessor((Method)member);
        }
        return propertyName;
    }

    private void add(TypeMember member) {
        if (member instanceof Field) {
            this.field = (Field)member;
        } else if (member instanceof Method) {
            if (member.name.startsWith("set")) {
                this.setter = (Method)member;
            } else {
                this.getter = (Method)member;
            }
        }
    }

    void replaceGetterAndSetterByField() {
        if (this.getter != null && this.setter != null) {
            Type type = (Type)this.getter.getParent();
            this.field = new Field(type, this.name, this.getter.type);
            this.field.setVisibility(this.getter.getVisibility());
            type.removeChildren(this::isSameProperty);
            type.addChild(this.field);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSameProperty(UMLNode node) {
        if (!(node instanceof TypeMember)) return false;
        if (!JavaBeanProperty.propertyNameOf((TypeMember)node).filter(this.name::equals).isPresent()) return false;
        return true;
    }

    private static Optional<String> propertyNameOfAccessor(Method method) {
        Optional<String> propertyName = Optional.empty();
        if (!method.isStatic && !method.isAbstract) {
            if (JavaBeanProperty.isGetterMethod(method) || JavaBeanProperty.isSetterMethod(method)) {
                propertyName = Optional.of(JavaBeanProperty.decapitalize(method.name.substring(3)));
            } else if (JavaBeanProperty.isBooleanGetterMethod(method)) {
                propertyName = Optional.of(JavaBeanProperty.decapitalize(method.name.substring(2)));
            }
        }
        return propertyName;
    }

    private static boolean isGetterMethod(Method method) {
        return method.type != null && method.name.startsWith("get") && JavaBeanProperty.parameterCount(method) == 0;
    }

    private static boolean isBooleanGetterMethod(Method method) {
        return JavaBeanProperty.isBooleanType(method.type) && method.name.startsWith("is") && JavaBeanProperty.parameterCount(method) == 0;
    }

    private static boolean isSetterMethod(Method method) {
        return method.name.startsWith("set") && JavaBeanProperty.parameterCount(method) == 1;
    }

    private static int parameterCount(Method method) {
        return method.getChildren().stream().filter(Parameters.class::isInstance).map(UMLNode::getChildren).mapToInt(Collection::size).sum();
    }

    private static String decapitalize(String value) {
        if (value != null && !value.isEmpty() && Character.isUpperCase(value.charAt(0))) {
            char[] chars = value.toCharArray();
            chars[0] = Character.toLowerCase(chars[0]);
            return new String(chars);
        }
        return value;
    }

    private static boolean isBooleanType(TypeName type) {
        return type != null && ("boolean".equals(type.qualified) || "java.lang.Boolean".equals(type.qualified));
    }
}

