/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public final class FileUtils {
    private FileUtils() {
        throw new UnsupportedOperationException();
    }

    public static String relativePath(File from, File to) {
        if (from == null || to == null) {
            return null;
        }
        if (from.isFile()) {
            return FileUtils.relativePath(from.getParentFile(), to);
        }
        try {
            int skip;
            if (from.exists() && !from.isDirectory()) {
                throw new IllegalArgumentException("Not a directory: " + from);
            }
            String[] fromParts = from.getCanonicalPath().split(Pattern.quote(File.separator));
            List<String> toParts = new ArrayList<String>(Arrays.asList(to.getCanonicalPath().split(Pattern.quote(File.separator))));
            for (skip = 0; skip < fromParts.length && skip < toParts.size() && fromParts[skip].equals(toParts.get(skip)); ++skip) {
            }
            if (skip > 0) {
                toParts = toParts.subList(skip, toParts.size());
            }
            for (int i = fromParts.length; i > skip; --i) {
                toParts.add(0, "..");
            }
            return String.join((CharSequence)File.separator, toParts);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("I/O exception calculating relative path from \"" + from + "\" to \"" + to + "\": " + ioe.getMessage(), ioe);
        }
    }

    public static File ensureParentDir(File file) {
        if (file != null && !file.getParentFile().isDirectory() && !file.getParentFile().mkdirs()) {
            throw new IllegalStateException("Can't create directory \"" + file.getParent() + "\".");
        }
        return file;
    }

    public static String fileNameOf(String path) {
        return path.substring(Math.max(path.lastIndexOf(47), path.lastIndexOf(92)) + 1);
    }

    public static String withoutExtension(String path) {
        if (path != null) {
            int lastDot = path.lastIndexOf(46);
            int lastSlash = path.lastIndexOf(47);
            if (lastDot > 0 && lastDot > lastSlash) {
                return path.substring(0, lastDot);
            }
        }
        return path;
    }

    public static Reader openReaderTo(String basedir, URI uri, String charsetName) throws IOException {
        if ("file".equals(uri.getScheme()) || uri.getScheme() == null) {
            File f;
            File file = f = uri.isAbsolute() ? new File(uri) : new File(uri.toASCIIString());
            if (!f.exists()) {
                f = new File(basedir, uri.toASCIIString());
            }
            return new InputStreamReader(Files.newInputStream(f.toPath(), new OpenOption[0]), charsetName);
        }
        return new InputStreamReader(uri.toURL().openStream(), charsetName);
    }

    public static boolean hasExtension(Object file, String extension) {
        if (file == null || extension == null) {
            return false;
        }
        return FileUtils.endsWithIgnoreCase(file.toString(), (String)(extension.startsWith(".") ? extension : "." + extension));
    }

    private static boolean endsWithIgnoreCase(String subject, String extension) {
        int extensionLength;
        int subjectLength = subject.length();
        return subjectLength >= (extensionLength = extension.length()) && subject.substring(subjectLength - extensionLength).equalsIgnoreCase(extension);
    }
}

