/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.html;

import java.io.File;
import java.nio.file.Path;
import nl.talsmasoftware.umldoclet.configuration.ImageConfig;
import nl.talsmasoftware.umldoclet.html.DiagramFile;
import nl.talsmasoftware.umldoclet.html.HtmlFile;
import nl.talsmasoftware.umldoclet.html.Postprocessor;

final class PackageDependenciesInserter
extends DiagramFile {
    private final Path index;
    private final Path overviewSummary;
    private final Path moduleSummary;

    PackageDependenciesInserter(File basedir, File diagramFile, ImageConfig.Format format) {
        super(basedir, diagramFile, format);
        this.index = new File(basedir, "index.html").toPath();
        this.overviewSummary = new File(basedir, "overview-summary.html").toPath();
        this.moduleSummary = "package-dependencies.svg".equals(diagramFile.getName()) ? new File(diagramFile.getParent(), "module-summary.html").toPath() : null;
    }

    @Override
    boolean matches(HtmlFile htmlFile) {
        Path path = htmlFile.path;
        return this.index.equals(path) || this.overviewSummary.equals(path) || this.moduleSummary.equals(path);
    }

    @Override
    public Postprocessor.Inserter newInserter(String relativePathToDiagram) {
        return new Inserter(relativePathToDiagram, ImageConfig.Format.SVG.equals((Object)this.format));
    }

    private static final class Inserter
    extends Postprocessor.Inserter {
        private static final String CENTER_STYLE = "style=\"display:block;margin-left:auto;margin-right:auto;max-width:95%;\"";
        private final boolean insertAsObject;

        private Inserter(String relativePath, boolean insertAsObject) {
            super(relativePath);
            this.insertAsObject = insertAsObject;
        }

        @Override
        String process(String line) {
            if (!this.inserted) {
                int idx = line.indexOf("<table");
                if (idx >= 0) {
                    this.inserted = true;
                    return line.substring(0, idx) + this.getImageTag() + System.lineSeparator() + line.substring(idx);
                }
                idx = line.indexOf("<div id=\"all-packages-table\">");
                if (idx >= 0) {
                    this.inserted = true;
                    idx = line.indexOf(62, idx) + 1;
                    return line.substring(0, idx) + System.lineSeparator() + this.getImageTag() + System.lineSeparator() + line.substring(idx);
                }
                idx = line.indexOf("<div class=\"module-signature\">");
                if (idx >= 0) {
                    this.inserted = true;
                    idx = line.indexOf(62, idx) + 1;
                    return line.substring(0, idx) + System.lineSeparator() + this.getImageTag() + System.lineSeparator() + line.substring(idx);
                }
            }
            return line;
        }

        private String getImageTag() {
            if (this.insertAsObject) {
                return "<object type=\"image/svg+xml\" data=\"" + this.relativePath + "\" style=\"display:block;margin-left:auto;margin-right:auto;max-width:95%;\"></object>";
            }
            return "<img src=\"" + this.relativePath + "\" alt=\"Package dependencies\" style=\"display:block;margin-left:auto;margin-right:auto;max-width:95%;\"/>";
        }
    }
}

