/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.SvekEdge;
import net.sourceforge.plantuml.svek.SvekNode;

public class Bibliotekon {
    private final List<Cluster> allCluster = new ArrayList<Cluster>();
    private final Map<Entity, SvekNode> nodeMap = new LinkedHashMap<Entity, SvekNode>();
    private final List<SvekEdge> lines0 = new ArrayList<SvekEdge>();
    private final List<SvekEdge> lines1 = new ArrayList<SvekEdge>();
    private final List<SvekEdge> allLines = new ArrayList<SvekEdge>();
    private final Collection<Link> links;

    public Bibliotekon(Collection<Link> links) {
        this.links = links;
    }

    public SvekNode createNode(Entity ent, IEntityImage image, ColorSequence colorSequence, StringBounder stringBounder) {
        SvekNode node = new SvekNode(ent, image, colorSequence, stringBounder);
        this.nodeMap.put(ent, node);
        return node;
    }

    public Cluster getCluster(Entity ent) {
        for (Cluster cl : this.allCluster) {
            if (!cl.getGroups().contains(ent)) continue;
            return cl;
        }
        return null;
    }

    public void addLine(SvekEdge line) {
        this.allLines.add(line);
        if (Bibliotekon.first(line)) {
            if (line.hasNoteLabelText()) {
                for (int i = 0; i < this.lines0.size(); ++i) {
                    SvekEdge other = this.lines0.get(i);
                    if (other.hasNoteLabelText() || !line.sameConnections(other)) continue;
                    this.lines0.add(i, line);
                    return;
                }
                this.lines0.add(line);
            } else {
                this.lines0.add(line);
            }
        } else {
            this.lines1.add(line);
        }
    }

    private static boolean first(SvekEdge line) {
        int length = line.getLength();
        return length == 1;
    }

    public void addCluster(Cluster current) {
        this.allCluster.add(current);
    }

    public SvekNode getNode(Entity ent) {
        return this.nodeMap.get(ent);
    }

    public String getNodeUid(Entity ent) {
        SvekNode result = this.getNode(ent);
        if (result != null) {
            String uid = result.getUid();
            if (result.isShielded()) {
                uid = uid + ":h";
            }
            return uid;
        }
        if (ent.isGroup()) {
            return Cluster.getSpecialPointId(ent);
        }
        throw new IllegalStateException();
    }

    public String getWarningOrError(int warningOrError) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Entity, SvekNode> ent : this.nodeMap.entrySet()) {
            SvekNode sh = ent.getValue();
            double maxX = sh.getMinX() + sh.getWidth();
            if (!(maxX > (double)warningOrError)) continue;
            Entity entity = ent.getKey();
            sb.append(entity.getName() + " is overpassing the width limit.");
            sb.append("\n");
        }
        return sb.length() == 0 ? "" : sb.toString();
    }

    public Map<String, Double> getMaxX() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (Map.Entry<Entity, SvekNode> ent : this.nodeMap.entrySet()) {
            SvekNode sh = ent.getValue();
            double maxX = sh.getMinX() + sh.getWidth();
            Entity entity = ent.getKey();
            result.put(entity.getName(), maxX);
        }
        return Collections.unmodifiableMap(result);
    }

    public List<SvekEdge> allLines() {
        return Collections.unmodifiableList(this.allLines);
    }

    public List<SvekEdge> lines0() {
        return Collections.unmodifiableList(this.lines0);
    }

    public List<SvekEdge> lines1() {
        return Collections.unmodifiableList(this.lines1);
    }

    public List<Cluster> allCluster() {
        return Collections.unmodifiableList(this.allCluster);
    }

    public Collection<SvekNode> allNodes() {
        return Collections.unmodifiableCollection(this.nodeMap.values());
    }

    public List<SvekEdge> getAllLineConnectedTo(Entity leaf) {
        ArrayList<SvekEdge> result = new ArrayList<SvekEdge>();
        for (SvekEdge line : this.allLines) {
            if (!line.isLinkFromOrTo(leaf)) continue;
            result.add(line);
        }
        return Collections.unmodifiableList(result);
    }

    public SvekEdge getLine(Link link) {
        for (SvekEdge line : this.allLines) {
            if (!line.isLink(link)) continue;
            return line;
        }
        throw new IllegalArgumentException();
    }

    public Entity getOnlyOther(Entity entity) {
        for (Link link : this.links) {
            Entity other;
            if (!link.contains(entity) || (other = link.getOther(entity)) == null) continue;
            return other;
        }
        return null;
    }

    public Entity getLeaf(SvekNode node) {
        for (Map.Entry<Entity, SvekNode> ent : this.nodeMap.entrySet()) {
            if (ent.getValue() != node) continue;
            return ent.getKey();
        }
        throw new IllegalArgumentException();
    }
}

