/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.javadoc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import jdk.javadoc.doclet.DocletEnvironment;
import nl.talsmasoftware.umldoclet.configuration.Configuration;
import nl.talsmasoftware.umldoclet.configuration.Visibility;
import nl.talsmasoftware.umldoclet.javadoc.TypeNameVisitor;
import nl.talsmasoftware.umldoclet.javadoc.TypeNameWithCardinality;
import nl.talsmasoftware.umldoclet.uml.ClassDiagram;
import nl.talsmasoftware.umldoclet.uml.Diagram;
import nl.talsmasoftware.umldoclet.uml.Field;
import nl.talsmasoftware.umldoclet.uml.Method;
import nl.talsmasoftware.umldoclet.uml.Namespace;
import nl.talsmasoftware.umldoclet.uml.PackageDiagram;
import nl.talsmasoftware.umldoclet.uml.Parameters;
import nl.talsmasoftware.umldoclet.uml.Reference;
import nl.talsmasoftware.umldoclet.uml.Type;
import nl.talsmasoftware.umldoclet.uml.TypeName;
import nl.talsmasoftware.umldoclet.uml.UMLNode;
import nl.talsmasoftware.umldoclet.uml.UmlCharacters;
import nl.talsmasoftware.umldoclet.uml.util.UmlPostProcessors;

public class UMLFactory {
    private static final UmlPostProcessors POST_PROCESSORS = new UmlPostProcessors();
    private static final Predicate<UMLNode> IS_ABSTRACT_METHOD = node -> node instanceof Method && ((Method)node).isAbstract;
    final Configuration config;
    private final DocletEnvironment env;
    private final Function<TypeMirror, TypeNameWithCardinality> typeNameWithCardinality;
    private Collection<ExecutableElement> _methodsFromExcludedSuperclasses = null;

    public UMLFactory(Configuration config, DocletEnvironment env) {
        this.config = Objects.requireNonNull(config, "Configuration is <null>.");
        this.env = Objects.requireNonNull(env, "Doclet environment is <null>.");
        this.typeNameWithCardinality = TypeNameWithCardinality.function(env.getTypeUtils());
    }

    public Diagram createClassDiagram(TypeElement classElement) {
        Type type = this.createAndPopulateType(null, classElement);
        ClassDiagram classDiagram = new ClassDiagram(this.config, type);
        ArrayList<Object> foundTypeVariables = new ArrayList<Object>();
        ArrayList<Reference> references = new ArrayList<Reference>();
        UmlCharacters sep = UmlCharacters.NEWLINE;
        TypeMirror superclassType = classElement.getSuperclass();
        Element superclassElement = this.env.getTypeUtils().asElement(superclassType);
        while (superclassElement instanceof TypeElement && !this.includeSuperclass((TypeElement)superclassElement)) {
            superclassType = ((TypeElement)superclassElement).getSuperclass();
            superclassElement = this.env.getTypeUtils().asElement(superclassType);
        }
        if (superclassElement instanceof TypeElement) {
            TypeName superclassName = (TypeName)TypeNameVisitor.INSTANCE.visit(superclassType);
            if (superclassName.getGenerics().length > 0) {
                foundTypeVariables.add(superclassName);
            }
            if (!this.config.excludedTypeReferences().contains(superclassName.qualified)) {
                classDiagram.addChild(sep);
                Type type2 = this.createAndPopulateType(null, (TypeElement)superclassElement);
                type2.removeChildren(UMLFactory.not(IS_ABSTRACT_METHOD));
                classDiagram.addChild(type2);
                sep = UmlCharacters.EMPTY;
                references.add(new Reference(Reference.from(type.getName().qualified, null), "--|>", Reference.to(superclassName.qualified, null), new String[0]).canonical());
            }
        }
        for (TypeMirror typeMirror : classElement.getInterfaces()) {
            TypeName ifName = (TypeName)TypeNameVisitor.INSTANCE.visit(typeMirror);
            if (ifName.getGenerics().length > 0) {
                foundTypeVariables.add(ifName);
            }
            if (this.config.excludedTypeReferences().contains(ifName.qualified)) continue;
            Element implementedInterface = this.env.getTypeUtils().asElement(typeMirror);
            if (implementedInterface instanceof TypeElement) {
                classDiagram.addChild(sep);
                Type implementedType = this.createAndPopulateType(null, (TypeElement)implementedInterface);
                implementedType.removeChildren(UMLFactory.not(IS_ABSTRACT_METHOD));
                classDiagram.addChild(implementedType);
                sep = UmlCharacters.EMPTY;
            }
            references.add(new Reference(Reference.from(type.getName().qualified, null), UMLFactory.interfaceRefTypeFrom(type), Reference.to(ifName.qualified, null), new String[0]).canonical());
        }
        ElementKind enclosingKind = classElement.getEnclosingElement().getKind();
        if (enclosingKind.isClass() || enclosingKind.isInterface()) {
            TypeName typeName = (TypeName)TypeNameVisitor.INSTANCE.visit(classElement.getEnclosingElement().asType());
            if (typeName.getGenerics().length > 0) {
                foundTypeVariables.add(typeName);
            }
            if (!this.config.excludedTypeReferences().contains(typeName.qualified)) {
                Element enclosingElement = classElement.getEnclosingElement();
                if (enclosingElement instanceof TypeElement) {
                    classDiagram.addChild(sep);
                    Type enclosingType = this.createAndPopulateType(null, (TypeElement)enclosingElement);
                    enclosingType.removeChildren(UMLFactory.not(IS_ABSTRACT_METHOD));
                    classDiagram.addChild(enclosingType);
                    sep = UmlCharacters.EMPTY;
                }
                references.add(new Reference(Reference.from(type.getName().qualified, null), "--+", Reference.to(typeName.qualified, null), new String[0]).canonical());
            }
        }
        classElement.getEnclosedElements().stream().filter(child -> child.getKind().isInterface() || child.getKind().isClass()).filter(TypeElement.class::isInstance).map(TypeElement.class::cast).filter(this.env::isIncluded).forEach(innerclassElem -> {
            Type innerType = this.createType(null, (TypeElement)innerclassElem);
            classDiagram.addChild(innerType);
            references.add(new Reference(Reference.from(type.getName().qualified, null), "+--", Reference.to(innerType.getName().qualified, null), new String[0]).canonical());
        });
        if (!references.isEmpty()) {
            classDiagram.addChild(UmlCharacters.NEWLINE);
            references.forEach(classDiagram::addChild);
        }
        foundTypeVariables.forEach(foundTypeVariable -> classDiagram.getChildren().stream().filter(Type.class::isInstance).map(Type.class::cast).filter(tp -> foundTypeVariable.equals(tp.getName())).forEach(tp -> tp.updateGenericTypeVariables((TypeName)foundTypeVariable)));
        if (this.config.methods().javaBeanPropertiesAsFields()) {
            POST_PROCESSORS.javaBeanPropertiesAsFieldsPostProcessor().accept(type);
        }
        return classDiagram;
    }

    private boolean includeSuperclass(TypeElement superclass) {
        if (this.env.isIncluded(superclass)) {
            return true;
        }
        return superclass.getModifiers().contains((Object)Modifier.PUBLIC) || superclass.getModifiers().contains((Object)Modifier.PROTECTED);
    }

    public Diagram createPackageDiagram(PackageElement packageElement) {
        ModuleElement module = this.env.getElementUtils().getModuleOf(packageElement);
        PackageDiagram packageDiagram = new PackageDiagram(this.config, packageElement.getQualifiedName().toString(), module == null ? null : module.getQualifiedName().toString());
        LinkedHashMap<String, Collection<Type>> foreignTypes = new LinkedHashMap<String, Collection<Type>>();
        ArrayList<Reference> references = new ArrayList<Reference>();
        Namespace namespace = this.createPackage(packageDiagram, packageElement, foreignTypes, references, "::");
        packageDiagram.addChild(namespace);
        foreignTypes.entrySet().stream().filter(entry -> "java.lang".equals(entry.getKey()) || "java.util".equals(entry.getKey())).map(Map.Entry::getValue).forEach(types -> {
            Iterator it = types.iterator();
            while (it.hasNext()) {
                Type type = (Type)it.next();
                if (references.stream().filter(ref -> ref.contains(type.getName())).limit(3L).count() <= 2L) continue;
                references.removeIf(ref -> ref.contains(type.getName()));
                it.remove();
            }
        });
        foreignTypes.entrySet().stream().filter(entry -> !((Collection)entry.getValue()).isEmpty()).map(entry -> {
            String foreignPackage = (String)entry.getKey();
            Namespace foreignNamespace = new Namespace(packageDiagram, foreignPackage, null);
            ((Collection)entry.getValue()).forEach(foreignNamespace::addChild);
            return foreignNamespace;
        }).flatMap(foreignPackage -> Stream.of(UmlCharacters.NEWLINE, foreignPackage)).forEach(packageDiagram::addChild);
        namespace.addChild(UmlCharacters.NEWLINE);
        if (this.config.methods().javaBeanPropertiesAsFields()) {
            namespace.getChildren().stream().filter(Type.class::isInstance).map(Type.class::cast).forEach(POST_PROCESSORS.javaBeanPropertiesAsFieldsPostProcessor());
        }
        if (!references.isEmpty()) {
            packageDiagram.addChild(UmlCharacters.NEWLINE);
        }
        references.stream().map(Reference::canonical).forEach(packageDiagram::addChild);
        return packageDiagram;
    }

    Namespace packageOf(TypeElement typeElement) {
        ModuleElement module = this.env.getElementUtils().getModuleOf(typeElement);
        return new Namespace(null, this.env.getElementUtils().getPackageOf(typeElement).getQualifiedName().toString(), module == null ? null : module.getQualifiedName().toString());
    }

    Field createField(Type containingType, VariableElement variable) {
        Set<Modifier> modifiers = Objects.requireNonNull(variable, "Variable element is <null>.").getModifiers();
        Field field = new Field(containingType, variable.getSimpleName().toString(), (TypeName)TypeNameVisitor.INSTANCE.visit(variable.asType()));
        field.setVisibility(UMLFactory.visibilityOf(modifiers));
        field.isStatic = modifiers.contains((Object)Modifier.STATIC);
        field.isDeprecated = this.env.getElementUtils().isDeprecated(variable);
        return field;
    }

    private Parameters createParameters(List<? extends VariableElement> params) {
        Parameters result = new Parameters(null);
        Boolean varargs = null;
        for (VariableElement variableElement : params) {
            if (varargs == null) {
                varargs = UMLFactory.isVarArgsMethod(variableElement.getEnclosingElement());
                result = result.varargs(varargs);
            }
            result = result.add(variableElement.getSimpleName().toString(), (TypeName)TypeNameVisitor.INSTANCE.visit(variableElement.asType()));
        }
        return result;
    }

    private boolean isOnlyDefaultConstructor(Collection<ExecutableElement> constructors) {
        return constructors.size() == 1 && constructors.iterator().next().getParameters().isEmpty();
    }

    Method createConstructor(Type containingType, ExecutableElement executableElement) {
        Set<Modifier> modifiers = Objects.requireNonNull(executableElement, "Executable element is <null>.").getModifiers();
        Method constructor = new Method(containingType, containingType.getName().simple, null);
        constructor.setVisibility(UMLFactory.visibilityOf(modifiers));
        constructor.isAbstract = modifiers.contains((Object)Modifier.ABSTRACT);
        constructor.isStatic = modifiers.contains((Object)Modifier.STATIC);
        constructor.isDeprecated = this.env.getElementUtils().isDeprecated(executableElement);
        constructor.addChild(this.createParameters(executableElement.getParameters()));
        return constructor;
    }

    Method createMethod(Type containingType, ExecutableElement executableElement) {
        Set<Modifier> modifiers = Objects.requireNonNull(executableElement, "Executable element is <null>.").getModifiers();
        Method method = new Method(containingType, executableElement.getSimpleName().toString(), (TypeName)TypeNameVisitor.INSTANCE.visit(executableElement.getReturnType()));
        method.setVisibility(UMLFactory.visibilityOf(modifiers));
        method.isAbstract = modifiers.contains((Object)Modifier.ABSTRACT);
        method.isStatic = modifiers.contains((Object)Modifier.STATIC);
        method.isDeprecated = this.env.getElementUtils().isDeprecated(executableElement);
        method.addChild(this.createParameters(executableElement.getParameters()));
        return method;
    }

    static Visibility visibilityOf(Set<Modifier> modifiers) {
        return modifiers.contains((Object)Modifier.PRIVATE) ? Visibility.PRIVATE : (modifiers.contains((Object)Modifier.PROTECTED) ? Visibility.PROTECTED : (modifiers.contains((Object)Modifier.PUBLIC) ? Visibility.PUBLIC : Visibility.PACKAGE_PRIVATE));
    }

    private Type createType(Namespace containingPackage, TypeElement type) {
        Objects.requireNonNull(type, "Type element is <null>.");
        if (containingPackage == null) {
            containingPackage = this.packageOf(type);
        }
        return new Type(containingPackage, UMLFactory.typeClassificationOf(type), (TypeName)TypeNameVisitor.INSTANCE.visit(type.asType()));
    }

    private Type createAndPopulateType(Namespace containingPackage, TypeElement type) {
        return this.populateType(this.createType(containingPackage, type), type);
    }

    private static Type.Classification typeClassificationOf(TypeElement type) {
        ElementKind kind = type.getKind();
        Set<Modifier> modifiers = type.getModifiers();
        return ElementKind.ENUM.equals((Object)kind) ? Type.Classification.ENUM : (ElementKind.INTERFACE.equals((Object)kind) ? Type.Classification.INTERFACE : (ElementKind.ANNOTATION_TYPE.equals((Object)kind) ? Type.Classification.ANNOTATION : (modifiers.contains((Object)Modifier.ABSTRACT) ? Type.Classification.ABSTRACT_CLASS : Type.Classification.CLASS)));
    }

    private Type populateType(Type type, TypeElement typeElement) {
        List<? extends Element> enclosedElements = typeElement.getEnclosedElements();
        if (Type.Classification.ENUM.equals((Object)type.getClassfication())) {
            enclosedElements.stream().filter(elem -> ElementKind.ENUM_CONSTANT.equals((Object)elem.getKind())).filter(VariableElement.class::isInstance).map(VariableElement.class::cast).map(enumConst -> this.createField(type, (VariableElement)enumConst)).forEach(type::addChild);
        }
        enclosedElements.stream().filter(elem -> ElementKind.FIELD.equals((Object)elem.getKind())).filter(VariableElement.class::isInstance).map(VariableElement.class::cast).map(field -> this.createField(type, (VariableElement)field)).forEach(type::addChild);
        List<ExecutableElement> constructors = enclosedElements.stream().filter(elem -> ElementKind.CONSTRUCTOR.equals((Object)elem.getKind())).filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).collect(Collectors.toList());
        if (!this.isOnlyDefaultConstructor(constructors)) {
            constructors.stream().map(constructor -> this.createConstructor(type, (ExecutableElement)constructor)).forEach(type::addChild);
        }
        enclosedElements.stream().filter(elem -> ElementKind.METHOD.equals((Object)elem.getKind())).filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).filter(method -> !this.isMethodFromExcludedSuperclass((ExecutableElement)method)).map(method -> this.createMethod(type, (ExecutableElement)method)).forEach(type::addChild);
        return this.env.getElementUtils().isDeprecated(typeElement) ? type.deprecated() : type;
    }

    private boolean isMethodFromExcludedSuperclass(ExecutableElement method) {
        boolean result = false;
        Element containingClass = method.getEnclosingElement();
        if (containingClass.getKind().isClass() || containingClass.getKind().isInterface()) {
            result = this.methodsFromExcludedSuperclasses().stream().anyMatch(m -> this.similarMethodSignatures((ExecutableElement)m, method) && this.env.getTypeUtils().isAssignable(containingClass.asType(), m.getEnclosingElement().asType()));
        }
        result = result || this.isExcludedEnumMethod(method);
        return result;
    }

    private Collection<ExecutableElement> methodsFromExcludedSuperclasses() {
        if (this._methodsFromExcludedSuperclasses == null) {
            this._methodsFromExcludedSuperclasses = this.config.excludedTypeReferences().stream().map(this.env.getElementUtils()::getTypeElement).filter(Objects::nonNull).map(TypeElement::getEnclosedElements).flatMap(Collection::stream).filter(elem -> ElementKind.METHOD.equals((Object)elem.getKind())).filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).filter(method -> !method.getModifiers().contains((Object)Modifier.ABSTRACT)).filter(method -> UMLFactory.visibilityOf(method.getModifiers()).compareTo(Visibility.PRIVATE) > 0).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return this._methodsFromExcludedSuperclasses;
    }

    private boolean isExcludedEnumMethod(ExecutableElement method) {
        if (this.config.excludedTypeReferences().contains(Enum.class.getName()) && ElementKind.ENUM.equals((Object)method.getEnclosingElement().getKind()) && method.getModifiers().contains((Object)Modifier.STATIC)) {
            if ("values".equals(method.getSimpleName().toString()) && method.getParameters().isEmpty()) {
                return true;
            }
            if ("valueOf".equals(method.getSimpleName().toString()) && method.getParameters().size() == 1) {
                String paramType = ((TypeName)TypeNameVisitor.INSTANCE.visit((TypeMirror)method.getParameters().get((int)0).asType())).qualified;
                return String.class.getName().equals(paramType);
            }
        }
        return false;
    }

    private boolean similarMethodSignatures(ExecutableElement method1, ExecutableElement method2) {
        if (!method1.getSimpleName().equals(method2.getSimpleName())) {
            return false;
        }
        int paramCount = method1.getParameters().size();
        if (paramCount != method2.getParameters().size()) {
            return false;
        }
        Types typeUtils = this.env.getTypeUtils();
        boolean assignable1 = true;
        boolean assignable2 = true;
        for (int i = 0; i < paramCount && (assignable1 || assignable2); ++i) {
            TypeMirror param1 = method1.getParameters().get(i).asType();
            TypeMirror param2 = method2.getParameters().get(i).asType();
            assignable1 = assignable1 && typeUtils.isAssignable(param1, param2);
            assignable2 = assignable2 && typeUtils.isAssignable(param2, param1);
        }
        return assignable1 || assignable2;
    }

    private void addForeignType(Map<String, Collection<Type>> foreignTypes, Element typeElement) {
        if (foreignTypes != null && typeElement instanceof TypeElement) {
            Type type = this.createAndPopulateType(null, (TypeElement)typeElement);
            if (typeElement.getKind().isClass()) {
                type.removeChildren(child -> child instanceof Method && !((Method)child).isAbstract);
            }
            foreignTypes.computeIfAbsent(type.getPackagename(), namespace -> new LinkedHashSet()).add(type);
        }
    }

    private Collection<Reference> findPackageReferences(Namespace namespace, Map<String, Collection<Type>> foreignTypes, TypeElement typeElement, Type type, String separator) {
        LinkedHashSet<Reference> references = new LinkedHashSet<Reference>();
        TypeMirror superclassType = typeElement.getSuperclass();
        Element superclassElement = this.env.getTypeUtils().asElement(superclassType);
        while (superclassElement instanceof TypeElement && !this.includeSuperclass((TypeElement)superclassElement)) {
            superclassType = ((TypeElement)superclassElement).getSuperclass();
            superclassElement = this.env.getTypeUtils().asElement(superclassType);
        }
        if (superclassElement instanceof TypeElement) {
            TypeName superclassName = (TypeName)TypeNameVisitor.INSTANCE.visit(superclassType);
            if (!this.config.excludedTypeReferences().contains(superclassName.qualified)) {
                references.add(new Reference(Reference.from(type.getName().getQualified(separator), null), "--|>", Reference.to(superclassName.getQualified(separator), null), new String[0]));
                if (!namespace.contains(superclassName)) {
                    this.addForeignType(foreignTypes, superclassElement);
                }
            }
        }
        typeElement.getInterfaces().forEach(interfaceType -> {
            TypeName interfaceName = (TypeName)TypeNameVisitor.INSTANCE.visit((TypeMirror)interfaceType);
            if (!this.config.excludedTypeReferences().contains(interfaceName.qualified)) {
                references.add(new Reference(Reference.from(type.getName().getQualified(separator), null), UMLFactory.interfaceRefTypeFrom(type), Reference.to(interfaceName.getQualified(separator), null), new String[0]));
                if (!namespace.contains(interfaceName)) {
                    this.addForeignType(foreignTypes, this.env.getTypeUtils().asElement((TypeMirror)interfaceType));
                }
            }
        });
        ElementKind enclosingKind = typeElement.getEnclosingElement().getKind();
        if (enclosingKind.isClass() || enclosingKind.isInterface()) {
            TypeName parentType = (TypeName)TypeNameVisitor.INSTANCE.visit(typeElement.getEnclosingElement().asType());
            references.add(new Reference(Reference.from(parentType.getQualified(separator), null), "+--", Reference.to(type.getName().getQualified(separator), null), new String[0]));
        }
        typeElement.getEnclosedElements().stream().filter(member -> ElementKind.FIELD.equals((Object)member.getKind())).filter(VariableElement.class::isInstance).map(VariableElement.class::cast).filter(field -> this.config.fields().include(UMLFactory.visibilityOf(field.getModifiers()))).forEach(field -> {
            String fieldName = field.getSimpleName().toString();
            TypeNameWithCardinality fieldType = this.typeNameWithCardinality.apply(field.asType());
            if (namespace.contains(fieldType.typeName)) {
                UMLFactory.addReference(references, new Reference(Reference.from(type.getName().getQualified(separator), null), "-->", Reference.to(fieldType.typeName.getQualified(separator), fieldType.cardinality), fieldName));
                type.removeChildren(child -> child instanceof Field && ((Field)child).name.equals(fieldName));
            }
        });
        typeElement.getEnclosedElements().stream().filter(member -> ElementKind.METHOD.equals((Object)member.getKind())).filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).filter(method -> this.config.methods().include(UMLFactory.visibilityOf(method.getModifiers()))).forEach(method -> {
            String propertyName = UMLFactory.propertyName(method);
            if (propertyName != null) {
                TypeNameWithCardinality returnType = this.typeNameWithCardinality.apply(UMLFactory.propertyType(method));
                if (namespace.contains(returnType.typeName)) {
                    UMLFactory.addReference(references, new Reference(Reference.from(type.getName().getQualified(separator), null), "-->", Reference.to(returnType.typeName.getQualified(separator), returnType.cardinality), propertyName));
                    type.removeChildren(child -> child instanceof Method && ((Method)child).name.equals(method.getSimpleName().toString()));
                }
            }
        });
        return references;
    }

    private static String propertyName(ExecutableElement method) {
        char[] result = null;
        Set<Modifier> modifiers = method.getModifiers();
        if (modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.ABSTRACT) && !modifiers.contains((Object)Modifier.STATIC)) {
            String name = method.getSimpleName().toString();
            int params = method.getParameters().size();
            if (params == 0 && name.length() > 3 && name.startsWith("get")) {
                result = name.substring(3).toCharArray();
            } else if (params == 1 && name.length() > 3 && name.startsWith("set")) {
                result = name.substring(3).toCharArray();
            } else if (params == 0 && name.length() > 2 && name.startsWith("is") && UMLFactory.isBooleanPrimitive(method.getReturnType())) {
                result = name.substring(2).toCharArray();
            }
        }
        if (result != null) {
            result[0] = Character.toLowerCase((char)result[0]);
            return new String(result);
        }
        return null;
    }

    private static TypeMirror propertyType(ExecutableElement method) {
        if (method.getSimpleName().toString().startsWith("set") && !method.getParameters().isEmpty()) {
            return method.getParameters().get(0).asType();
        }
        return method.getReturnType();
    }

    private static boolean isVarArgsMethod(Element element) {
        return element instanceof ExecutableElement && ((ExecutableElement)element).isVarArgs();
    }

    private static boolean isBooleanPrimitive(TypeMirror type) {
        return "boolean".equals(((TypeName)TypeNameVisitor.INSTANCE.visit((TypeMirror)type)).qualified);
    }

    private static String interfaceRefTypeFrom(Type type) {
        boolean isExtendedBySubInterface = Type.Classification.INTERFACE.equals((Object)type.getClassfication());
        return isExtendedBySubInterface ? "--|>" : "..|>";
    }

    private static void addReference(Collection<Reference> collection, Reference reference) {
        Reference result = reference;
        Optional<Reference> found = collection.stream().filter(reference::equals).findFirst();
        if (found.isPresent()) {
            result = found.get();
            collection.remove(result);
            for (String note : reference.notes) {
                result = result.addNote(note);
            }
        }
        collection.add(result);
    }

    private static Stream<TypeElement> innerTypes(TypeElement type) {
        return Stream.concat(Stream.of(type), type.getEnclosedElements().stream().filter(TypeElement.class::isInstance).map(TypeElement.class::cast).flatMap(UMLFactory::innerTypes));
    }

    Namespace createPackage(Diagram diagram, PackageElement packageElement, Map<String, Collection<Type>> foreignTypes, List<Reference> references, String referenceSeparator) {
        ModuleElement module = this.env.getElementUtils().getModuleOf(packageElement);
        Namespace pkg = new Namespace(diagram, packageElement.getQualifiedName().toString(), module == null ? null : module.getQualifiedName().toString());
        packageElement.getEnclosedElements().stream().filter(TypeElement.class::isInstance).map(TypeElement.class::cast).flatMap(UMLFactory::innerTypes).filter(this.env::isIncluded).map(typeElement -> {
            Type type = this.createAndPopulateType(pkg, (TypeElement)typeElement);
            references.addAll(this.findPackageReferences(pkg, foreignTypes, (TypeElement)typeElement, type, referenceSeparator));
            return type;
        }).flatMap(type -> Stream.of(UmlCharacters.NEWLINE, type)).forEach(pkg::addChild);
        return pkg;
    }

    private static <T> Predicate<T> not(Predicate<T> predicate) {
        return t -> !predicate.test(t);
    }
}

