/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.uml;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sourceforge.plantuml.FileFormat;
import nl.talsmasoftware.umldoclet.configuration.Configuration;
import nl.talsmasoftware.umldoclet.configuration.ImageConfig;
import nl.talsmasoftware.umldoclet.logging.Message;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;
import nl.talsmasoftware.umldoclet.rendering.writers.StringBufferingWriter;
import nl.talsmasoftware.umldoclet.uml.Link;
import nl.talsmasoftware.umldoclet.uml.UMLNode;
import nl.talsmasoftware.umldoclet.uml.plantuml.PlantumlGenerator;
import nl.talsmasoftware.umldoclet.util.FileUtils;

public abstract class Diagram
extends UMLNode {
    private final Configuration config;
    private final PlantumlGenerator plantumlGenerator;
    private final FileFormat[] formats;
    private File diagramBaseFile;

    protected Diagram(Configuration config) {
        super(null);
        this.config = Objects.requireNonNull(config, "Configuration is <null>");
        this.plantumlGenerator = PlantumlGenerator.getPlantumlGenerator(config);
        this.formats = (FileFormat[])config.images().formats().stream().map(this::toFileFormat).filter(Objects::nonNull).toArray(FileFormat[]::new);
    }

    @Override
    public <IPW extends IndentingPrintWriter> IPW writeTo(IPW output) {
        output.append("@startuml").newline();
        IndentingPrintWriter indented = output.indent();
        this.writeCustomDirectives(this.config.customPlantumlDirectives(), indented);
        this.writeChildrenTo(indented);
        this.writeFooterTo(indented);
        output.append("@enduml").newline();
        return output;
    }

    protected <IPW extends IndentingPrintWriter> IPW writeCustomDirectives(List<String> customDirectives, IPW output) {
        customDirectives.forEach(output::println);
        if (!customDirectives.isEmpty()) {
            output.newline();
        }
        return output;
    }

    private <IPW extends IndentingPrintWriter> IPW writeFooterTo(IPW output) {
        output.append("center footer").whitespace().append("\\n").append(this.config.logger().localize(Message.DOCLET_UML_FOOTER, new Object[]{Message.DOCLET_VERSION})).newline();
        return output;
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    protected abstract File getPlantUmlFile();

    private File getDiagramBaseFile() {
        if (this.diagramBaseFile == null) {
            File destinationDir = new File(this.config.destinationDirectory());
            String relativeBaseFile = FileUtils.withoutExtension(FileUtils.relativePath(destinationDir, this.getPlantUmlFile()));
            if (this.config.images().directory().isPresent()) {
                File imageDir = new File(destinationDir, this.config.images().directory().get());
                this.diagramBaseFile = new File(imageDir, relativeBaseFile.replace('/', '.'));
            } else {
                this.diagramBaseFile = new File(destinationDir, relativeBaseFile);
            }
        }
        return this.diagramBaseFile;
    }

    private File getDiagramFile(FileFormat format) {
        File base = this.getDiagramBaseFile();
        return new File(base.getParent(), base.getName() + format.getFileSuffix());
    }

    public void render() {
        try {
            String plantumlSource = this.renderPlantumlSource();
            if (Link.linkFrom(this.getDiagramBaseFile().getParent()) || plantumlSource == null) {
                plantumlSource = super.toString();
            }
            for (FileFormat format : this.formats) {
                this.renderDiagramFile(plantumlSource, format);
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("I/O error rendering " + this + ": " + ioe.getMessage(), ioe);
        }
        finally {
            Link.linkFrom(null);
        }
    }

    private String renderPlantumlSource() throws IOException {
        if (this.config.renderPumlFile()) {
            return this.writePlantumlSourceToFile();
        }
        return null;
    }

    private String writePlantumlSourceToFile() throws IOException {
        File pumlFile = this.getPlantUmlFile();
        this.config.logger().info(Message.INFO_GENERATING_FILE, pumlFile);
        FileUtils.ensureParentDir(pumlFile);
        Link.linkFrom(pumlFile.getParent());
        try (StringBufferingWriter writer = this.createBufferingPlantumlFileWriter(pumlFile);){
            this.writeTo(IndentingPrintWriter.wrap(writer, this.config.indentation()));
            String string = writer.getBuffer().toString();
            return string;
        }
    }

    private StringBufferingWriter createBufferingPlantumlFileWriter(File pumlFile) throws IOException {
        return new StringBufferingWriter((Writer)new OutputStreamWriter(Files.newOutputStream(pumlFile.toPath(), new OpenOption[0]), this.config.umlCharset()));
    }

    private void renderDiagramFile(String plantumlSource, FileFormat format) throws IOException {
        File diagramFile = this.getDiagramFile(format);
        this.config.logger().info(Message.INFO_GENERATING_FILE, diagramFile);
        FileUtils.ensureParentDir(diagramFile);
        try (OutputStream out = Files.newOutputStream(diagramFile.toPath(), new OpenOption[0]);){
            this.plantumlGenerator.generatePlantumlDiagramFromSource(plantumlSource, format, out);
        }
    }

    @Override
    public String toString() {
        String name = this.getDiagramBaseFile().getPath();
        if (this.formats.length == 1) {
            return name + this.formats[0].getFileSuffix();
        }
        return name + Stream.of(this.formats).map(FileFormat::getFileSuffix).map(s -> s.substring(1)).collect(Collectors.joining(",", ".[", "]"));
    }

    private FileFormat toFileFormat(ImageConfig.Format format) {
        try {
            switch (format) {
                case SVG: 
                case SVG_IMG: {
                    return FileFormat.SVG;
                }
            }
            return FileFormat.valueOf(format.name());
        }
        catch (RuntimeException incompatibleFormatOrNull) {
            this.config.logger().debug((Object)Message.WARNING_UNRECOGNIZED_IMAGE_FORMAT, new Object[]{format});
            return null;
        }
    }
}

