/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.stereo.Stereotag;
import net.sourceforge.plantuml.stereo.Stereotype;

public class HideOrShow {
    private final String what;
    private final boolean show;

    public String toString() {
        return this.what + " (" + this.show + ")";
    }

    private boolean isApplyable(Entity leaf) {
        if (leaf.isRoot()) {
            throw new IllegalArgumentException();
        }
        if (this.what.startsWith("$")) {
            return this.isApplyableTag(leaf, this.what.substring(1));
        }
        if (this.what.startsWith("<<") && this.what.endsWith(">>")) {
            return this.isApplyableStereotype(leaf.getStereotype(), this.what.substring(2, this.what.length() - 2).trim());
        }
        if (this.isAboutUnlinked()) {
            return this.isApplyableUnlinked(leaf);
        }
        String fullName = leaf.getQuark().getQualifiedName();
        return this.match(fullName, this.what);
    }

    private boolean isApplyable(Stereotype stereotype) {
        if (this.what.startsWith("<<") && this.what.endsWith(">>")) {
            return this.isApplyableStereotype(stereotype, this.what.substring(2, this.what.length() - 2).trim());
        }
        return false;
    }

    public boolean isAboutUnlinked() {
        return this.what.equalsIgnoreCase("@unlinked");
    }

    private boolean isApplyableUnlinked(Entity leaf) {
        return leaf.isAloneAndUnlinked();
    }

    private boolean isApplyableStereotype(Stereotype stereotype, String pattern) {
        if (stereotype == null) {
            return false;
        }
        for (String label : stereotype.getMultipleLabels()) {
            if (!this.match(label, pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean isApplyableTag(Entity leaf, String pattern) {
        for (Stereotag tag : leaf.stereotags()) {
            if (!this.match(tag.getName(), pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean match(String name, String pattern) {
        int idx = name.indexOf("\u0001");
        if (idx != -1) {
            name = name.substring(idx + 1);
        }
        if (pattern.contains("*")) {
            String reg = "^" + pattern.replace("*", ".*") + "$";
            return name.matches(reg);
        }
        return name.equals(pattern);
    }

    public HideOrShow(String what, boolean show) {
        this.what = what;
        this.show = show;
    }

    public boolean apply(boolean hidden, Entity leaf) {
        if (this.isApplyable(leaf)) {
            return !this.show;
        }
        return hidden;
    }

    public boolean apply(boolean hidden, Stereotype stereotype) {
        if (this.isApplyable(stereotype)) {
            return !this.show;
        }
        return hidden;
    }
}

