/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.magnolia.jsr107;

import info.magnolia.module.cache.Cache;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptedCache<K, V>
implements javax.cache.Cache<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(AdaptedCache.class);
    private final Cache mgnlCache;
    private final CacheManager cacheManager;
    private final Configuration<?, ?> configuration;

    public AdaptedCache(Cache mgnlCache, CacheManager manager, Configuration<?, ?> configuration) {
        this.mgnlCache = mgnlCache;
        this.cacheManager = manager;
        this.configuration = configuration;
    }

    public synchronized V get(K key) {
        return (V)this.mgnlCache.get(key);
    }

    public synchronized Map<K, V> getAll(Set<? extends K> keys) {
        HashMap<K, Object> result = new HashMap<K, Object>();
        for (K k : keys) {
            result.put(k, this.mgnlCache.get(k));
        }
        return result;
    }

    public synchronized boolean containsKey(K key) {
        return this.mgnlCache.hasElement(key);
    }

    public synchronized void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        LOG.debug("loading ", keys);
    }

    public synchronized void put(K key, V value) {
        this.mgnlCache.put(key, value);
    }

    public synchronized V getAndPut(K key, V value) {
        this.mgnlCache.put(key, value);
        return value;
    }

    public synchronized void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.mgnlCache.put(e.getKey(), e.getValue());
        }
    }

    public synchronized boolean putIfAbsent(K key, V value) {
        if (!this.mgnlCache.hasElement(key)) {
            this.mgnlCache.put(key, value);
            return true;
        }
        return false;
    }

    public synchronized boolean remove(K key) {
        boolean result = this.mgnlCache.hasElement(key);
        this.mgnlCache.remove(key);
        return result;
    }

    public synchronized boolean remove(K key, V oldValue) {
        Object compare = this.mgnlCache.get(key);
        if (compare != null && compare.equals(oldValue)) {
            this.mgnlCache.remove(key);
            return true;
        }
        return false;
    }

    public synchronized V getAndRemove(K key) {
        V result = this.get(key);
        this.remove(key);
        return result;
    }

    public synchronized boolean replace(K key, V oldValue, V newValue) {
        Object compare = this.mgnlCache.get(key);
        if (compare != null && compare.equals(oldValue)) {
            this.mgnlCache.put(key, newValue);
            return true;
        }
        return false;
    }

    public synchronized boolean replace(K key, V value) {
        boolean result = this.mgnlCache.hasElement(key);
        if (result) {
            this.mgnlCache.put(key, value);
            return true;
        }
        return false;
    }

    public synchronized V getAndReplace(K key, V value) {
        if (this.mgnlCache.hasElement(key)) {
            Object oldValue = this.mgnlCache.get(key);
            this.mgnlCache.put(key, value);
            return (V)oldValue;
        }
        return null;
    }

    public synchronized void removeAll(Set<? extends K> keys) {
        for (K key : keys) {
            this.mgnlCache.remove(key);
        }
    }

    public synchronized void removeAll() {
        this.mgnlCache.clear();
    }

    public synchronized void clear() {
        this.mgnlCache.clear();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        return (C)this.configuration;
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        throw new UnsupportedOperationException();
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.mgnlCache.getName();
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void close() {
    }

    public boolean isClosed() {
        return false;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (this.mgnlCache.getClass().isAssignableFrom(clazz)) {
            return (T)this.mgnlCache;
        }
        throw new IllegalArgumentException();
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        throw new UnsupportedOperationException();
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        throw new UnsupportedOperationException();
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        final Iterator keys = this.mgnlCache.getKeys().iterator();
        return new Iterator<Cache.Entry<K, V>>(){

            @Override
            public boolean hasNext() {
                return keys.hasNext();
            }

            @Override
            public Cache.Entry<K, V> next() {
                final Object key = keys.next();
                return new Cache.Entry<K, V>(){

                    public K getKey() {
                        return key;
                    }

                    public V getValue() {
                        return AdaptedCache.this.get(key);
                    }

                    public <T> T unwrap(Class<T> clazz) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

