/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.magnolia.jsr107;

import com.google.inject.Provider;
import info.magnolia.module.cache.Cache;
import info.magnolia.module.cache.CacheFactory;
import info.magnolia.module.cache.mbean.CacheMonitor;
import java.net.URI;
import java.util.Properties;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import javax.inject.Inject;
import nl.vpro.magnolia.jsr107.AdaptedCache;
import nl.vpro.magnolia.jsr107.MgnlCacheConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MgnlCacheManager
implements CacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(MgnlCacheManager.class);
    @Inject
    private Provider<CacheFactory> factory;
    @Inject
    private Provider<CacheMonitor> monitor;
    private Properties properties = new Properties();

    private CacheFactory get() {
        return (CacheFactory)this.factory.get();
    }

    public CachingProvider getCachingProvider() {
        return null;
    }

    public URI getURI() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return MgnlCacheManager.class.getClassLoader();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public <K, V, C extends Configuration<K, V>> javax.cache.Cache<K, V> createCache(String cacheName, C configuration) throws IllegalArgumentException {
        LOG.info("Creating cache {}", (Object)cacheName);
        Cache mgnlCache = this.get().getCache(cacheName);
        this.ensureMonitor(cacheName);
        return new AdaptedCache(mgnlCache, this, configuration);
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        return this.getCache(cacheName);
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName) {
        if (this.get().getCacheNames().contains(cacheName)) {
            LOG.debug("Getting cache {}", (Object)cacheName);
            this.ensureMonitor(cacheName);
            return new AdaptedCache(this.get().getCache(cacheName), this, new MgnlCacheConfiguration());
        }
        return this.createCache(cacheName, null);
    }

    private void ensureMonitor(String cacheName) {
        if (!((CacheMonitor)this.monitor.get()).getAll().containsKey(cacheName)) {
            LOG.info("Adding for monitoring cache {}", (Object)cacheName);
            ((CacheMonitor)this.monitor.get()).addCache(cacheName);
        }
    }

    public Iterable<String> getCacheNames() {
        return this.get().getCacheNames();
    }

    public void destroyCache(String cacheName) {
        throw new UnsupportedOperationException();
    }

    public void enableManagement(String cacheName, boolean enabled) {
    }

    public void enableStatistics(String cacheName, boolean enabled) {
    }

    public void close() {
    }

    public boolean isClosed() {
        return false;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (((CacheFactory)this.factory.get()).getClass().isAssignableFrom(clazz)) {
            return (T)this.factory.get();
        }
        throw new IllegalArgumentException();
    }
}

