/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.magnolia.jsr107;

import info.magnolia.cms.util.MBeanUtil;
import info.magnolia.module.cache.BlockingCache;
import info.magnolia.module.cache.Cache;
import info.magnolia.module.cache.ehcache3.EhCache3Wrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import nl.vpro.magnolia.jsr107.AdaptedCacheMBean;
import nl.vpro.magnolia.jsr107.CacheValue;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.ehcache.config.CacheRuntimeConfiguration;
import org.ehcache.core.Ehcache;
import org.ehcache.event.CacheEvent;
import org.ehcache.event.CacheEventListener;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AdaptedCache<K, V>
implements javax.cache.Cache<K, V>,
AdaptedCacheMBean {
    private static final Logger log = LoggerFactory.getLogger(AdaptedCache.class);
    protected static final Object NULL = AdaptedCache.class.getName() + ".NULL";
    protected static final Object EXCEPTION = AdaptedCache.class.getName() + ".EXCEPTION";
    private static final Map<String, Listeners<?, ?>> LISTENERS = new ConcurrentHashMap();
    private final CacheManager cacheManager;
    private final Cache mgnlCache;
    private final Configuration<?, ?> configuration;
    private final Listeners<K, V> listeners;

    public AdaptedCache(Cache mgnlCache, CacheManager manager, Configuration<?, ?> configuration) {
        this.mgnlCache = mgnlCache;
        this.cacheManager = manager;
        this.configuration = configuration;
        this.listeners = LISTENERS.computeIfAbsent(this.mgnlCache.getName(), Listeners::new);
        try {
            MBeanUtil.registerMBean((String)("JSR107AdaptedCache,name=" + mgnlCache.getName()), (Object)this);
        }
        catch (Exception ise) {
            log.debug(ise.getMessage());
        }
    }

    public V get(K key) {
        CacheValue cacheValue = (CacheValue)this.mgnlCache.get(key);
        if (cacheValue == null) {
            return null;
        }
        Object result = cacheValue.orNull();
        if (Objects.equals(result, EXCEPTION)) {
            return null;
        }
        return result;
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (K k : keys) {
            if (!this.containsKey(k)) continue;
            result.put(k, this.get(k));
        }
        return result;
    }

    public boolean containsKey(K key) {
        boolean result = this.mgnlCache.hasElement(key);
        this.unlock(key);
        return result;
    }

    public V getUnblocking(K key) {
        V value = this.get(key);
        this.unlock(key);
        return value;
    }

    public void unlock(K key) {
        if (this.mgnlCache instanceof BlockingCache) {
            ((BlockingCache)this.mgnlCache).unlock(key);
        }
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        log.debug("loading {}", keys);
        throw new UnsupportedOperationException();
    }

    public void put(K key, V value) {
        CacheValue oldValue = this.listeners.has() ? (CacheValue)this.mgnlCache.getQuiet(key) : null;
        CacheValue<V> newValue = CacheValue.of(value);
        this.mgnlCache.put(key, newValue);
        if (this.listeners.has()) {
            this.handleEvent(new AdapterCacheEntry<K, V>(this, oldValue == null ? EventType.CREATED : EventType.UPDATED, key, oldValue, newValue));
        }
    }

    public V getAndPut(K key, V value) {
        V previousValue = this.get(key);
        this.put(key, value);
        return previousValue;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public boolean putIfAbsent(K key, V value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    public boolean remove(K key) {
        boolean result = this.containsKey(key);
        if (result) {
            CacheValue oldValue = (CacheValue)this.mgnlCache.getQuiet(key);
            this.mgnlCache.remove(key);
            if (this.listeners.has()) {
                this.handleEvent(this.removeEvent(key, oldValue));
            }
        }
        return result;
    }

    public boolean remove(K key, V oldValue) {
        CacheValue compare = (CacheValue)this.mgnlCache.getQuiet(key);
        if (compare != null && Objects.equals(compare.orNull(), oldValue)) {
            this.mgnlCache.remove(key);
            if (this.listeners.has()) {
                this.handleEvent(this.removeEvent(key, compare));
            }
            return true;
        }
        return false;
    }

    public V getAndRemove(K key) {
        V result = this.get(key);
        this.remove(key);
        return result;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        V compare = this.get(key);
        if (compare != null && compare.equals(oldValue)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    public boolean replace(K key, V value) {
        boolean result = this.mgnlCache.hasElement(key);
        if (result) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    public V getAndReplace(K key, V value) {
        if (this.containsKey(key)) {
            V oldValue = this.get(key);
            this.put(key, value);
            return oldValue;
        }
        return null;
    }

    public void removeAll(Set<? extends K> keys) {
        ArrayList<CacheEntryEvent<K, V>> events = new ArrayList<CacheEntryEvent<K, V>>();
        for (K key : keys) {
            CacheValue oldValue = (CacheValue)this.mgnlCache.getQuiet(key);
            this.mgnlCache.remove(key);
            if (!this.listeners.has()) continue;
            events.add(this.removeEvent(key, oldValue));
        }
        this.handleEvents(events);
    }

    public void removeAll() {
        this.removeAllEvent();
        this.mgnlCache.clear();
    }

    @Override
    public void clear() {
        this.removeAllEvent();
        this.mgnlCache.clear();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        return (C)this.configuration;
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        throw new UnsupportedOperationException();
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.mgnlCache.getName();
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void close() {
    }

    public boolean isClosed() {
        return false;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.mgnlCache.getClass())) {
            return (T)this.mgnlCache;
        }
        throw new IllegalArgumentException();
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (!this.listeners.cacheEntryListenerConfigurations.contains(cacheEntryListenerConfiguration)) {
            this.listeners.cacheEntryListenerConfigurations.add(cacheEntryListenerConfiguration);
            boolean viaEhcache = false;
            if (this.mgnlCache instanceof EhCache3Wrapper) {
                try {
                    EhCache3Wrapper ehcacheWrapper = (EhCache3Wrapper)this.mgnlCache;
                    Ehcache ehCache = (Ehcache)ehcacheWrapper.getWrappedEhCache();
                    ehCache.getRuntimeConfiguration().registerCacheEventListener(new EhcacheEventLister<K, V>(this, cacheEntryListenerConfiguration), EventOrdering.ORDERED, EventFiring.ASYNCHRONOUS, new HashSet<org.ehcache.event.EventType>(Arrays.asList(org.ehcache.event.EventType.values())));
                    viaEhcache = true;
                }
                catch (Exception e) {
                    log.warn("{}", (Throwable)e);
                }
            }
            if (!viaEhcache) {
                CacheEntryListener cacheEntryListener = (CacheEntryListener)cacheEntryListenerConfiguration.getCacheEntryListenerFactory().create();
                if (cacheEntryListener instanceof CacheEntryCreatedListener) {
                    this.listeners.createdListenerMap.put(cacheEntryListenerConfiguration, (CacheEntryCreatedListener)cacheEntryListener);
                }
                if (cacheEntryListener instanceof CacheEntryUpdatedListener) {
                    this.listeners.updatedListenerMap.put(cacheEntryListenerConfiguration, (CacheEntryUpdatedListener)cacheEntryListener);
                }
                if (cacheEntryListener instanceof CacheEntryRemovedListener) {
                    this.listeners.removedListenerMap.put(cacheEntryListenerConfiguration, (CacheEntryRemovedListener)cacheEntryListener);
                }
                this.listeners.cacheEntryEventFilter = (CacheEntryEventFilter)cacheEntryListenerConfiguration.getCacheEntryEventFilterFactory().create();
            }
        }
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (this.listeners.remove(cacheEntryListenerConfiguration) && this.mgnlCache instanceof EhCache3Wrapper) {
            try {
                EhCache3Wrapper ehcacheWrapper = (EhCache3Wrapper)this.mgnlCache;
                Ehcache ehCache = (Ehcache)ehcacheWrapper.getWrappedEhCache();
                ehCache.getRuntimeConfiguration().deregisterCacheEventListener(new EhcacheEventLister<K, V>(this, cacheEntryListenerConfiguration));
            }
            catch (Exception e) {
                log.warn("{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public String toString() {
        return "Adapted mgnl cache " + this.mgnlCache.getClass().getName() + " " + this.mgnlCache.getName();
    }

    @Override
    public int getSize() {
        return this.mgnlCache.getSize();
    }

    @Override
    public int getBlockingTimeout() {
        if (this.mgnlCache instanceof BlockingCache) {
            return ((BlockingCache)this.mgnlCache).getBlockingTimeout();
        }
        return -1;
    }

    @Override
    public String getConfiguration() {
        StringBuilder builder = new StringBuilder();
        builder.append("class=").append(this.mgnlCache.getClass().getSimpleName()).append("\n");
        builder.append("keytype=").append(this.configuration.getKeyType()).append("\n");
        builder.append("valuetype=").append(this.configuration.getValueType()).append("\n");
        if (this.mgnlCache instanceof EhCache3Wrapper) {
            CacheRuntimeConfiguration runtimeConfiguration = ((EhCache3Wrapper)this.mgnlCache).getWrappedEhCache().getRuntimeConfiguration();
            builder.append(ReflectionToStringBuilder.toString((Object)runtimeConfiguration));
        }
        return builder.toString();
    }

    protected final void handleEvent(CacheEntryEvent<? extends K, ? extends V> event) {
        this.handleEvents(Collections.singleton(event));
    }

    protected final void handleEvents(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) {
        ArrayList<CacheEntryEvent<K, V>> created = new ArrayList<CacheEntryEvent<K, V>>();
        ArrayList<CacheEntryEvent<K, V>> updated = new ArrayList<CacheEntryEvent<K, V>>();
        ArrayList<CacheEntryEvent<K, V>> removed = new ArrayList<CacheEntryEvent<K, V>>();
        block5: for (CacheEntryEvent<K, V> cacheEntryEvent : events) {
            if (this.listeners.cacheEntryEventFilter != null && !this.listeners.cacheEntryEventFilter.evaluate(cacheEntryEvent)) continue;
            switch (cacheEntryEvent.getEventType()) {
                case CREATED: {
                    created.add(cacheEntryEvent);
                    continue block5;
                }
                case UPDATED: {
                    updated.add(cacheEntryEvent);
                    continue block5;
                }
                case REMOVED: {
                    removed.add(cacheEntryEvent);
                    continue block5;
                }
            }
            log.warn("Not supported");
        }
        if (!created.isEmpty()) {
            for (CacheEntryCreatedListener cacheEntryCreatedListener : this.listeners.createdListenerMap.values()) {
                cacheEntryCreatedListener.onCreated(created);
            }
        }
        if (!updated.isEmpty()) {
            for (CacheEntryUpdatedListener cacheEntryUpdatedListener : this.listeners.updatedListenerMap.values()) {
                cacheEntryUpdatedListener.onUpdated(updated);
            }
        }
        if (!removed.isEmpty()) {
            for (CacheEntryRemovedListener cacheEntryRemovedListener : this.listeners.removedListenerMap.values()) {
                cacheEntryRemovedListener.onRemoved(removed);
            }
        }
    }

    protected final void removeAllEvent() {
        ArrayList<CacheEntryEvent<K, V>> events = new ArrayList<CacheEntryEvent<K, V>>();
        for (Object key : this.mgnlCache.getKeys()) {
            CacheValue value = (CacheValue)this.mgnlCache.getQuiet(key);
            events.add(this.removeEvent(key, value));
        }
        this.handleEvents(events);
    }

    protected final CacheEntryEvent<K, V> removeEvent(K key, CacheValue<V> oldValue) {
        return new AdapterCacheEntry<K, V>(this, EventType.REMOVED, key, oldValue, null);
    }

    public @NonNull Iterator<// Could not load outer class - annotation placement on inner may be incorrect
    Cache.Entry<K, V>> iterator() {
        final Iterator keys = this.mgnlCache.getKeys().iterator();
        return new Iterator<Cache.Entry<K, V>>(){

            @Override
            public boolean hasNext() {
                return keys.hasNext();
            }

            @Override
            public Cache.Entry<K, V> next() {
                final Object key = keys.next();
                return new Cache.Entry<K, V>(){

                    public K getKey() {
                        return key;
                    }

                    public V getValue() {
                        return AdaptedCache.this.get(key);
                    }

                    public <T> T unwrap(Class<T> clazz) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    static final class EhcacheEventLister<KK, VV>
    implements CacheEventListener {
        final CacheEntryListenerConfiguration<KK, VV> cacheEntryListenerConfiguration;
        final CacheEntryEventFilter<? super KK, ? super VV> cacheEntryEventFilter;
        final CacheEntryListener<? super KK, ? super VV> cacheEntryListener;
        final javax.cache.Cache cache;

        public EhcacheEventLister(javax.cache.Cache cache, CacheEntryListenerConfiguration<KK, VV> cacheEntryListenerConfiguration) {
            this.cacheEntryListenerConfiguration = cacheEntryListenerConfiguration;
            this.cacheEntryEventFilter = (CacheEntryEventFilter)cacheEntryListenerConfiguration.getCacheEntryEventFilterFactory().create();
            this.cacheEntryListener = (CacheEntryListener)cacheEntryListenerConfiguration.getCacheEntryListenerFactory().create();
            this.cache = cache;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EhcacheEventLister that = (EhcacheEventLister)o;
            return this.cacheEntryListenerConfiguration != null ? this.cacheEntryListenerConfiguration.equals(that.cacheEntryListenerConfiguration) : that.cacheEntryListenerConfiguration == null;
        }

        public int hashCode() {
            return this.cacheEntryListenerConfiguration != null ? this.cacheEntryListenerConfiguration.hashCode() : 0;
        }

        public void onEvent(CacheEvent cacheEvent) {
            List<CacheEntryEvent> events = Arrays.asList(new CacheEntryEvent[]{new AdapterCacheEntry(this.cache, EventType.valueOf((String)cacheEvent.getType().name()), cacheEvent.getKey(), (CacheValue)cacheEvent.getOldValue(), (CacheValue)cacheEvent.getNewValue())});
            switch (cacheEvent.getType()) {
                case EXPIRED: {
                    if (!(this.cacheEntryListener instanceof CacheEntryExpiredListener)) break;
                    ((CacheEntryExpiredListener)this.cacheEntryListener).onExpired(events);
                    break;
                }
                case EVICTED: 
                case REMOVED: {
                    if (!(this.cacheEntryListener instanceof CacheEntryRemovedListener)) break;
                    ((CacheEntryRemovedListener)this.cacheEntryListener).onRemoved(events);
                    break;
                }
                case CREATED: {
                    if (!(this.cacheEntryListener instanceof CacheEntryCreatedListener)) break;
                    ((CacheEntryCreatedListener)this.cacheEntryListener).onCreated(events);
                    break;
                }
                case UPDATED: {
                    if (!(this.cacheEntryListener instanceof CacheEntryUpdatedListener)) break;
                    ((CacheEntryUpdatedListener)this.cacheEntryListener).onUpdated(events);
                    break;
                }
                default: {
                    log.warn("Unrecognized event {}", (Object)cacheEvent);
                }
            }
        }
    }

    static final class Listeners<KK, VV> {
        final String name;
        final List<CacheEntryListenerConfiguration<KK, VV>> cacheEntryListenerConfigurations = new CopyOnWriteArrayList<CacheEntryListenerConfiguration<KK, VV>>();
        final Map<CacheEntryListenerConfiguration<KK, VV>, CacheEntryCreatedListener<KK, VV>> createdListenerMap = new ConcurrentHashMap<CacheEntryListenerConfiguration<KK, VV>, CacheEntryCreatedListener<KK, VV>>();
        final Map<CacheEntryListenerConfiguration<KK, VV>, CacheEntryUpdatedListener<KK, VV>> updatedListenerMap = new ConcurrentHashMap<CacheEntryListenerConfiguration<KK, VV>, CacheEntryUpdatedListener<KK, VV>>();
        final Map<CacheEntryListenerConfiguration<KK, VV>, CacheEntryRemovedListener<KK, VV>> removedListenerMap = new ConcurrentHashMap<CacheEntryListenerConfiguration<KK, VV>, CacheEntryRemovedListener<KK, VV>>();
        CacheEntryEventFilter<? super KK, ? super VV> cacheEntryEventFilter;

        Listeners(String name) {
            this.name = name;
        }

        public boolean has() {
            return !this.createdListenerMap.isEmpty() || !this.updatedListenerMap.isEmpty() || !this.removedListenerMap.isEmpty();
        }

        public boolean remove(CacheEntryListenerConfiguration<KK, VV> cacheEntryListenerConfiguration) {
            boolean remove = this.cacheEntryListenerConfigurations.remove(cacheEntryListenerConfiguration);
            this.createdListenerMap.remove(cacheEntryListenerConfiguration);
            this.updatedListenerMap.remove(cacheEntryListenerConfiguration);
            this.removedListenerMap.remove(cacheEntryListenerConfiguration);
            return remove;
        }
    }

    protected static class AdapterCacheEntry<KK, VV>
    extends CacheEntryEvent<KK, VV> {
        final String cache;
        final KK key;
        final CacheValue<VV> oldValue;
        final CacheValue<VV> newValue;

        protected AdapterCacheEntry(javax.cache.Cache source, EventType eventType, KK key, CacheValue<VV> oldValue, CacheValue<VV> newValue) {
            super(source, eventType);
            this.cache = source.getName();
            this.key = key;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public KK getKey() {
            return this.key;
        }

        public VV getValue() {
            return this.newValue.orNull();
        }

        public VV getOldValue() {
            return this.oldValue == null ? null : (VV)this.oldValue.orNull();
        }

        public boolean isOldValueAvailable() {
            return this.oldValue != null;
        }

        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isAssignableFrom(CacheValue.class)) {
                return (T)this.newValue;
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return this.getEventType() + " " + this.cache + "#" + this.key;
        }
    }
}

