/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.magnolia.jsr107;

import com.google.common.base.MoreObjects;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import nl.vpro.magnolia.jsr107.DefaultCacheSettings;
import nl.vpro.magnolia.jsr107.EvictionPolicy;
import nl.vpro.magnolia.jsr107.TrueFalseDefault;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheSettings {
    private static final Logger log = LoggerFactory.getLogger(CacheSettings.class);
    boolean copyOnRead;
    boolean copyOnWrite;
    boolean eternal;
    int maxElementsInMemory;
    @Deprecated
    int maxElementsOnDisk;
    int maxSizeOnDiskMB;
    @Deprecated
    EvictionPolicy memoryStoreEvictionPolicy;
    boolean overflowToDisk;
    @Deprecated
    Integer timeToIdleSeconds;
    Integer timeToLiveSeconds;
    @Deprecated
    Integer diskExpiryThreadIntervalSeconds;
    @Deprecated
    Integer diskSpoolBufferSizeMB;
    int blockingTimeout;
    boolean blocking;
    TrueFalseDefault overrideOnUpdate;

    public static CacheSettings of(DefaultCacheSettings defaults) {
        Builder builder = new Builder();
        CacheSettings.invoke(builder, defaults);
        CacheSettings settings = builder.build();
        boolean change = false;
        if (settings.isEternal()) {
            change = CacheSettings.setToNullIfDefault(defaults, "timeToIdleSeconds", builder);
            change |= CacheSettings.setToNullIfDefault(defaults, "timeToLiveSeconds", builder);
        }
        if (!settings.isOverflowToDisk()) {
            change |= CacheSettings.setToNullIfDefault(defaults, "diskExpiryThreadIntervalSeconds", builder);
            change |= CacheSettings.setToNullIfDefault(defaults, "diskSpoolBufferSizeMB", builder);
        }
        if (change) {
            settings = builder.build();
        }
        return settings;
    }

    protected static boolean setToNullIfDefault(DefaultCacheSettings defaults, String methodName, Builder builder) {
        return CacheSettings.runIfDefault(defaults, methodName, () -> {
            Method method = Arrays.stream(Builder.class.getMethods()).filter(m -> m.getName().equals(methodName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Not found " + methodName));
            try {
                method.invoke((Object)builder, new Object[]{null});
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected static boolean runIfDefault(DefaultCacheSettings defaults, String methodName, Runnable runnable) {
        try {
            Method method = DefaultCacheSettings.class.getMethod(methodName, new Class[0]);
            Object defaultValue = method.getDefaultValue();
            if (Objects.equals(method.invoke((Object)defaults, new Object[0]), defaultValue)) {
                runnable.run();
                return true;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    public static Builder builder() {
        Builder builder = new Builder();
        CacheSettings.invoke(builder, null);
        return builder;
    }

    private static void invoke(Builder builder, DefaultCacheSettings defaults) {
        for (Method m : DefaultCacheSettings.class.getDeclaredMethods()) {
            try {
                Method tm;
                try {
                    tm = builder.getClass().getMethod(m.getName(), m.getReturnType());
                }
                catch (NoSuchMethodException nsme) {
                    if (m.getReturnType().isPrimitive()) {
                        tm = builder.getClass().getMethod(m.getName(), ClassUtils.primitiveToWrapper(m.getReturnType()));
                    }
                    throw nsme;
                }
                Object value = defaults == null ? m.getDefaultValue() : m.invoke((Object)defaults, new Object[0]);
                tm.invoke((Object)builder, value);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("copyOnRead", this.copyOnRead).add("copyOnWrite", this.copyOnWrite).add("eternal", this.eternal).add("maxElementsInMemory", this.maxElementsInMemory).add("maxElementsOnDisk", this.maxElementsOnDisk).add("maxSizeOnDiskMB", this.maxSizeOnDiskMB).add("memoryStoreEvictionPolicy", (Object)this.memoryStoreEvictionPolicy).add("overflowToDisk", this.overflowToDisk).add("timeToIdleSeconds", (Object)this.timeToIdleSeconds).add("timeToLiveSeconds", (Object)this.timeToLiveSeconds).add("diskExpiryThreadIntervalSeconds", (Object)this.diskExpiryThreadIntervalSeconds).add("diskSpoolBufferSizeMB", (Object)this.diskSpoolBufferSizeMB).add("blockingTimeout", this.blockingTimeout).add("blocking", this.blocking).toString();
    }

    private CacheSettings(boolean copyOnRead, boolean copyOnWrite, boolean eternal, int maxElementsInMemory, int maxElementsOnDisk, int maxSizeOnDiskMB, EvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, Integer timeToIdleSeconds, Integer timeToLiveSeconds, Integer diskExpiryThreadIntervalSeconds, Integer diskSpoolBufferSizeMB, int blockingTimeout, boolean blocking, TrueFalseDefault overrideOnUpdate) {
        this.copyOnRead = copyOnRead;
        this.copyOnWrite = copyOnWrite;
        this.eternal = eternal;
        this.maxElementsInMemory = maxElementsInMemory;
        this.maxElementsOnDisk = maxElementsOnDisk;
        this.maxSizeOnDiskMB = maxSizeOnDiskMB;
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
        this.overflowToDisk = overflowToDisk;
        this.timeToIdleSeconds = timeToIdleSeconds;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
        this.diskSpoolBufferSizeMB = diskSpoolBufferSizeMB;
        this.blockingTimeout = blockingTimeout;
        this.blocking = blocking;
        this.overrideOnUpdate = overrideOnUpdate;
    }

    public boolean isCopyOnRead() {
        return this.copyOnRead;
    }

    public boolean isCopyOnWrite() {
        return this.copyOnWrite;
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    @Deprecated
    public int getMaxElementsOnDisk() {
        return this.maxElementsOnDisk;
    }

    public int getMaxSizeOnDiskMB() {
        return this.maxSizeOnDiskMB;
    }

    @Deprecated
    public EvictionPolicy getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    public boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    @Deprecated
    public Integer getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public Integer getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    @Deprecated
    public Integer getDiskExpiryThreadIntervalSeconds() {
        return this.diskExpiryThreadIntervalSeconds;
    }

    @Deprecated
    public Integer getDiskSpoolBufferSizeMB() {
        return this.diskSpoolBufferSizeMB;
    }

    public int getBlockingTimeout() {
        return this.blockingTimeout;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public TrueFalseDefault getOverrideOnUpdate() {
        return this.overrideOnUpdate;
    }

    public static class Builder {
        private boolean copyOnRead;
        private boolean copyOnWrite;
        private boolean eternal;
        private int maxElementsInMemory;
        private int maxElementsOnDisk;
        private int maxSizeOnDiskMB;
        private EvictionPolicy memoryStoreEvictionPolicy;
        private boolean overflowToDisk;
        private Integer timeToIdleSeconds;
        private Integer timeToLiveSeconds;
        private Integer diskExpiryThreadIntervalSeconds;
        private Integer diskSpoolBufferSizeMB;
        private int blockingTimeout;
        private boolean blocking;
        private TrueFalseDefault overrideOnUpdate;

        Builder() {
        }

        @Deprecated
        public Builder timeToIdle(Duration duration) {
            return this.timeToIdleSeconds(duration == null ? null : Integer.valueOf((int)duration.toMillis() / 1000));
        }

        public Builder timeToLive(Duration duration) {
            return this.timeToLiveSeconds(duration == null ? null : Integer.valueOf((int)duration.toMillis() / 1000));
        }

        @Deprecated
        public Builder diskExpiryThreadInterval(Duration duration) {
            return this.diskExpiryThreadIntervalSeconds(duration == null ? null : Integer.valueOf((int)duration.toMillis() / 1000));
        }

        public Builder eternal(boolean eternal) {
            if (eternal) {
                this.timeToIdleSeconds(null);
                this.timeToLiveSeconds(null);
            }
            this.eternal = eternal;
            return this;
        }

        public Builder blocking(Boolean blocking) {
            this.blocking = blocking != null && blocking != false;
            return this;
        }

        public Builder overflowToDisk(boolean overflowToDisk) {
            if (!overflowToDisk) {
                this.diskExpiryThreadInterval(null);
                this.diskSpoolBufferSizeMB(null);
            }
            this.overflowToDisk = overflowToDisk;
            return this;
        }

        public Builder copyOnRead(boolean copyOnRead) {
            this.copyOnRead = copyOnRead;
            return this;
        }

        public Builder copyOnWrite(boolean copyOnWrite) {
            this.copyOnWrite = copyOnWrite;
            return this;
        }

        public Builder maxElementsInMemory(int maxElementsInMemory) {
            this.maxElementsInMemory = maxElementsInMemory;
            return this;
        }

        @Deprecated
        public Builder maxElementsOnDisk(int maxElementsOnDisk) {
            this.maxElementsOnDisk = maxElementsOnDisk;
            return this;
        }

        public Builder maxSizeOnDiskMB(int maxSizeOnDiskMB) {
            this.maxSizeOnDiskMB = maxSizeOnDiskMB;
            return this;
        }

        @Deprecated
        public Builder memoryStoreEvictionPolicy(EvictionPolicy memoryStoreEvictionPolicy) {
            this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
            return this;
        }

        @Deprecated
        public Builder timeToIdleSeconds(Integer timeToIdleSeconds) {
            this.timeToIdleSeconds = timeToIdleSeconds;
            return this;
        }

        public Builder timeToLiveSeconds(Integer timeToLiveSeconds) {
            this.timeToLiveSeconds = timeToLiveSeconds;
            return this;
        }

        @Deprecated
        public Builder diskExpiryThreadIntervalSeconds(Integer diskExpiryThreadIntervalSeconds) {
            this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds;
            return this;
        }

        @Deprecated
        public Builder diskSpoolBufferSizeMB(Integer diskSpoolBufferSizeMB) {
            this.diskSpoolBufferSizeMB = diskSpoolBufferSizeMB;
            return this;
        }

        public Builder blockingTimeout(int blockingTimeout) {
            this.blockingTimeout = blockingTimeout;
            return this;
        }

        public Builder overrideOnUpdate(TrueFalseDefault overrideOnUpdate) {
            this.overrideOnUpdate = overrideOnUpdate;
            return this;
        }

        public CacheSettings build() {
            return new CacheSettings(this.copyOnRead, this.copyOnWrite, this.eternal, this.maxElementsInMemory, this.maxElementsOnDisk, this.maxSizeOnDiskMB, this.memoryStoreEvictionPolicy, this.overflowToDisk, this.timeToIdleSeconds, this.timeToLiveSeconds, this.diskExpiryThreadIntervalSeconds, this.diskSpoolBufferSizeMB, this.blockingTimeout, this.blocking, this.overrideOnUpdate);
        }

        public String toString() {
            return "CacheSettings.Builder(copyOnRead=" + this.copyOnRead + ", copyOnWrite=" + this.copyOnWrite + ", eternal=" + this.eternal + ", maxElementsInMemory=" + this.maxElementsInMemory + ", maxElementsOnDisk=" + this.maxElementsOnDisk + ", maxSizeOnDiskMB=" + this.maxSizeOnDiskMB + ", memoryStoreEvictionPolicy=" + (Object)((Object)this.memoryStoreEvictionPolicy) + ", overflowToDisk=" + this.overflowToDisk + ", timeToIdleSeconds=" + this.timeToIdleSeconds + ", timeToLiveSeconds=" + this.timeToLiveSeconds + ", diskExpiryThreadIntervalSeconds=" + this.diskExpiryThreadIntervalSeconds + ", diskSpoolBufferSizeMB=" + this.diskSpoolBufferSizeMB + ", blockingTimeout=" + this.blockingTimeout + ", blocking=" + this.blocking + ", overrideOnUpdate=" + this.overrideOnUpdate + ")";
        }
    }
}

