/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.magnolia.jsr107;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import nl.vpro.magnolia.jsr107.SerializableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CacheValue<V>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(CacheValue.class);
    private V value;

    static <V> CacheValue<V> of(V value) {
        return new CacheValue<V>(value);
    }

    CacheValue(V value) {
        this.value = value;
    }

    public Optional<V> toOptional() {
        return Optional.ofNullable(this.value);
    }

    public V orNull() {
        return this.toOptional().orElse(null);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.value instanceof Optional) {
            out.writeObject(Optional.class);
            out.writeObject(((Optional)this.value).orElse(null));
        } else if (this.value instanceof Throwable) {
            try {
                out.writeObject(this.value);
            }
            catch (NotSerializableException nse) {
                log.warn(nse.getClass() + " " + nse.getMessage());
                out.writeObject(new SerializableException(nse.getMessage()));
            }
        } else {
            out.writeObject(this.value);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object i = in.readObject();
        if (Optional.class.equals(i)) {
            Object optionalValue = in.readObject();
            this.value = Optional.ofNullable(optionalValue);
        } else {
            this.value = i;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheValue that = (CacheValue)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

