/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.magnolia.jsr107;

import info.magnolia.jcr.util.NodeUtil;
import info.magnolia.module.InstallContext;
import info.magnolia.module.cache.ehcache3.configuration.EhCache3ConfigurationBuilder;
import info.magnolia.module.cache.ehcache3.configuration.EhCache3Expiry;
import info.magnolia.module.cache.ehcache3.configuration.Ehcache3ResourcePoolBuilder;
import info.magnolia.module.cache.ehcache3.configuration.Ehcache3ResourcePoolsBuilder;
import info.magnolia.module.delta.AbstractRepositoryTask;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import nl.vpro.magnolia.jsr107.CacheSettings;
import nl.vpro.magnolia.jsr107.CreateConfigurationTasks;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.ehcache.config.ResourceType;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.config.units.MemoryUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateCacheConfigurationTask
extends AbstractRepositoryTask {
    private static final Logger log = LoggerFactory.getLogger(CreateCacheConfigurationTask.class);
    private final String nodeName;
    private final Method method;
    private final CacheSettings[] cacheSettings;
    private final boolean overrideOnUpdate;

    protected CreateCacheConfigurationTask(@NonNull String name, @Nullable Method method, List<CacheSettings> cacheSettings, boolean overrideOnUpdate) {
        super("Cache configuration for " + name, "Installs cache configuration for " + name);
        this.method = method;
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Cache name cannot be empty");
        }
        this.nodeName = Text.escapeIllegalJcrChars((String)name);
        if (cacheSettings.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.cacheSettings = cacheSettings.toArray(new CacheSettings[0]);
        this.overrideOnUpdate = overrideOnUpdate;
    }

    public CacheSettings getCacheSettings() {
        return this.cacheSettings[0];
    }

    public String toString() {
        return "Cache configuration create task for " + this.nodeName + (this.method == null ? "" : " (for method " + this.method + ") " + Arrays.asList(this.cacheSettings));
    }

    protected void doExecute(InstallContext installContext) throws RepositoryException {
        Session session = installContext.getJCRSession("config");
        this.createCacheConfigurationNode(session);
        session.save();
    }

    private void createCacheConfigurationNode(Session session) throws RepositoryException {
        this.createAndFill(session, this.nodeName, node -> {
            try {
                node.setProperty("class", EhCache3ConfigurationBuilder.class.getName());
                node.setProperty("keyType", Serializable.class.getName());
                node.setProperty("valueType", Serializable.class.getName());
                Node expiry = NodeUtil.createPath((Node)node, (String)"expiryPolicy", (String)"mgnl:contentNode");
                expiry.setProperty("class", EhCache3Expiry.class.getName());
                for (CacheSettings settings : this.cacheSettings) {
                    if (settings.isEternal() || settings.getTimeToLiveSeconds() == null) continue;
                    expiry.setProperty("create", Long.valueOf(settings.getTimeToLiveSeconds().intValue()).longValue());
                }
                Node resourcePoolsBuilder = NodeUtil.createPath((Node)node, (String)"resourcePoolsBuilder", (String)"mgnl:contentNode");
                resourcePoolsBuilder.setProperty("class", Ehcache3ResourcePoolsBuilder.class.getName());
                Node resourcePools = NodeUtil.createPath((Node)resourcePoolsBuilder, (String)"pools", (String)"mgnl:contentNode");
                for (CacheSettings settings : this.cacheSettings) {
                    Node heap = NodeUtil.createPath((Node)resourcePools, (String)"heap", (String)"mgnl:contentNode");
                    heap.setProperty("class", Ehcache3ResourcePoolBuilder.class.getName());
                    heap.setProperty("resourceType", ResourceType.Core.HEAP.name());
                    heap.setProperty("resourceUnit", EntryUnit.ENTRIES.name());
                    heap.setProperty("size", (long)settings.getMaxElementsInMemory());
                    log.info("Creating {}", (Object)heap);
                    if (!settings.isOverflowToDisk() || settings.getMaxSizeOnDiskMB() <= 0 && settings.getMaxElementsOnDisk() <= 0) continue;
                    Node disk = resourcePools.addNode("disk", "mgnl:contentNode");
                    disk.setProperty("class", Ehcache3ResourcePoolBuilder.class.getName());
                    disk.setProperty("persistent", Boolean.TRUE.booleanValue());
                    disk.setProperty("resourceType", ResourceType.Core.DISK.name());
                    disk.setProperty("resourceUnit", MemoryUnit.MB.name());
                    long size = 1000L;
                    if (settings.getMaxSizeOnDiskMB() > 0) {
                        size = settings.getMaxSizeOnDiskMB();
                    } else if (settings.getMaxElementsOnDisk() > 0) {
                        size = (long)settings.getMaxElementsOnDisk() / 10000L;
                    }
                    disk.setProperty("size", size);
                    log.info("Creating {}", (Object)disk);
                }
            }
            catch (RepositoryException e) {
                log.error("Unable to create/update settings of {} : {}", node, (Object)e.getMessage());
            }
        });
    }

    private void createAndFill(Session session, String path, Consumer<Node> consume) throws RepositoryException {
        Node node;
        String configPath = CreateConfigurationTasks.getPath(session).getPath();
        try {
            node = this.getOrCreatePath(session, configPath).getNode(path);
        }
        catch (PathNotFoundException pnf) {
            node = null;
        }
        if (node == null) {
            node = session.getNode(configPath).addNode(path, "mgnl:contentNode");
            consume.accept(node);
            log.info("Created {} because {}", (Object)node, (Object)this);
        } else if (this.overrideOnUpdate) {
            log.info("Already existed {}. Will override settings with values defined by annotation", (Object)node);
            consume.accept(node);
        } else {
            log.info("Already existed {}", (Object)node);
        }
    }

    private Node getOrCreatePath(Session session, String path) throws RepositoryException {
        return session.getNode(path);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Method getMethod() {
        return this.method;
    }

    public static class Builder {
        private String name;
        private Method method;
        private ArrayList<CacheSettings> cacheSettings;
        private boolean overrideOnUpdate;

        public Builder settings(CacheSettings.Builder builder) {
            return this.cacheSettings(builder.build());
        }

        Builder() {
        }

        public Builder name(@NonNull String name) {
            this.name = name;
            return this;
        }

        public Builder method(@Nullable Method method) {
            this.method = method;
            return this;
        }

        public Builder cacheSettings(CacheSettings cacheSettings) {
            if (this.cacheSettings == null) {
                this.cacheSettings = new ArrayList();
            }
            this.cacheSettings.add(cacheSettings);
            return this;
        }

        public Builder cacheSettings(Collection<? extends CacheSettings> cacheSettings) {
            if (cacheSettings == null) {
                throw new NullPointerException("cacheSettings cannot be null");
            }
            if (this.cacheSettings == null) {
                this.cacheSettings = new ArrayList();
            }
            this.cacheSettings.addAll(cacheSettings);
            return this;
        }

        public Builder clearCacheSettings() {
            if (this.cacheSettings != null) {
                this.cacheSettings.clear();
            }
            return this;
        }

        public Builder overrideOnUpdate(boolean overrideOnUpdate) {
            this.overrideOnUpdate = overrideOnUpdate;
            return this;
        }

        public CreateCacheConfigurationTask build() {
            List<CacheSettings> cacheSettings;
            switch (this.cacheSettings == null ? 0 : this.cacheSettings.size()) {
                case 0: {
                    cacheSettings = Collections.emptyList();
                    break;
                }
                case 1: {
                    cacheSettings = Collections.singletonList(this.cacheSettings.get(0));
                    break;
                }
                default: {
                    cacheSettings = Collections.unmodifiableList(new ArrayList<CacheSettings>(this.cacheSettings));
                }
            }
            return new CreateCacheConfigurationTask(this.name, this.method, cacheSettings, this.overrideOnUpdate);
        }

        public String toString() {
            return "CreateCacheConfigurationTask.Builder(name=" + this.name + ", method=" + this.method + ", cacheSettings=" + this.cacheSettings + ", overrideOnUpdate=" + this.overrideOnUpdate + ")";
        }
    }
}

