/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.magnolia.jsr107;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheResult;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import nl.vpro.magnolia.jsr107.CacheSettings;
import nl.vpro.magnolia.jsr107.CreateCacheConfigurationTask;
import nl.vpro.magnolia.jsr107.DefaultCacheSettings;
import nl.vpro.magnolia.jsr107.Defaults;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateConfigurationTasks {
    private static final Logger log = LoggerFactory.getLogger(CreateConfigurationTasks.class);
    static final String[] PATHS = new String[]{"/modules/cache/config/cacheFactory/delegateFactories/ehcache3/caches", "/modules/cache/config/cacheFactory/caches"};

    public static Node getPath(Session session) throws RepositoryException {
        RepositoryException firstException = null;
        for (String proposal : PATHS) {
            try {
                return session.getNode(proposal);
            }
            catch (RepositoryException re) {
                if (firstException == null) {
                    firstException = re;
                }
                log.warn("{}: {}, falling back to backwards compatibility", (Object)proposal, (Object)((Object)((Object)re)).getClass().getName());
            }
        }
        throw firstException;
    }

    public static List<CreateCacheConfigurationTask> createConfigurationTasks(Class<?> ... beans) {
        ArrayList<CreateCacheConfigurationTask> result = new ArrayList<CreateCacheConfigurationTask>();
        Class<?>[] classArray = beans;
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Class<?> bean;
            for (Class<?> c = bean = classArray[i]; c != null; c = c.getSuperclass()) {
                for (Method m : c.getDeclaredMethods()) {
                    CacheResult cr = m.getDeclaredAnnotation(CacheResult.class);
                    if (cr == null) continue;
                    DefaultCacheSettings cacheSettings = m.getDeclaredAnnotation(DefaultCacheSettings.class);
                    Defaults defaultsWrapper = m.getDeclaredAnnotation(Defaults.class);
                    DefaultCacheSettings exceptionCacheSettings = null;
                    boolean overrideOnUpdate = false;
                    if (defaultsWrapper != null) {
                        if (cacheSettings != null) {
                            throw new IllegalArgumentException("Can't use both @DefaultCacheSettings @Defaults on same method " + m);
                        }
                        overrideOnUpdate = defaultsWrapper.overrideOnUpdate();
                        cacheSettings = defaultsWrapper.cacheSettings();
                        exceptionCacheSettings = defaultsWrapper.exceptionCacheSettings();
                    }
                    CacheSettings settings = CacheSettings.of(cacheSettings);
                    result.add(CreateCacheConfigurationTask.builder().name(CreateConfigurationTasks.getCacheName(m, cr)).method(m).overrideOnUpdate(settings.overrideOnUpdate.orElse(overrideOnUpdate)).cacheSettings(settings).build());
                    if (!StringUtils.isNotBlank((CharSequence)cr.exceptionCacheName())) continue;
                    CacheSettings esettings = CacheSettings.of(exceptionCacheSettings);
                    result.add(CreateCacheConfigurationTask.builder().name(cr.exceptionCacheName()).method(m).overrideOnUpdate(esettings.overrideOnUpdate.orElse(overrideOnUpdate)).cacheSettings(esettings).build());
                }
            }
        }
        result.sort(Comparator.comparing(CreateCacheConfigurationTask::getNodeName));
        return result;
    }

    protected static String getCacheName(Method m, CacheResult cr) {
        String providedByAnotation = cr.cacheName();
        if (StringUtils.isBlank((CharSequence)providedByAnotation)) {
            String providedByCacheDefaults;
            CacheDefaults annotation = m.getDeclaringClass().getAnnotation(CacheDefaults.class);
            if (annotation != null && StringUtils.isNotEmpty((CharSequence)(providedByCacheDefaults = annotation.cacheName()))) {
                return providedByCacheDefaults;
            }
            String calculated = m.getDeclaringClass().getName() + "." + m.getName() + "(" + Arrays.stream(m.getParameterTypes()).map(Class::getName).collect(Collectors.joining(",")) + ")";
            log.info("No explicit cache name on @CacheResult or @CacheDefaults of {}. Defaulting to {}", (Object)m, (Object)calculated);
            return calculated;
        }
        return providedByAnotation;
    }
}

