/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.magnolia.jsr107;

import info.magnolia.module.cache.BlockingCache;
import info.magnolia.module.cache.Cache;
import info.magnolia.module.cache.CacheFactory;
import info.magnolia.module.cache.inject.CacheFactoryProvider;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.GeneratedCacheKey;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import javax.inject.Inject;
import nl.vpro.magnolia.jsr107.AdaptedCache;
import nl.vpro.magnolia.jsr107.CacheValue;
import nl.vpro.magnolia.jsr107.MgnlCacheConfiguration;
import nl.vpro.magnolia.jsr107.MgnlObjectsAwareCacheKeyGenerator;
import nl.vpro.magnolia.jsr107.ReturnCacheValueUnInterceptor;
import nl.vpro.magnolia.jsr107.SerializableGeneratedCacheKey;
import nl.vpro.magnolia.jsr107.UnblockingCache;
import org.aopalliance.intercept.MethodInvocation;
import org.jsr107.ri.annotations.CacheParameterDetails;
import org.jsr107.ri.annotations.CacheResultMethodDetails;
import org.jsr107.ri.annotations.DefaultCacheKeyGenerator;
import org.jsr107.ri.annotations.DefaultGeneratedCacheKey;
import org.jsr107.ri.annotations.InternalCacheInvocationContext;
import org.jsr107.ri.annotations.InternalCacheKeyInvocationContext;
import org.jsr107.ri.annotations.guice.CacheLookupUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MgnlCacheManager
implements CacheManager {
    private static final Logger log = LoggerFactory.getLogger(MgnlCacheManager.class);
    private final CacheFactoryProvider factory;
    private final CacheLookupUtil cacheLookupUtil;
    private static final Map<Class<? extends CacheKeyGenerator>, Function<GeneratedCacheKey, Object[]>> PARAMETER_GETTER = new HashMap<Class<? extends CacheKeyGenerator>, Function<GeneratedCacheKey, Object[]>>();
    private final Properties properties = new Properties();

    private static Function<GeneratedCacheKey, Object[]> createGetter(Class<?> keyClass, String field) {
        Field parameters;
        try {
            parameters = keyClass.getDeclaredField(field);
            parameters.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return o -> {
            try {
                return (Object[])parameters.get(o);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Inject
    public MgnlCacheManager(CacheFactoryProvider factory, CacheLookupUtil util) {
        this.factory = factory;
        this.cacheLookupUtil = util;
    }

    private CacheFactory get() {
        return this.factory.get();
    }

    public CachingProvider getCachingProvider() {
        return null;
    }

    public URI getURI() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return MgnlCacheManager.class.getClassLoader();
    }

    public <K, V, C extends Configuration<K, V>> javax.cache.Cache<K, V> createCache(String cacheName, C configuration) throws IllegalArgumentException {
        log.info("Creating cache {}", (Object)cacheName);
        Cache mgnlCache = this.get().getCache(cacheName);
        return new AdaptedCache(mgnlCache, this, configuration);
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        return this.getCache(cacheName);
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName) {
        return new AdaptedCache(this.get().getCache(cacheName), this, MgnlCacheConfiguration.INSTANCE);
    }

    public <K, V> javax.cache.Cache<K, V> getUnblockingCache(String cacheName) {
        return new UnblockingCache(new AdaptedCache(this.get().getCache(cacheName), this, MgnlCacheConfiguration.INSTANCE));
    }

    public Iterable<String> getCacheNames() {
        return this.get().getCacheNames();
    }

    public void destroyCache(String cacheName) {
        throw new UnsupportedOperationException();
    }

    public void enableManagement(String cacheName, boolean enabled) {
    }

    public void enableStatistics(String cacheName, boolean enabled) {
    }

    public void close() {
    }

    public boolean isClosed() {
        return false;
    }

    public Object getValue(Class<?> clazz, Object instance, String methodName, Object ... key) {
        Class[] keyClasses = key == null ? null : (Class[])Arrays.stream(key).map(k -> k == null ? Object.class : k.getClass()).toArray(Class[]::new);
        return this.getValueGetter(clazz, instance, methodName, keyClasses).get(key);
    }

    public Getter getValueGetter(Class<?> clazz, Object instance, String methodName, Class<?> ... keyClasses) {
        CacheResultMethodDetails methodDetails = this.getMethodDetails(clazz, methodName, keyClasses);
        CacheResolver cacheResolver = methodDetails.getCacheResolver();
        CacheKeyGenerator cacheKeyGenerator = methodDetails.getCacheKeyGenerator();
        return key -> {
            SimpleMethodInvocation invocation = new SimpleMethodInvocation(instance, methodDetails, (Object[])key);
            InternalCacheInvocationContext cacheInvocationContext = this.cacheLookupUtil.getCacheInvocationContext((Object)invocation);
            InternalCacheKeyInvocationContext cacheKeyInvocationContext = this.cacheLookupUtil.getCacheKeyInvocationContext((Object)invocation);
            AdaptedCache cache = (AdaptedCache)cacheResolver.resolveCache((CacheInvocationContext)cacheInvocationContext);
            GeneratedCacheKey cacheKey = cacheKeyGenerator.generateCacheKey((CacheKeyInvocationContext)cacheKeyInvocationContext);
            Object value = cache.getUnblocking(cacheKey);
            return ReturnCacheValueUnInterceptor.unwrap(value);
        };
    }

    public Iterator<Object[]> getKeys(Class<?> clazz, Object instance, String methodName, Class<?> ... keys) {
        CacheResultMethodDetails methodDetails = this.getMethodDetails(clazz, methodName, keys);
        CacheResolver cacheResolver = methodDetails.getCacheResolver();
        SimpleMethodInvocation invocation = new SimpleMethodInvocation(instance, methodDetails, (Class[])keys);
        InternalCacheInvocationContext cacheInvocationContext = this.cacheLookupUtil.getCacheInvocationContext((Object)invocation);
        AdaptedCache cache = (AdaptedCache)cacheResolver.resolveCache((CacheInvocationContext)cacheInvocationContext);
        final Iterator iterator = cache.iterator();
        final Function<GeneratedCacheKey, Object[]> objectGetter = PARAMETER_GETTER.get(methodDetails.getCacheKeyGenerator().getClass());
        return new Iterator<Object[]>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Object[] next() {
                GeneratedCacheKey key = (GeneratedCacheKey)((Cache.Entry)iterator.next()).getKey();
                return (Object[])objectGetter.apply(key);
            }
        };
    }

    protected CacheResultMethodDetails getMethodDetails(Class<?> clazz, String methodName, Class<?> ... keyClasses) {
        Method method = this.getMethod(clazz, methodName, keyClasses);
        return (CacheResultMethodDetails)this.cacheLookupUtil.getMethodDetails(method, clazz);
    }

    protected Method getMethod(Class<?> clazz, String methodName, Class<?> ... arguments) {
        ArrayList<Method> candidates = new ArrayList<Method>();
        block0: for (Method m : clazz.getDeclaredMethods()) {
            if (!m.getName().equals(methodName)) continue;
            if (arguments.length > 0) {
                if (arguments.length != m.getParameterTypes().length) continue;
                for (int i = 0; i < m.getParameterTypes().length; ++i) {
                    if (!m.getParameterTypes()[i].isAssignableFrom(arguments[i])) continue block0;
                }
            }
            m.setAccessible(true);
            candidates.add(m);
        }
        if (candidates.isEmpty()) {
            throw new IllegalArgumentException("Cannot find method " + methodName + "[" + Arrays.asList(arguments) + "] in " + clazz);
        }
        if (candidates.size() != 1) {
            throw new IllegalArgumentException("Multiple methods " + methodName + "[" + Arrays.asList(arguments) + "] found " + clazz + " " + candidates);
        }
        Method method = (Method)candidates.get(0);
        return method;
    }

    public Object getValue(String cacheName, Object key) {
        Cache mgnlCache = this.get().getCache(cacheName);
        if (mgnlCache == null) {
            throw new IllegalArgumentException();
        }
        Object value = mgnlCache.get(key);
        if (mgnlCache instanceof BlockingCache) {
            ((BlockingCache)mgnlCache).unlock(key);
        }
        if (value instanceof CacheValue) {
            value = ((CacheValue)value).orNull();
        }
        return ReturnCacheValueUnInterceptor.unwrap(value);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.factory.get().getClass())) {
            return (T)this.factory.get();
        }
        throw new IllegalArgumentException(this.factory + "  is not a " + clazz + " but a " + this.factory.get().getClass());
    }

    public String toString() {
        return "MgnlCacheManager(factory=" + this.factory + ", cacheLookupUtil=" + this.cacheLookupUtil + ", properties=" + this.getProperties() + ")";
    }

    public Properties getProperties() {
        return this.properties;
    }

    static {
        PARAMETER_GETTER.put(MgnlObjectsAwareCacheKeyGenerator.class, MgnlCacheManager.createGetter(SerializableGeneratedCacheKey.class, "parameters"));
        PARAMETER_GETTER.put(DefaultCacheKeyGenerator.class, MgnlCacheManager.createGetter(DefaultGeneratedCacheKey.class, "parameters"));
    }

    private static class SimpleMethodInvocation
    implements MethodInvocation {
        private final Object instance;
        private final Method method;
        private final Object[] key;

        private SimpleMethodInvocation(Object instance, CacheResultMethodDetails method, Object ... key) {
            this.instance = instance;
            this.method = method.getMethod();
            List keyParameters = method.getKeyParameters();
            if (key == null) {
                key = new Object[this.method.getParameterCount()];
            }
            for (int i = 0; i < keyParameters.size(); ++i) {
                Object keyEntry = key[i];
                if (keyEntry == null || ((CacheParameterDetails)keyParameters.get(i)).getRawType().isInstance(keyEntry)) continue;
                throw new IllegalArgumentException(keyEntry + " (parameter " + i + ") is not compatible with " + keyParameters);
            }
            this.key = key;
        }

        private SimpleMethodInvocation(Object instance, CacheResultMethodDetails method, Class<?> ... keyClasses) {
            this(instance, method, new Object[method.getMethod().getParameterCount()]);
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getArguments() {
            return this.key;
        }

        public Object proceed() {
            throw new UnsupportedOperationException();
        }

        public Object getThis() {
            return this.instance;
        }

        public AccessibleObject getStaticPart() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Getter
    extends Function<Object[], Object> {
        default public Object get(Object ... objects) {
            return this.apply(objects);
        }
    }
}

