/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.magnolia.jsr107;

import info.magnolia.jcr.util.NodeUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.cache.annotation.CacheInvocationParameter;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.GeneratedCacheKey;
import javax.jcr.Node;
import nl.vpro.magnolia.jsr107.SerializableGeneratedCacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MgnlObjectsAwareCacheKeyGenerator
implements CacheKeyGenerator {
    private static final Logger log = LoggerFactory.getLogger(MgnlObjectsAwareCacheKeyGenerator.class);
    private static final Map<Class<?>, Function<Object, Serializable>> REGISTERED_VALUE_TO_SERIALIZABLE = new LinkedHashMap();

    public static <T> void register(Class<T> clazz, Function<T, Serializable> function) {
        REGISTERED_VALUE_TO_SERIALIZABLE.put(clazz, function);
        log.info("Registered {} -> {}", clazz, function);
    }

    protected static void register(String clazz, String method) {
        Method m;
        Class<?> c;
        try {
            c = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            log.info(e.getClass().getName() + " " + e.getMessage());
            return;
        }
        try {
            m = c.getMethod(method, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            log.error(e.getMessage(), (Throwable)e);
            return;
        }
        MgnlObjectsAwareCacheKeyGenerator.register(c, (T o) -> {
            try {
                return (Serializable)m.invoke(o, new Object[0]);
            }
            catch (ClassCastException | IllegalAccessException | InvocationTargetException e) {
                log.error(e.getMessage(), (Throwable)e);
                return String.valueOf(o);
            }
        });
    }

    public GeneratedCacheKey generateCacheKey(CacheKeyInvocationContext<? extends Annotation> cacheKeyInvocationContext) {
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        for (CacheInvocationParameter cacheInvocationParameter : cacheKeyInvocationContext.getKeyParameters()) {
            Map.Entry<Class<?>, Function<Object, Serializable>> e2;
            Object value;
            block2: {
                value = cacheInvocationParameter.getValue();
                for (Map.Entry<Class<?>, Function<Object, Serializable>> e2 : REGISTERED_VALUE_TO_SERIALIZABLE.entrySet()) {
                    if (!e2.getKey().isInstance(value)) continue;
                    break block2;
                }
                throw new IllegalArgumentException("Not serializable " + value);
            }
            result.add(e2.getValue().apply(value));
        }
        return new SerializableGeneratedCacheKey(result.toArray(new Serializable[0]));
    }

    static {
        MgnlObjectsAwareCacheKeyGenerator.register(Node.class, NodeUtil::getPathIfPossible);
        MgnlObjectsAwareCacheKeyGenerator.register("info.magnolia.module.site.Site", "getName");
        MgnlObjectsAwareCacheKeyGenerator.register("info.magnolia.dam.api.Item", "getName");
        MgnlObjectsAwareCacheKeyGenerator.register(Serializable.class, (T o) -> o);
    }
}

