/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.magnolia.jsr107;

import javax.cache.Cache;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.GeneratedCacheKey;
import javax.inject.Inject;
import nl.vpro.magnolia.jsr107.AdaptedCache;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jsr107.ri.annotations.AbstractCacheResultInterceptor;
import org.jsr107.ri.annotations.CacheContextSource;
import org.jsr107.ri.annotations.CacheResultMethodDetails;
import org.jsr107.ri.annotations.InterceptorType;
import org.jsr107.ri.annotations.InternalCacheKeyInvocationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReturnCacheValueInterceptor
extends AbstractCacheResultInterceptor<MethodInvocation>
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ReturnCacheValueInterceptor.class);
    private CacheContextSource<MethodInvocation> cacheContextSource;

    ReturnCacheValueInterceptor() {
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            Object o = this.proceed(invocation);
            if (o == null) {
                o = AdaptedCache.NULL;
            }
            return o;
        }
        catch (Throwable t) {
            this.cache(invocation, AdaptedCache.EXCEPTION);
            throw t;
        }
    }

    protected Object proceed(MethodInvocation invocation) throws Throwable {
        return invocation.proceed();
    }

    @Inject
    public void setCacheContextSource(CacheContextSource<MethodInvocation> cacheContextSource) {
        this.cacheContextSource = cacheContextSource;
    }

    protected void cache(MethodInvocation invocation, Object value) {
        InternalCacheKeyInvocationContext cacheKeyInvocationContext = this.cacheContextSource.getCacheKeyInvocationContext((Object)invocation);
        CacheResultMethodDetails methodDetails = (CacheResultMethodDetails)this.getStaticCacheKeyInvocationContext(cacheKeyInvocationContext, InterceptorType.CACHE_RESULT);
        CacheKeyGenerator cacheKeyGenerator = methodDetails.getCacheKeyGenerator();
        GeneratedCacheKey cacheKey = cacheKeyGenerator.generateCacheKey((CacheKeyInvocationContext)cacheKeyInvocationContext);
        Cache cache = methodDetails.getCacheResolver().resolveCache((CacheInvocationContext)cacheKeyInvocationContext);
        log.debug("Caching {} {}", (Object)cache, (Object)cacheKey);
        cache.put((Object)cacheKey, value);
    }
}

