//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, vJAXB 2.1.10 in JDK 6
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a>
// Any modifications to this file will be lost upon recompilation of the source schema.
// Generated on: 2012.06.07 at 01:34:44 PM CEST
//


package nl.vpro.domain.media.nebo.base;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import nl.vpro.domain.image.ImageType;
import nl.vpro.domain.media.Program;
import nl.vpro.domain.media.Segment;
import nl.vpro.domain.media.exceptions.ModificationException;
import nl.vpro.domain.media.nebo.enrichment.v2_4.AfleveringType;
import nl.vpro.domain.media.nebo.shared.TimeAdapter;
import nl.vpro.domain.media.support.Image;
import nl.vpro.domain.media.support.OwnerType;
import nl.vpro.domain.media.support.TextualType;
import nl.vpro.util.TimeUtils;


/**
 * <p>Java class for fragmentenType complex type.
 * <p/>
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p/>
 * <pre>
 * &lt;complexType name="fragmentenType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="fragment" maxOccurs="unbounded" minOccurs="0">
 *           &lt;complexType>
 *             &lt;complexContent>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 &lt;all>
 *                   &lt;element name="titel" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *                   &lt;element name="omschrijving" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *                   &lt;element name="starttijd" type="{http://namespace.com/importBase}tijd"/>
 *                   &lt;element name="eindtijd" type="{http://namespace.com/importBase}tijd"/>
 *                   &lt;element name="afbeelding" minOccurs="0">
 *                     &lt;complexType>
 *                       &lt;complexContent>
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           &lt;all>
 *                             &lt;element name="titel" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *                             &lt;element name="omschrijving" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *                             &lt;element name="trefwoorden" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *                             &lt;element name="pad" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *                           &lt;/all>
 *                           &lt;attribute name="actie" type="{http://namespace.com/importBase}actieType" />
 *                         &lt;/restriction>
 *                       &lt;/complexContent>
 *                     &lt;/complexType>
 *                   &lt;/element>
 *                   &lt;element name="trefwoorden" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *                 &lt;/all>
 *               &lt;/restriction>
 *             &lt;/complexContent>
 *           &lt;/complexType>
 *         &lt;/element>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "fragmentenType", propOrder = {
    "fragment"
})
public class FragmentenType {

    protected List<FragmentenType.Fragment> fragment;

    public FragmentenType() {
        // IntelligJ requirement
    }

    public FragmentenType(Program program) {

        Fragment newFragment;
        Segment currSegment;


        if(program.getSegments() != null &&
            program.getSegments().size() > 0 &&
            this.fragment == null) {
            this.fragment = new ArrayList<>();
        }
        for(Segment segment : program.getSegments()) {
            currSegment = segment;
            //currSegment.getDurationAsDate();
            newFragment = createFragment(currSegment);

            this.fragment.add(newFragment);
        }
    }

    protected Fragment createFragment(Segment segment) {
        return new Fragment(segment);
    }

    /**
     * takes any available image but priorizes to image type STILL
     */
    protected static Fragment.Afbeelding createAfbeelding(Segment segment) {
        Image bestImage = null;
        List<Image> imageList = segment.getImages();
        for(Image image : imageList) {
            if(bestImage == null || image.getType().equals(ImageType.STILL)) {
                bestImage = image;
            }
        }

        if(bestImage == null) {
            return null;
        }

        Fragment.Afbeelding afbeelding = new Fragment.Afbeelding();
        afbeelding.setActie(null);
        afbeelding.setOmschrijving(bestImage.getDescription() != null ? bestImage.getDescription() : bestImage.getTitle());
        afbeelding.setTitel(bestImage.getTitle());
        afbeelding.setTrefwoorden(null);

        String imageUri = bestImage.getImageUri();
        String pad = imageUri.substring(imageUri.lastIndexOf(':') + 1);
        afbeelding.setPad(pad);

        return afbeelding;
    }


    public List<FragmentenType.Fragment> getFragment() {
        if(fragment == null) {
            fragment = new ArrayList<>();
        }
        return this.fragment;
    }

    public void setFragment(List<FragmentenType.Fragment> fragment) {
        this.fragment = fragment;
    }


    /**
     * <p>Java class for anonymous complex type.
     * <p/>
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <p/>
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       &lt;all>
     *         &lt;element name="titel" type="{http://www.w3.org/2001/XMLSchema}string"/>
     *         &lt;element name="omschrijving" type="{http://www.w3.org/2001/XMLSchema}string"/>
     *         &lt;element name="starttijd" type="{http://namespace.com/importBase}tijd"/>
     *         &lt;element name="eindtijd" type="{http://namespace.com/importBase}tijd"/>
     *         &lt;element name="afbeelding" minOccurs="0">
     *           &lt;complexType>
     *             &lt;complexContent>
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 &lt;all>
     *                   &lt;element name="titel" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
     *                   &lt;element name="omschrijving" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
     *                   &lt;element name="trefwoorden" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
     *                   &lt;element name="pad" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
     *                 &lt;/all>
     *                 &lt;attribute name="actie" type="{http://namespace.com/importBase}actieType" />
     *               &lt;/restriction>
     *             &lt;/complexContent>
     *           &lt;/complexType>
     *         &lt;/element>
     *         &lt;element name="trefwoorden" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
     *       &lt;/all>
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     */
    @XmlAccessorType(XmlAccessType.PROPERTY)
    @XmlType(name = "", propOrder = {
        "titel",
        "omschrijving",
        "starttijd",
        "eindtijd",
        "trefwoorden",
        "afbeelding"
    })
    public static class Fragment {


        protected Date eindtijd;

        protected FragmentenType.Fragment.Afbeelding afbeelding;

        protected String trefwoorden;


        private final Segment segment;

        public Fragment() {
            this(new Segment());
        }


        Fragment(Segment segment) {
            this.segment = segment;
            setTitel(segment.getMainTitle());
            setTrefwoorden(null);
            setAfbeelding(FragmentenType.createAfbeelding(segment));
            if(segment.getStart() != null && segment.getDuration() != null) {
                Duration duration = segment.getStart().plus(segment.getDuration().get());
                setEindtijd(TimeUtils.asDate(duration));
            }
        }


        @XmlElement(required = true)
        public String getTitel() {
            return segment.getMainTitle();
        }


        public void setTitel(String value) {
            if (value != null) {
                segment.addTitle(value, AfleveringType.OWNER, TextualType.MAIN);
            }
        }

        @XmlElement(required = true)
        public String getOmschrijving() {
            return segment.getMainDescription() != null ? segment.getMainDescription() : segment.getMainTitle();
        }


        public void setOmschrijving(String value) {
            segment.addDescription(value, AfleveringType.OWNER, TextualType.MAIN);
        }


        @XmlElement(required = true)
        @XmlJavaTypeAdapter(TimeAdapter.class)
        public Date getStarttijd() {
            return TimeUtils.asDate(segment.getStart());
        }

        public void setStarttijd(Date value) {
            segment.setStart(TimeUtils.durationOf(value).orElse(null));
        }

        @XmlElement(required = true)
        @XmlJavaTypeAdapter(TimeAdapter.class)
        public Date getEindtijd() {
            return eindtijd;
        }


        public void setEindtijd(Date value) {
            this.eindtijd = value;
        }

        public FragmentenType.Fragment.Afbeelding getAfbeelding() {
            return afbeelding;
        }

        public void setAfbeelding(FragmentenType.Fragment.Afbeelding value) {
            this.afbeelding = value;
        }

        public String getTrefwoorden() {
            return trefwoorden;
        }

        public void setTrefwoorden(String value) {
            this.trefwoorden = value;
        }

        @XmlTransient
        public Segment getSegment() {
            if(eindtijd != null && segment.getStart() != null) {
                try {
                    Duration duration = TimeUtils.durationOf(eindtijd).orElse(Duration.ZERO).minus(segment.getStart());
                    segment.setDuration(duration);
                } catch(ModificationException e) {
                    throw new RuntimeException(e);
                }
            }
            segment.getImages().clear();
            if(afbeelding != null) {
                segment.addImage(new Image(OwnerType.BROADCASTER, ImageType.STILL, afbeelding.getPad()));
            }
            return segment;
        }


        /**
         * <p>Java class for anonymous complex type.
         * <p/>
         * <p>The following schema fragment specifies the expected content contained within this class.
         * <p/>
         * <pre>
         * &lt;complexType>
         *   &lt;complexContent>
         *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       &lt;all>
         *         &lt;element name="titel" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
         *         &lt;element name="omschrijving" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
         *         &lt;element name="trefwoorden" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
         *         &lt;element name="pad" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
         *       &lt;/all>
         *       &lt;attribute name="actie" type="{http://namespace.com/importBase}actieType" />
         *     &lt;/restriction>
         *   &lt;/complexContent>
         * &lt;/complexType>
         * </pre>
         */
        @XmlAccessorType(XmlAccessType.PROPERTY)
        @XmlType(name = "", propOrder = {
            "titel",
            "omschrijving",
            "trefwoorden",
            "pad"
        })
        public static class Afbeelding {

            private String titel;

            private String omschrijving;

            private String trefwoorden;

            private String pad;

            private ActieType actie;


            public String getTitel() {
                return titel;
            }

            public void setTitel(String value) {
                this.titel = value;
            }

            public String getOmschrijving() {
                return omschrijving;
            }


            public void setOmschrijving(String value) {
                this.omschrijving = value;
            }


            public String getTrefwoorden() {
                return trefwoorden;
            }


            public void setTrefwoorden(String value) {
                this.trefwoorden = value;
            }


            public String getPad() {
                return pad;
            }

            public void setPad(String value) {
                this.pad = value;
            }

            @XmlAttribute
            public ActieType getActie() {
                return actie;
            }

            public void setActie(ActieType value) {
                this.actie = value;
            }
        }

    }

}
