//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, vJAXB 2.1.10 in JDK 6
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a>
// Any modifications to this file will be lost upon recompilation of the source schema.
// Generated on: 2012.06.07 at 01:34:44 PM CEST
//


package nl.vpro.domain.media.nebo.enrichment.v2_4;

import java.util.List;

import javax.xml.bind.annotation.*;

import org.apache.commons.lang3.StringUtils;

import nl.vpro.domain.image.ImageType;
import nl.vpro.domain.media.*;
import nl.vpro.domain.media.nebo.base.AfbeeldingenType;
import nl.vpro.domain.media.nebo.base.FragmentenType;
import nl.vpro.domain.media.nebo.base.TabsType;
import nl.vpro.domain.media.nebo.shared.StreamsType;
import nl.vpro.domain.media.support.*;
import nl.vpro.util.TextUtil;


/**
 * <p>Java class for afleveringType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="afleveringType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;all>
 *         &lt;element ref="{}tite"/>
 *         &lt;element ref="{}inh1" minOccurs="0"/>
 *         &lt;element ref="{}atit" minOccurs="0"/>
 *         &lt;element name="icon" type="{http://www.w3.org/2001/XMLSchema}anyType" minOccurs="0"/>
 *         &lt;element ref="{}inh2" minOccurs="0"/>
 *         &lt;element ref="{}inh3" minOccurs="0"/>
 *         &lt;element ref="{}inhk" minOccurs="0"/>
 *         &lt;element ref="{}mail" minOccurs="0"/>
 *         &lt;element ref="{}webs" minOccurs="0"/>
 *         &lt;element ref="{}gids_tekst" minOccurs="0"/>
 *         &lt;element ref="{}tabs" minOccurs="0"/>
 *         &lt;element ref="{}afbeeldingen" minOccurs="0"/>
 *         &lt;element ref="{}fragmenten" minOccurs="0"/>
 *         &lt;element name="streams" type="{}streamsType" minOccurs="0"/>
 *       &lt;/all>
 *       &lt;attribute ref="{}prid"/>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlType(name = "afleveringType", propOrder = {
        "tite",
        "inh1",
        "atit",
        "icon",
        "inh2",
        "inh3",
        "inhk",
        "mail",
        "webs",
        "gids_tekst",
        "tabs", /* not in docu */
        //"afbeeldingen",/* not supported by nebo*/
        "fragmenten",
        "streams" /* not in docu */
        })
public class AfleveringType {

    public static final OwnerType OWNER = OwnerType.BROADCASTER;

    private final Program program;
    private FragmentenType fragmenten;
    private AfbeeldingenType.Icon icon;
    private StreamsType streams;

    public AfleveringType(Program program) {
        this.program = program;
        fragmenten = new FragmentenType(program);
        for (Image image : program.getImages()) {
            if (image.getType() == ImageType.ICON) {
                icon = new AfbeeldingenType.Icon(image);
                break;
            }
        }
        if (program.getLocations() != null &&
            program.getLocations().size() > 0) {
            streams = new StreamsType(program);
        }
    }

    public AfleveringType() {
        this.program = new Program();
    }


    @XmlElement(required = true)
    public String getTite() {
        for (Title title : program.getTitles()) {
            if (TextualType.MAIN == title.getType() && title.getOwner() == OWNER) {
                return title.get();
            }
        }
        return "";
    }

    public void setTite(String value) {
        if (StringUtils.isNotBlank(value)) {
            program.addTitle(value, OWNER, TextualType.MAIN);
        }
    }

    public String getInh1() {
        for (Description desc : program.getDescriptions()) {
            if (desc.getOwner() == OWNER) {
                return desc.get();
            }
        }
        return null;
    }


    public void setInh1(String value) {
        if (StringUtils.isNotBlank(value)) {
            program.addDescription(value, OWNER, TextualType.MAIN);
        }
    }


    public String getAtit() {
        return program.getSubTitle();
    }

    public void setAtit(String value) {
        if (StringUtils.isNotBlank(value)) {
            program.addTitle(value, OWNER, TextualType.SUB);
        }
    }

    public AfbeeldingenType.Icon getIcon() {
        return icon;
    }

    public void setIcon(AfbeeldingenType.Icon value) {
        this.icon = value;
    }


    public String getInh2() {
        return program.getEpisodeDescription();
    }


    public void setInh2(String value) {
        if (StringUtils.isNotBlank(value)) {
            program.addDescription(value, OWNER, TextualType.EPISODE);
        }
    }

    public String getInh3() {
        return null;
    }


    public void setInh3(String value) {
        // ignore
    }

    public String getInhk() {
        for (Description desc : program.getDescriptions()) {
            if (desc.getType() == TextualType.SHORT && desc.getOwner() == OWNER) {
                return desc.get();
            }
        }
        return null;
    }


    public void setInhk(String value) {
        if (StringUtils.isNotBlank(value)) {
            program.addDescription(value, OWNER, TextualType.SHORT);
        }
    }

    public String getMail() {
        return program.getMainEmail();
    }

    public void setMail(String value) {
        if (StringUtils.isNotBlank(value)) {
            // make sure the email is present, and the first one
            program.getEmail().remove(value);
            program.getEmail().add(0, value);
        }
    }

    protected static String validate(String url) {
        if (url == null) return null;
        if (! url.contains(":")) {
            // This happens a lot, which will not be accepted by the XSD
            // TODO: Don't we validate something like this ourselves? MSE-1599
            url =  "http://" + url;
        }
        if (url.startsWith("HTTP:")) {
            url = "http:" + url.substring("http:".length());
        }
        if (url.startsWith("HTTPS:")) {
            url = "https:" + url.substring("https:".length());
        }
        if (url.endsWith(".")) {
            // Er kwamen een stuk of 80 van dit soort urls uit de NEBO history import.
            // Laten we dat ook maar even wegslopen
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public String getWebs() {
        Website website = program.getMainWebsite();
        if (website == null) return null;
        return validate(website.getUrl());
    }


    public void setWebs(String value) {
        // make sure the website is present, and the first one
        List<Website> websites = program.getWebsites();
        Website website = new Website(value);
        websites.remove(website);
        websites.add(0, website);
    }

    public String getGids_tekst() {
        return program.getEpisodeDescription();
    }


    public void setGids_tekst(String value) {
        if (StringUtils.isNotBlank(value)) {
            program.addDescription(value, OwnerType.BROADCASTER, TextualType.EPISODE);
        }
    }

    public TabsType getTabs() {
        // DRS: not supported by new player!
        return null;
    }


    public void setTabs(TabsType value) {
    }

    public FragmentenType getFragmenten() {
        return fragmenten != null && fragmenten.getFragment().size() > 0 ? fragmenten : null;
    }

    public void setFragmenten(FragmentenType value) {

        this.fragmenten = value;
    }


    public StreamsType getStreams() {
        return streams;
    }


    public void setStreams(StreamsType value) {
        this.streams = value;
    }

    @XmlAttribute
    public String getPrid() {
        return program.getMid();
    }

    public void setPrid(String value) {
        program.setMid(value);
    }

    public Program getProgram() {
        program.setAVType(AVType.VIDEO);
        program.setType(ProgramType.BROADCAST);
        program.getSegments().clear();
        if (fragmenten != null) {
            for (FragmentenType.Fragment fragment : fragmenten.getFragment()) {
                Segment seg = fragment.getSegment();
                seg.setAVType(AVType.VIDEO);
                program.addSegment(seg);
            }
        }
        program.getImages().clear();
        if (icon != null) {
            Image image = new Image();
            String title = icon.getTitel();
            if (StringUtils.isEmpty(title)) {
                title = program.getMainTitle();
            }
            image.setTitle(TextUtil.sanitize(title));
            image.setDescription(TextUtil.sanitize(icon.getOmschrijving()));
            image.setImageUri(icon.getPad());
            image.setOwner(OwnerType.BROADCASTER);
            image.setType(ImageType.ICON);
            program.addImage(image);
        }
        program.getLocations().clear();
        if (streams != null && streams.getLocations() != null) {
            for (Location location : streams.getLocations()) {
                program.addLocation(location);
            }
        }
        return program;
    }

}
