//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, v2.2.4
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a>
// Any modifications to this file will be lost upon recompilation of the source schema.
// Generated on: 2012.06.07 at 01:34:11 PM CEST
//


package nl.vpro.domain.media.nebo.shared;

import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.*;

import nl.vpro.domain.media.AVAttributes;
import nl.vpro.domain.media.AVFileFormat;
import nl.vpro.domain.media.Location;
import nl.vpro.domain.media.support.OwnerType;


/**
 * <p>Java class for streamType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="streamType">
 *   &lt;simpleContent>
 *     &lt;extension base="&lt;>httpURIResType">
 *       &lt;attribute name="kwaliteit" use="required" type="{}qualityResType" />
 *       &lt;attribute name="formaat" use="required" type="{}formatResType" />
 *     &lt;/extension>
 *   &lt;/simpleContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "streamType", propOrder = {
        "value"
        })
public class StreamType  {

    @XmlValue
    protected String value;
    @XmlAttribute(name = "kwaliteit", required = true)
    protected QualityResType kwaliteit;
    @XmlAttribute(name = "formaat", required = true)
    protected FormatResType formaat;

    public StreamType(Location location) {
        String programUrl = location.getProgramUrl();

        // TODO: quality is determined from stream filename for now:
        // In Zencoder project, ZencoderJobRequest constructor currently generates the
        // stream's filename in format destinationURL + profile.format. So quality setting
        // can be determined from filename as long as this doesn't change. Profiles are
        // enumerated in ZencoderProfiles. profiles = {NPO_sb, NPO_st, NPO_bb}
        if (programUrl.contains("NPO_sb.")) {
            kwaliteit = QualityResType.SB;
        } else if (programUrl.contains("NPO_bb.")) {
            kwaliteit = QualityResType.BB;
        } else {
            Integer bitrate = location.getBitrate();
            if (bitrate != null && bitrate >= QualityResType.STD.getBitrate()) {
                kwaliteit = QualityResType.STD;
           } else if (bitrate != null && bitrate >= QualityResType.BB.getBitrate()) {
                kwaliteit = QualityResType.BB;
            } else if (bitrate != null && bitrate <= QualityResType.SB.getBitrate()) {
                kwaliteit = QualityResType.SB;
            } else {
                // everything else is considered STD
                kwaliteit = QualityResType.STD;
            }
        }
        AVFileFormat avFileFormat = location.getAvFileFormat();
        if (avFileFormat != null) {
            switch (avFileFormat) {
                case WM:
                case WMP:
                    formaat = FormatResType.WMV;
                    break;
                default: formaat = FormatResType.MOV;
            }
        } else {

            formaat = FormatResType.MOV; // always MOV (mp4, m4v)
        }
        value = programUrl;
    }

    public StreamType() {

    }

    public String getValue() {
        return value;
    }


    public void setValue(String value) {
        this.value = value;
    }

    public QualityResType getKwaliteit() {
        return kwaliteit;
    }

    public void setKwaliteit(QualityResType value) {
        this.kwaliteit = value;
    }


    public FormatResType getFormaat() {
        return formaat;
    }

    public void setFormaat(FormatResType value) {
        this.formaat = value;
    }

    public Location getLocation() {
        Location location = new Location(value, OwnerType.BROADCASTER);
        AVAttributes avAttributes = new AVAttributes();
        avAttributes.setAvFileFormat(formaat.getAVFileFormat());
        location.setAvAttributes(avAttributes);
        location.setBitrate(kwaliteit.getBitrate());
        return location;
    }

    void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        StreamsType streamsType = (StreamsType) parent;

    }

}
