//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, v2.2.4
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a>
// Any modifications to this file will be lost upon recompilation of the source schema.
// Generated on: 2012.06.07 at 01:34:11 PM CEST
//


package nl.vpro.domain.media.nebo.shared;

import java.util.*;

import javax.xml.bind.annotation.*;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import nl.vpro.domain.media.*;


/**
 * <p>Java class for streamsType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="streamsType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="stream" type="{}streamType" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="publicatie_startdatumtijd" use="required" type="{http://www.w3.org/2001/XMLSchema}dateTime" />
 *       &lt;attribute name="publicatie_einddatumtijd" type="{http://www.w3.org/2001/XMLSchema}dateTime" />
 *       &lt;attribute name="aspect_ratio" use="required" type="{}aspectratioResType" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@SuppressWarnings("deprecation")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlType(propOrder = {
        "stream"
        })
public class StreamsType {

    protected static final Logger LOG = LoggerFactory.getLogger(StreamsType.class);


    List<StreamType> streams;
    AVAttributes avAttributes;
    Date publishStart;
    Date publishStop;


    public StreamsType(Program program) {
        if (program.getLocations() != null) {
            for (Location location : program.getLocations()) {
                addStream(new StreamType(location));
                if (this.publishStart == null || location.getPublishStart().after(this.publishStart)) {
                    this.publishStart = location.getPublishStart();
                }
                if (this.publishStop == null || location.getPublishStop().before(this.publishStop)) {
                this.publishStop = location.getPublishStop();
            }
            }
        }
        this.avAttributes = program.getAvAttributes();
        if (this.publishStart == null) {
            this.publishStart = program.getPublishStart();
        }
        if (this.publishStart == null) {
            this.publishStart = new Date(0);
        }
    }

    public StreamsType() {

    }

    protected boolean addStream(StreamType type) {
        if (streams == null) streams = new ArrayList<>();
        for (StreamType t : streams) {
            if (t.getFormaat().equals(type.getFormaat()) && t.getKwaliteit().equals(type.getKwaliteit())) {
                LOG.error("There is already a stream with this format and quality, so it cannot be added " + type + " in " + streams);
                return false;
            }
        }
        streams.add(type);
        return true;
    }


    @XmlElement(required = true)
    public List<StreamType> getStream() {
        if (streams == null) streams = new ArrayList<>();
        return streams;
    }

    public void setStream(List<StreamType> streams) {
        this.streams = streams;
    }

    protected static XMLGregorianCalendar getCalendar(Date date) {
        if (date == null) {
            return null;
        }
        try {
            GregorianCalendar cal = new GregorianCalendar(new Locale("nl", "NL"));
            cal.setTime(date);
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
        } catch(DatatypeConfigurationException e) {
            // parse error, return null
        }
        return null;
    }

    @XmlAttribute(name = "publicatie_startdatumtijd", required = true)
    @XmlSchemaType(name = "dateTime")
    public XMLGregorianCalendar getPublicatieStartdatumtijd() {
        return getCalendar(this.publishStart);
    }


    public void setPublicatieStartdatumtijd(XMLGregorianCalendar value) {
        publishStart = value.toGregorianCalendar().getTime();
    }


    @XmlAttribute(name = "publicatie_einddatumtijd")
    @XmlSchemaType(name = "dateTime")
    public XMLGregorianCalendar getPublicatieEinddatumtijd() {
        return getCalendar(this.publishStop);
    }


    public void setPublicatieEinddatumtijd(XMLGregorianCalendar value) {
        publishStop = value.toGregorianCalendar().getTime();
    }



    @XmlAttribute(name = "aspect_ratio", required = true)
    public String getAspectRatio() {
        if (avAttributes != null) {
            VideoAttributes va = avAttributes.getVideoAttributes();
            if (va != null) {
                AspectRatio ar = va.getAspectRatio();
                if (ar != null) {
                    return ar.toString();
                }
            }
        }
        return "16:9"; // it is not valid to return null
        //return null;
    }

    public void setAspectRatio(String value) {
        if (avAttributes == null) avAttributes = new AVAttributes();
        VideoAttributes va = avAttributes.getVideoAttributes();
        if (va == null) {
            va = new VideoAttributes();
            avAttributes.setVideoAttributes(va);
        }
        if (value.equals("16:9")) {
            va.setAspectRatio(AspectRatio._16x9);
        } else if  (value.equals("4:3")) {
            va.setAspectRatio(AspectRatio._4x3);
        } else {
            va.setAspectRatio(null);
        }
    }

    public SortedSet<Location> getLocations() {
        if (streams != null && streams.size() > 0) {
            SortedSet<Location> locations = new TreeSet<>();
            for (StreamType stream : streams) {
                Location location = stream.getLocation();
                location.setPublishStart(publishStart);
                location.setPublishStop(publishStop);
                locations.add(location);
            }
            return locations;
        } else {
            return null;
        }

    }
}
