//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, v2.2.4
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a>
// Any modifications to this file will be lost upon recompilation of the source schema.
// Generated on: 2012.06.07 at 01:34:11 PM CEST
//

package nl.vpro.domain.media.nebo.webonly.v1_4;

import java.util.*;

import javax.xml.bind.annotation.*;

import org.apache.commons.lang3.StringUtils;

import nl.vpro.domain.image.ImageType;
import nl.vpro.domain.media.*;
import nl.vpro.domain.media.support.Image;
import nl.vpro.domain.media.support.OwnerType;
import nl.vpro.domain.media.support.TextualType;
import nl.vpro.domain.user.Broadcaster;
import nl.vpro.nicam.Kijkwijzer;

/**
 * <p>Java class for webonlyType complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="webonlyType">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="prid" type="{}WEBPRIDResType"/>
 *         &lt;element name="srid" type="{}IDResType"/>
 *         &lt;element name="titel" type="{}stringResType255"/>
 *         &lt;element name="subtitel" type="{}stringResType255" minOccurs="0"/>
 *         &lt;element name="email" type="{}emailResType" minOccurs="0"/>
 *         &lt;element name="nicamcodes" type="{}nicamWarningCodesResType" minOccurs="0"/>
 *         &lt;element name="omschrijving_kort" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="omschrijving_lang" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="website" type="{}httpURIResType" minOccurs="0"/>
 *         &lt;element name="media" type="{}mediaType" minOccurs="0"/>
 *         &lt;element name="categorieen" type="{}categorieenType" minOccurs="0"/>
 *         &lt;element name="genres" type="{}genresType" minOccurs="0"/>
 *         &lt;element name="omroepen" type="{}omroepenType"/>
 *         &lt;element name="referenties" type="{}referentiesType" minOccurs="0"/>
 *         &lt;element name="bron" type="{}stringResType100" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="action" type="{}actionResType" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlType(name = "webonly", propOrder = {
        "prid",
        "srid",
        "titel",
        "subtitel",
        "email",
        "nicamcodes",
        "omschrijvingKort",
        "omschrijvingLang",
        "website",
        "media",
        "categorieen",
        "genres",
        "omroepen",
        "referenties",
        "bron"
        })
public class WebonlyType {

    public final OwnerType OWNER = OwnerType.BROADCASTER;


    @XmlAttribute
    private String id;

    private ActionResType action;
    Program program;
    String group;
    private MediaType media;

    private OmroepenType omroepen;


    public WebonlyType(Program program, String group) {
        this.program = program;
        this.group = group;
        media = new MediaType(this);
        omroepen = new OmroepenType(program.getBroadcasters());
    }

    public WebonlyType() {
        this(new Program(), null);
    }

    @XmlElement(required = true)
    public String getPrid() {
        return program.getMid();
    }

    public void setPrid(String value) {
        program.setMid(value);
    }

    @XmlElement(required = true)
    public String getSrid() {
        return group;
    }

    public void setSrid(String value) {
        group = value;
    }

    @XmlElement(required = true)
    public String getTitel() {
        return program.getMainTitle();
    }

    public void setTitel(String value) {
        program.addTitle(value, OWNER, TextualType.MAIN);
    }

    public String getSubtitel() {
        return program.getSubTitle();
    }

    public void setSubtitel(String value) {
        program.addTitle(value, OWNER, TextualType.SUB);
    }

    public String getEmail() {
        return program.getMainEmail();
    }

    public void setEmail(String value) {
        List<String> emails = program.getEmail();
        emails.remove(value);
        emails.add(0, value);
    }

    public String getNicamcodes() {
        // [2345]{0,1}[g]{0,1}[s]{0,1}[a]{0,1}[d]{0,1}[h]{0,1}[t]{0,1}
        StringBuilder neboRating = new StringBuilder();
        AgeRating ageRating = program.getAgeRating();
        if (ageRating != null) {
            // TODO this does not seem the same as the switch in nl.vpro.domain.media.ceres.Xmls#kykw
            switch (ageRating) {
                case _6:
                    neboRating.append('2');
                    break;
                case _9:
                    neboRating.append('3');
                    break;
                case _12:
                    neboRating.append('4');
                    break;
                case _16:
                    neboRating.append('5');
                case ALL:
                    // all ages, leave age indicator
            }
        }

        for (ContentRating rating : program.getContentRatings()) {
            neboRating.append(rating.toChar());
        }
        return neboRating.length() > 0 ? neboRating.toString() : null;
    }

    public void setNicamcodes(String value) {
        Kijkwijzer kijkwijzer = Kijkwijzer.parse(value);
        program.setAgeRating(kijkwijzer.getAgeRating());
        program.getContentRatings().addAll(kijkwijzer.getContentRatings());
    }

    @XmlElement(name = "omschrijving_kort")
    public String getOmschrijvingKort() {
        return program.getShortDescription();
    }

    public void setOmschrijvingKort(String value) {
        program.addDescription(value, OWNER, TextualType.SHORT);
    }

    @XmlElement(name = "omschrijving_lang")
    public String getOmschrijvingLang() {
        return program.getMainDescription();
    }

    public void setOmschrijvingLang(String value) {
        program.addDescription(value, OWNER, TextualType.MAIN);
    }

    public String getWebsite() {
        Website ws = getFromCollection(program.getWebsites());
        return ws == null ? null : ws.getUrl();
    }

    public void setWebsite(String value) {
        program.getWebsites().remove(new Website(value));
        program.getWebsites().add(0, new Website(value));
    }

    public MediaType getMedia() {
        return media;
    }

    public void setMedia(MediaType value) {
        this.media = value;
    }

    public CategorieenType getCategorieen() {
        return null;
    }

    public void setCategorieen(CategorieenType value) {
        //
    }

    public GenresType getGenres() {
        if (program != null &&
            program.getGenres() != null &&
            program.getGenres().size() > 0) {

            List<String> genresList = new ArrayList<>();
            for (MisGenreType genre : MisGenreType.valueOfGenre(program.getGenres())) {
                genresList.add(genre.getDisplayName());
            }
            return new GenresType(genresList);
        }

        return null;
    }

    public void setGenres(GenresType value) {
        program.setGenres(Genre.valueOfMis(MisGenreType.find(value.getGenre())));

    }

    @XmlElement(required = true)
    public OmroepenType getOmroepen() {
        return omroepen;
    }

    public void setOmroepen(OmroepenType value) {
        this.omroepen = value;
    }

    public ReferentiesType getReferenties() {
        return null;
    }

    public void setReferenties(ReferentiesType value) {
        throw new UnsupportedOperationException("referenties not supported");
    }

    public String getBron() {
        return program.getSource();
    }

    public void setBron(String value) {
        program.setSource(value);
    }

    @XmlAttribute(name = "action")
    public ActionResType getAction() {
        return action;
    }

    public void setAction(ActionResType value) {
        this.action = value;
    }

    static <E> E getFromCollection(Collection<E> list) {
        if (list != null && list.size() > 0) {
            return list.iterator().next();
        } else {
            return null;
        }
    }


    @XmlTransient
    public Program getProgram() {
        program.setAVType(AVType.VIDEO);
        program.setType(ProgramType.CLIP);
        MediaObjects.removeLocations(program);
        if (media != null) {
            if (media.getStreams() != null && media.getStreams().getLocations() != null) {
                MediaObjects.addAll(program, media.getStreams().getLocations());
            }
            IconType icon = media.getIcon();
            if (icon != null) {
                Image image = new Image();
                String title = icon.getTitel();
                if (StringUtils.isEmpty(title)) {
                    title = program.getMainTitle();
                }
                image.setTitle(title);
                image.setDescription(icon.getOmschrijving());
                image.setImageUri(icon.getFile());
                image.setOwner(OwnerType.BROADCASTER);
                image.setType(ImageType.ICON);
                program.addImage(image);
            }
        }
        program.getBroadcasters().clear();
        for (OmroepType omroep : omroepen.getOmroep()) {
            if (omroep.isHoofdomroep()) {
                program.addBroadcaster(new Broadcaster(omroep.getValue()));
            }
        }
        for (OmroepType omroep : omroepen.getOmroep()) {
            if (!omroep.isHoofdomroep()) {
                program.addBroadcaster(new Broadcaster(omroep.getValue()));
            }
        }
        if (id != null) {
            program.addCrid("crid://tmp.program.omroep.nl/" + id);
        }
        return program;
    }
}
