/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.domain.media.nebo.base;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import nl.vpro.domain.image.ImageType;
import nl.vpro.domain.media.Program;
import nl.vpro.domain.media.Segment;
import nl.vpro.domain.media.exceptions.ModificationException;
import nl.vpro.domain.media.nebo.base.ActieType;
import nl.vpro.domain.media.nebo.enrichment.v2_4.AfleveringType;
import nl.vpro.domain.media.nebo.shared.TimeAdapter;
import nl.vpro.domain.media.support.Image;
import nl.vpro.domain.media.support.OwnerType;
import nl.vpro.domain.media.support.TextualType;
import nl.vpro.util.TimeUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="fragmentenType", propOrder={"fragment"})
public class FragmentenType {
    protected List<Fragment> fragment;

    public FragmentenType() {
    }

    public FragmentenType(Program program) {
        if (program.getSegments() != null && program.getSegments().size() > 0 && this.fragment == null) {
            this.fragment = new ArrayList<Fragment>();
        }
        Iterator iterator = program.getSegments().iterator();
        while (iterator.hasNext()) {
            Segment segment;
            Segment currSegment = segment = (Segment)iterator.next();
            Fragment newFragment = this.createFragment(currSegment);
            this.fragment.add(newFragment);
        }
    }

    protected Fragment createFragment(Segment segment) {
        return new Fragment(segment);
    }

    protected static Fragment.Afbeelding createAfbeelding(Segment segment) {
        Image bestImage = null;
        List imageList = segment.getImages();
        for (Image image : imageList) {
            if (bestImage != null && !image.getType().equals((Object)ImageType.STILL)) continue;
            bestImage = image;
        }
        if (bestImage == null) {
            return null;
        }
        Fragment.Afbeelding afbeelding = new Fragment.Afbeelding();
        afbeelding.setActie(null);
        afbeelding.setOmschrijving(bestImage.getDescription() != null ? bestImage.getDescription() : bestImage.getTitle());
        afbeelding.setTitel(bestImage.getTitle());
        afbeelding.setTrefwoorden(null);
        String imageUri = bestImage.getImageUri();
        String pad = imageUri.substring(imageUri.lastIndexOf(58) + 1);
        afbeelding.setPad(pad);
        return afbeelding;
    }

    public List<Fragment> getFragment() {
        if (this.fragment == null) {
            this.fragment = new ArrayList<Fragment>();
        }
        return this.fragment;
    }

    public void setFragment(List<Fragment> fragment) {
        this.fragment = fragment;
    }

    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlType(name="", propOrder={"titel", "omschrijving", "starttijd", "eindtijd", "trefwoorden", "afbeelding"})
    public static class Fragment {
        protected Date eindtijd;
        protected Afbeelding afbeelding;
        protected String trefwoorden;
        private final Segment segment;

        public Fragment() {
            this(new Segment());
        }

        Fragment(Segment segment) {
            this.segment = segment;
            this.setTitel(segment.getMainTitle());
            this.setTrefwoorden(null);
            this.setAfbeelding(FragmentenType.createAfbeelding(segment));
            if (segment.getStart() != null && segment.getDuration() != null) {
                Duration duration = segment.getStart().plus(segment.getDuration().get());
                this.setEindtijd(TimeUtils.asDate((Duration)duration));
            }
        }

        @XmlElement(required=true)
        public String getTitel() {
            return this.segment.getMainTitle();
        }

        public void setTitel(String value) {
            if (value != null) {
                this.segment.addTitle(value, AfleveringType.OWNER, TextualType.MAIN);
            }
        }

        @XmlElement(required=true)
        public String getOmschrijving() {
            return this.segment.getMainDescription() != null ? this.segment.getMainDescription() : this.segment.getMainTitle();
        }

        public void setOmschrijving(String value) {
            this.segment.addDescription(value, AfleveringType.OWNER, TextualType.MAIN);
        }

        @XmlElement(required=true)
        @XmlJavaTypeAdapter(value=TimeAdapter.class)
        public Date getStarttijd() {
            return TimeUtils.asDate((Duration)this.segment.getStart());
        }

        public void setStarttijd(Date value) {
            this.segment.setStart((Duration)TimeUtils.durationOf((Date)value).orElse(null));
        }

        @XmlElement(required=true)
        @XmlJavaTypeAdapter(value=TimeAdapter.class)
        public Date getEindtijd() {
            return this.eindtijd;
        }

        public void setEindtijd(Date value) {
            this.eindtijd = value;
        }

        public Afbeelding getAfbeelding() {
            return this.afbeelding;
        }

        public void setAfbeelding(Afbeelding value) {
            this.afbeelding = value;
        }

        public String getTrefwoorden() {
            return this.trefwoorden;
        }

        public void setTrefwoorden(String value) {
            this.trefwoorden = value;
        }

        @XmlTransient
        public Segment getSegment() {
            if (this.eindtijd != null && this.segment.getStart() != null) {
                try {
                    Duration duration = TimeUtils.durationOf((Date)this.eindtijd).orElse(Duration.ZERO).minus(this.segment.getStart());
                    this.segment.setDuration(duration);
                }
                catch (ModificationException e) {
                    throw new RuntimeException(e);
                }
            }
            this.segment.getImages().clear();
            if (this.afbeelding != null) {
                this.segment.addImage(new Image(OwnerType.BROADCASTER, ImageType.STILL, this.afbeelding.getPad()));
            }
            return this.segment;
        }

        @XmlAccessorType(value=XmlAccessType.PROPERTY)
        @XmlType(name="", propOrder={"titel", "omschrijving", "trefwoorden", "pad"})
        public static class Afbeelding {
            private String titel;
            private String omschrijving;
            private String trefwoorden;
            private String pad;
            private ActieType actie;

            public String getTitel() {
                return this.titel;
            }

            public void setTitel(String value) {
                this.titel = value;
            }

            public String getOmschrijving() {
                return this.omschrijving;
            }

            public void setOmschrijving(String value) {
                this.omschrijving = value;
            }

            public String getTrefwoorden() {
                return this.trefwoorden;
            }

            public void setTrefwoorden(String value) {
                this.trefwoorden = value;
            }

            public String getPad() {
                return this.pad;
            }

            public void setPad(String value) {
                this.pad = value;
            }

            @XmlAttribute
            public ActieType getActie() {
                return this.actie;
            }

            public void setActie(ActieType value) {
                this.actie = value;
            }
        }
    }
}

