/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.domain.media.nebo.enrichment.v2_4;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import nl.vpro.domain.image.ImageType;
import nl.vpro.domain.media.AVType;
import nl.vpro.domain.media.Location;
import nl.vpro.domain.media.Program;
import nl.vpro.domain.media.ProgramType;
import nl.vpro.domain.media.Segment;
import nl.vpro.domain.media.Website;
import nl.vpro.domain.media.nebo.base.AfbeeldingenType;
import nl.vpro.domain.media.nebo.base.FragmentenType;
import nl.vpro.domain.media.nebo.base.TabsType;
import nl.vpro.domain.media.nebo.shared.StreamsType;
import nl.vpro.domain.media.support.Description;
import nl.vpro.domain.media.support.Image;
import nl.vpro.domain.media.support.OwnerType;
import nl.vpro.domain.media.support.TextualType;
import nl.vpro.domain.media.support.Title;
import nl.vpro.util.TextUtil;
import org.apache.commons.lang3.StringUtils;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlType(name="afleveringType", propOrder={"tite", "inh1", "atit", "icon", "inh2", "inh3", "inhk", "mail", "webs", "gids_tekst", "tabs", "fragmenten", "streams"})
public class AfleveringType {
    public static final OwnerType OWNER = OwnerType.BROADCASTER;
    private final Program program;
    private FragmentenType fragmenten;
    private AfbeeldingenType.Icon icon;
    private StreamsType streams;

    public AfleveringType(Program program) {
        this.program = program;
        this.fragmenten = new FragmentenType(program);
        for (Image image : program.getImages()) {
            if (image.getType() != ImageType.ICON) continue;
            this.icon = new AfbeeldingenType.Icon(image);
            break;
        }
        if (program.getLocations() != null && program.getLocations().size() > 0) {
            this.streams = new StreamsType(program);
        }
    }

    public AfleveringType() {
        this.program = new Program();
    }

    @XmlElement(required=true)
    public String getTite() {
        for (Title title : this.program.getTitles()) {
            if (TextualType.MAIN != title.getType() || title.getOwner() != OWNER) continue;
            return title.get();
        }
        return "";
    }

    public void setTite(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.program.addTitle(value, OWNER, TextualType.MAIN);
        }
    }

    public String getInh1() {
        for (Description desc : this.program.getDescriptions()) {
            if (desc.getOwner() != OWNER) continue;
            return desc.get();
        }
        return null;
    }

    public void setInh1(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.program.addDescription(value, OWNER, TextualType.MAIN);
        }
    }

    public String getAtit() {
        return this.program.getSubTitle();
    }

    public void setAtit(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.program.addTitle(value, OWNER, TextualType.SUB);
        }
    }

    public AfbeeldingenType.Icon getIcon() {
        return this.icon;
    }

    public void setIcon(AfbeeldingenType.Icon value) {
        this.icon = value;
    }

    public String getInh2() {
        return this.program.getEpisodeDescription();
    }

    public void setInh2(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.program.addDescription(value, OWNER, TextualType.EPISODE);
        }
    }

    public String getInh3() {
        return null;
    }

    public void setInh3(String value) {
    }

    public String getInhk() {
        for (Description desc : this.program.getDescriptions()) {
            if (desc.getType() != TextualType.SHORT || desc.getOwner() != OWNER) continue;
            return desc.get();
        }
        return null;
    }

    public void setInhk(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.program.addDescription(value, OWNER, TextualType.SHORT);
        }
    }

    public String getMail() {
        return this.program.getMainEmail();
    }

    public void setMail(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.program.getEmail().remove(value);
            this.program.getEmail().add(0, value);
        }
    }

    protected static String validate(String url) {
        if (url == null) {
            return null;
        }
        if (!url.contains(":")) {
            url = "http://" + url;
        }
        if (url.startsWith("HTTP:")) {
            url = "http:" + url.substring("http:".length());
        }
        if (url.startsWith("HTTPS:")) {
            url = "https:" + url.substring("https:".length());
        }
        if (url.endsWith(".")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public String getWebs() {
        Website website = (Website)this.program.getMainWebsite();
        if (website == null) {
            return null;
        }
        return AfleveringType.validate(website.getUrl());
    }

    public void setWebs(String value) {
        List websites = this.program.getWebsites();
        Website website = new Website(value);
        websites.remove(website);
        websites.add(0, website);
    }

    public String getGids_tekst() {
        return this.program.getEpisodeDescription();
    }

    public void setGids_tekst(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.program.addDescription(value, OwnerType.BROADCASTER, TextualType.EPISODE);
        }
    }

    public TabsType getTabs() {
        return null;
    }

    public void setTabs(TabsType value) {
    }

    public FragmentenType getFragmenten() {
        return this.fragmenten != null && this.fragmenten.getFragment().size() > 0 ? this.fragmenten : null;
    }

    public void setFragmenten(FragmentenType value) {
        this.fragmenten = value;
    }

    public StreamsType getStreams() {
        return this.streams;
    }

    public void setStreams(StreamsType value) {
        this.streams = value;
    }

    @XmlAttribute
    public String getPrid() {
        return this.program.getMid();
    }

    public void setPrid(String value) {
        this.program.setMid(value);
    }

    public Program getProgram() {
        this.program.setAVType(AVType.VIDEO);
        this.program.setType(ProgramType.BROADCAST);
        this.program.getSegments().clear();
        if (this.fragmenten != null) {
            for (FragmentenType.Fragment fragment : this.fragmenten.getFragment()) {
                Segment seg = fragment.getSegment();
                seg.setAVType(AVType.VIDEO);
                this.program.addSegment(seg);
            }
        }
        this.program.getImages().clear();
        if (this.icon != null) {
            Image image = new Image();
            String title = this.icon.getTitel();
            if (StringUtils.isEmpty((CharSequence)title)) {
                title = this.program.getMainTitle();
            }
            image.setTitle(TextUtil.sanitize((String)title));
            image.setDescription(TextUtil.sanitize((String)this.icon.getOmschrijving()));
            image.setImageUri(this.icon.getPad());
            image.setOwner(OwnerType.BROADCASTER);
            image.setType(ImageType.ICON);
            this.program.addImage(image);
        }
        this.program.getLocations().clear();
        if (this.streams != null && this.streams.getLocations() != null) {
            for (Location location : this.streams.getLocations()) {
                this.program.addLocation(location);
            }
        }
        return this.program;
    }
}

