/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.domain.media.nebo.shared;

import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import nl.vpro.domain.media.AVAttributes;
import nl.vpro.domain.media.AVFileFormat;
import nl.vpro.domain.media.Location;
import nl.vpro.domain.media.nebo.shared.FormatResType;
import nl.vpro.domain.media.nebo.shared.QualityResType;
import nl.vpro.domain.media.nebo.shared.StreamsType;
import nl.vpro.domain.media.support.OwnerType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="streamType", propOrder={"value"})
public class StreamType {
    @XmlValue
    protected String value;
    @XmlAttribute(name="kwaliteit", required=true)
    protected QualityResType kwaliteit;
    @XmlAttribute(name="formaat", required=true)
    protected FormatResType formaat;

    public StreamType(Location location) {
        Integer bitrate;
        String programUrl = location.getProgramUrl();
        this.kwaliteit = programUrl.contains("NPO_sb.") ? QualityResType.SB : (programUrl.contains("NPO_bb.") ? QualityResType.BB : ((bitrate = location.getBitrate()) != null && bitrate >= QualityResType.STD.getBitrate() ? QualityResType.STD : (bitrate != null && bitrate >= QualityResType.BB.getBitrate() ? QualityResType.BB : (bitrate != null && bitrate <= QualityResType.SB.getBitrate() ? QualityResType.SB : QualityResType.STD))));
        AVFileFormat avFileFormat = location.getAvFileFormat();
        if (avFileFormat != null) {
            switch (avFileFormat) {
                case WM: 
                case WMP: {
                    this.formaat = FormatResType.WMV;
                    break;
                }
                default: {
                    this.formaat = FormatResType.MOV;
                    break;
                }
            }
        } else {
            this.formaat = FormatResType.MOV;
        }
        this.value = programUrl;
    }

    public StreamType() {
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public QualityResType getKwaliteit() {
        return this.kwaliteit;
    }

    public void setKwaliteit(QualityResType value) {
        this.kwaliteit = value;
    }

    public FormatResType getFormaat() {
        return this.formaat;
    }

    public void setFormaat(FormatResType value) {
        this.formaat = value;
    }

    public Location getLocation() {
        Location location = new Location(this.value, OwnerType.BROADCASTER);
        AVAttributes avAttributes = new AVAttributes();
        avAttributes.setAvFileFormat(this.formaat.getAVFileFormat());
        location.setAvAttributes(avAttributes);
        location.setBitrate(Integer.valueOf(this.kwaliteit.getBitrate()));
        return location;
    }

    void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        StreamsType streamsType = (StreamsType)parent;
    }
}

