/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.domain.media.nebo.shared;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import nl.vpro.domain.media.AVAttributes;
import nl.vpro.domain.media.AspectRatio;
import nl.vpro.domain.media.Location;
import nl.vpro.domain.media.Program;
import nl.vpro.domain.media.VideoAttributes;
import nl.vpro.domain.media.nebo.shared.StreamType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlType(propOrder={"stream"})
public class StreamsType {
    protected static final Logger LOG = LoggerFactory.getLogger(StreamsType.class);
    List<StreamType> streams;
    AVAttributes avAttributes;
    Date publishStart;
    Date publishStop;

    public StreamsType(Program program) {
        if (program.getLocations() != null) {
            for (Location location : program.getLocations()) {
                this.addStream(new StreamType(location));
                if (this.publishStart == null || location.getPublishStart().after(this.publishStart)) {
                    this.publishStart = location.getPublishStart();
                }
                if (this.publishStop != null && !location.getPublishStop().before(this.publishStop)) continue;
                this.publishStop = location.getPublishStop();
            }
        }
        this.avAttributes = program.getAvAttributes();
        if (this.publishStart == null) {
            this.publishStart = program.getPublishStart();
        }
        if (this.publishStart == null) {
            this.publishStart = new Date(0L);
        }
    }

    public StreamsType() {
    }

    protected boolean addStream(StreamType type) {
        if (this.streams == null) {
            this.streams = new ArrayList<StreamType>();
        }
        for (StreamType t : this.streams) {
            if (!t.getFormaat().equals((Object)type.getFormaat()) || !t.getKwaliteit().equals((Object)type.getKwaliteit())) continue;
            LOG.error("There is already a stream with this format and quality, so it cannot be added " + type + " in " + this.streams);
            return false;
        }
        this.streams.add(type);
        return true;
    }

    @XmlElement(required=true)
    public List<StreamType> getStream() {
        if (this.streams == null) {
            this.streams = new ArrayList<StreamType>();
        }
        return this.streams;
    }

    public void setStream(List<StreamType> streams) {
        this.streams = streams;
    }

    protected static XMLGregorianCalendar getCalendar(Date date) {
        if (date == null) {
            return null;
        }
        try {
            GregorianCalendar cal = new GregorianCalendar(new Locale("nl", "NL"));
            cal.setTime(date);
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            return null;
        }
    }

    @XmlAttribute(name="publicatie_startdatumtijd", required=true)
    @XmlSchemaType(name="dateTime")
    public XMLGregorianCalendar getPublicatieStartdatumtijd() {
        return StreamsType.getCalendar(this.publishStart);
    }

    public void setPublicatieStartdatumtijd(XMLGregorianCalendar value) {
        this.publishStart = value.toGregorianCalendar().getTime();
    }

    @XmlAttribute(name="publicatie_einddatumtijd")
    @XmlSchemaType(name="dateTime")
    public XMLGregorianCalendar getPublicatieEinddatumtijd() {
        return StreamsType.getCalendar(this.publishStop);
    }

    public void setPublicatieEinddatumtijd(XMLGregorianCalendar value) {
        this.publishStop = value.toGregorianCalendar().getTime();
    }

    @XmlAttribute(name="aspect_ratio", required=true)
    public String getAspectRatio() {
        AspectRatio ar;
        VideoAttributes va;
        if (this.avAttributes != null && (va = this.avAttributes.getVideoAttributes()) != null && (ar = va.getAspectRatio()) != null) {
            return ar.toString();
        }
        return "16:9";
    }

    public void setAspectRatio(String value) {
        VideoAttributes va;
        if (this.avAttributes == null) {
            this.avAttributes = new AVAttributes();
        }
        if ((va = this.avAttributes.getVideoAttributes()) == null) {
            va = new VideoAttributes();
            this.avAttributes.setVideoAttributes(va);
        }
        if (value.equals("16:9")) {
            va.setAspectRatio(AspectRatio._16x9);
        } else if (value.equals("4:3")) {
            va.setAspectRatio(AspectRatio._4x3);
        } else {
            va.setAspectRatio(null);
        }
    }

    public SortedSet<Location> getLocations() {
        if (this.streams != null && this.streams.size() > 0) {
            TreeSet<Location> locations = new TreeSet<Location>();
            for (StreamType stream : this.streams) {
                Location location = stream.getLocation();
                location.setPublishStart(this.publishStart);
                location.setPublishStop(this.publishStop);
                locations.add(location);
            }
            return locations;
        }
        return null;
    }
}

