/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.domain.media.nebo.webonly.v1_4;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import nl.vpro.domain.media.Program;
import nl.vpro.domain.media.nebo.webonly.v1_4.WebonlyType;
import nl.vpro.domain.media.support.Image;
import org.apache.commons.lang3.StringUtils;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlType(name="iconType", propOrder={"file", "titel", "omschrijving", "keywords"})
public class IconType {
    private String file;
    private String title;
    private String omschrijving;
    private String keywords;

    IconType() {
    }

    public IconType(Program program) {
        Image image = (Image)WebonlyType.getFromCollection(program.getImages());
        this.title = StringUtils.isEmpty((CharSequence)image.getTitle()) ? program.getMainTitle() : image.getTitle();
        String uri = image.getImageUri();
        this.file = uri.substring(uri.lastIndexOf(58) + 1) + ".jpg";
        this.omschrijving = image.getDescription();
        this.keywords = this.title;
    }

    @XmlElement(required=true)
    public String getFile() {
        return this.file;
    }

    public void setFile(String value) {
        this.file = value;
    }

    @XmlElement(required=true)
    public String getTitel() {
        return this.title;
    }

    public void setTitel(String value) {
        this.title = value;
    }

    public String getOmschrijving() {
        return this.omschrijving;
    }

    public void setOmschrijving(String value) {
        this.omschrijving = value;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String value) {
        this.keywords = value;
    }
}

