/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.domain.media.nebo.webonly.v1_4;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import nl.vpro.domain.image.ImageType;
import nl.vpro.domain.media.AVType;
import nl.vpro.domain.media.AgeRating;
import nl.vpro.domain.media.ContentRating;
import nl.vpro.domain.media.Genre;
import nl.vpro.domain.media.MediaObject;
import nl.vpro.domain.media.MediaObjects;
import nl.vpro.domain.media.MisGenreType;
import nl.vpro.domain.media.Program;
import nl.vpro.domain.media.ProgramType;
import nl.vpro.domain.media.Website;
import nl.vpro.domain.media.nebo.webonly.v1_4.ActionResType;
import nl.vpro.domain.media.nebo.webonly.v1_4.CategorieenType;
import nl.vpro.domain.media.nebo.webonly.v1_4.GenresType;
import nl.vpro.domain.media.nebo.webonly.v1_4.IconType;
import nl.vpro.domain.media.nebo.webonly.v1_4.MediaType;
import nl.vpro.domain.media.nebo.webonly.v1_4.OmroepType;
import nl.vpro.domain.media.nebo.webonly.v1_4.OmroepenType;
import nl.vpro.domain.media.nebo.webonly.v1_4.ReferentiesType;
import nl.vpro.domain.media.support.Image;
import nl.vpro.domain.media.support.OwnerType;
import nl.vpro.domain.media.support.TextualType;
import nl.vpro.domain.user.Broadcaster;
import nl.vpro.nicam.Kijkwijzer;
import org.apache.commons.lang3.StringUtils;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlType(name="webonly", propOrder={"prid", "srid", "titel", "subtitel", "email", "nicamcodes", "omschrijvingKort", "omschrijvingLang", "website", "media", "categorieen", "genres", "omroepen", "referenties", "bron"})
public class WebonlyType {
    public final OwnerType OWNER = OwnerType.BROADCASTER;
    @XmlAttribute
    private String id;
    private ActionResType action;
    Program program;
    String group;
    private MediaType media;
    private OmroepenType omroepen;

    public WebonlyType(Program program, String group) {
        this.program = program;
        this.group = group;
        this.media = new MediaType(this);
        this.omroepen = new OmroepenType(program.getBroadcasters());
    }

    public WebonlyType() {
        this(new Program(), null);
    }

    @XmlElement(required=true)
    public String getPrid() {
        return this.program.getMid();
    }

    public void setPrid(String value) {
        this.program.setMid(value);
    }

    @XmlElement(required=true)
    public String getSrid() {
        return this.group;
    }

    public void setSrid(String value) {
        this.group = value;
    }

    @XmlElement(required=true)
    public String getTitel() {
        return this.program.getMainTitle();
    }

    public void setTitel(String value) {
        this.program.addTitle(value, this.OWNER, TextualType.MAIN);
    }

    public String getSubtitel() {
        return this.program.getSubTitle();
    }

    public void setSubtitel(String value) {
        this.program.addTitle(value, this.OWNER, TextualType.SUB);
    }

    public String getEmail() {
        return this.program.getMainEmail();
    }

    public void setEmail(String value) {
        List emails = this.program.getEmail();
        emails.remove(value);
        emails.add(0, value);
    }

    public String getNicamcodes() {
        StringBuilder neboRating = new StringBuilder();
        AgeRating ageRating = this.program.getAgeRating();
        if (ageRating != null) {
            switch (ageRating) {
                case _6: {
                    neboRating.append('2');
                    break;
                }
                case _9: {
                    neboRating.append('3');
                    break;
                }
                case _12: {
                    neboRating.append('4');
                    break;
                }
                case _16: {
                    neboRating.append('5');
                }
            }
        }
        for (ContentRating rating : this.program.getContentRatings()) {
            neboRating.append(rating.toChar());
        }
        return neboRating.length() > 0 ? neboRating.toString() : null;
    }

    public void setNicamcodes(String value) {
        Kijkwijzer kijkwijzer = Kijkwijzer.parse((String)value);
        this.program.setAgeRating(kijkwijzer.getAgeRating());
        this.program.getContentRatings().addAll(kijkwijzer.getContentRatings());
    }

    @XmlElement(name="omschrijving_kort")
    public String getOmschrijvingKort() {
        return this.program.getShortDescription();
    }

    public void setOmschrijvingKort(String value) {
        this.program.addDescription(value, this.OWNER, TextualType.SHORT);
    }

    @XmlElement(name="omschrijving_lang")
    public String getOmschrijvingLang() {
        return this.program.getMainDescription();
    }

    public void setOmschrijvingLang(String value) {
        this.program.addDescription(value, this.OWNER, TextualType.MAIN);
    }

    public String getWebsite() {
        Website ws = (Website)WebonlyType.getFromCollection(this.program.getWebsites());
        return ws == null ? null : ws.getUrl();
    }

    public void setWebsite(String value) {
        this.program.getWebsites().remove(new Website(value));
        this.program.getWebsites().add(0, new Website(value));
    }

    public MediaType getMedia() {
        return this.media;
    }

    public void setMedia(MediaType value) {
        this.media = value;
    }

    public CategorieenType getCategorieen() {
        return null;
    }

    public void setCategorieen(CategorieenType value) {
    }

    public GenresType getGenres() {
        if (this.program != null && this.program.getGenres() != null && this.program.getGenres().size() > 0) {
            ArrayList<String> genresList = new ArrayList<String>();
            for (MisGenreType genre : MisGenreType.valueOfGenre((Collection)this.program.getGenres())) {
                genresList.add(genre.getDisplayName());
            }
            return new GenresType(genresList);
        }
        return null;
    }

    public void setGenres(GenresType value) {
        this.program.setGenres((Set)Genre.valueOfMis((Collection)MisGenreType.find(value.getGenre())));
    }

    @XmlElement(required=true)
    public OmroepenType getOmroepen() {
        return this.omroepen;
    }

    public void setOmroepen(OmroepenType value) {
        this.omroepen = value;
    }

    public ReferentiesType getReferenties() {
        return null;
    }

    public void setReferenties(ReferentiesType value) {
        throw new UnsupportedOperationException("referenties not supported");
    }

    public String getBron() {
        return this.program.getSource();
    }

    public void setBron(String value) {
        this.program.setSource(value);
    }

    @XmlAttribute(name="action")
    public ActionResType getAction() {
        return this.action;
    }

    public void setAction(ActionResType value) {
        this.action = value;
    }

    static <E> E getFromCollection(Collection<E> list) {
        if (list != null && list.size() > 0) {
            return list.iterator().next();
        }
        return null;
    }

    @XmlTransient
    public Program getProgram() {
        this.program.setAVType(AVType.VIDEO);
        this.program.setType(ProgramType.CLIP);
        MediaObjects.removeLocations((MediaObject)this.program);
        if (this.media != null) {
            IconType icon;
            if (this.media.getStreams() != null && this.media.getStreams().getLocations() != null) {
                MediaObjects.addAll((MediaObject)this.program, this.media.getStreams().getLocations());
            }
            if ((icon = this.media.getIcon()) != null) {
                Image image = new Image();
                String title = icon.getTitel();
                if (StringUtils.isEmpty((CharSequence)title)) {
                    title = this.program.getMainTitle();
                }
                image.setTitle(title);
                image.setDescription(icon.getOmschrijving());
                image.setImageUri(icon.getFile());
                image.setOwner(OwnerType.BROADCASTER);
                image.setType(ImageType.ICON);
                this.program.addImage(image);
            }
        }
        this.program.getBroadcasters().clear();
        for (OmroepType omroep : this.omroepen.getOmroep()) {
            if (!omroep.isHoofdomroep()) continue;
            this.program.addBroadcaster(new Broadcaster(omroep.getValue()));
        }
        for (OmroepType omroep : this.omroepen.getOmroep()) {
            if (omroep.isHoofdomroep()) continue;
            this.program.addBroadcaster(new Broadcaster(omroep.getValue()));
        }
        if (this.id != null) {
            this.program.addCrid("crid://tmp.program.omroep.nl/" + this.id);
        }
        return this.program;
    }
}

