/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.ektorp;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import nl.vpro.util.ThreadPools;
import org.ektorp.CouchDbConnector;
import org.ektorp.ViewQuery;
import org.ektorp.impl.NameConventions;
import org.ektorp.support.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewRefresher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ViewRefresher.class);
    final List<String> views = new ArrayList<String>();
    final CouchDbConnector couchDbConnector;
    final int scheduleRate;
    String designDocumentId;

    public ViewRefresher(CouchDbConnector masterDb, int scheduleRate, String designDocumentId, Class<?> ... classNames) {
        this.couchDbConnector = masterDb;
        this.scheduleRate = scheduleRate;
        this.designDocumentId = designDocumentId;
        List<Class<?>> classes = Arrays.stream(classNames).collect(Collectors.toList());
        this.init(classes, true);
    }

    public ViewRefresher(CouchDbConnector masterDb, int scheduleRate, Class<?> documents, Class<?> ... clas) {
        this.couchDbConnector = masterDb;
        this.scheduleRate = scheduleRate;
        this.designDocumentId = NameConventions.designDocName(documents);
        List<Class<?>> classes = Arrays.stream(clas).collect(Collectors.toList());
        this.init(classes, false);
    }

    private void init(List<Class<?>> classes, boolean resolveFields) {
        if (this.scheduleRate > 0) {
            ThreadPools.backgroundExecutor.scheduleAtFixedRate(this, 0L, this.scheduleRate, TimeUnit.MINUTES);
            for (Class<?> c : classes) {
                for (Method m : c.getMethods()) {
                    String name;
                    View view = m.getAnnotation(View.class);
                    if (view == null || (name = view.name()).length() <= 0) continue;
                    this.views.add(name);
                }
                if (!resolveFields) continue;
                try {
                    Field field = c.getDeclaredField(this.designDocumentId);
                    field.setAccessible(true);
                    Class<?> t = field.getType();
                    if (t != String.class) continue;
                    log.info("{} is a constant in {}, taking its value {}", new Object[]{this.designDocumentId, c, field.get(null)});
                    this.designDocumentId = (String)field.get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    log.debug(e.getMessage());
                }
            }
            log.info("Refreshing views {}: {}", (Object)this.couchDbConnector.getDatabaseName(), this.views);
        } else {
            log.info("Schedule rate =< 0, not scheduling, not doing anything");
        }
    }

    @Override
    public void run() {
        log.info("Now refreshing views {} {}", (Object)this.couchDbConnector.getDatabaseName(), this.views);
        for (String view : this.views) {
            try {
                this.couchDbConnector.queryView(new ViewQuery().designDocId(this.designDocumentId).viewName(view).staleOkUpdateAfter());
                log.debug("Refreshed {}", (Object)view);
            }
            catch (Exception e) {
                log.warn(e.getClass().getName() + " " + e.getMessage());
            }
        }
    }
}

