/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.ektorp;

import org.ektorp.CouchDbConnector;
import org.ektorp.DbAccessException;
import org.ektorp.impl.NameConventions;
import org.ektorp.support.CouchDbRepositorySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Support<T>
extends CouchDbRepositorySupport<T> {
    private static final Logger log = LoggerFactory.getLogger(Support.class);

    public static <T> Support<T> getInstance(String logInfo, Class<T> type, CouchDbConnector db, boolean createIfNotExists) {
        try {
            return new Support<T>(type, db, createIfNotExists);
        }
        catch (DbAccessException dbe) {
            log.error(logInfo + " " + db.getDatabaseName() + ": " + ((Object)((Object)dbe)).getClass().getName() + " " + dbe.getMessage());
            log.info("Will create a connector to couchdb without trying to check and create the database (supposing it is temporary down now");
            return new Support<T>(type, db, false);
        }
    }

    public static <T> Support<T> getInstance(String logInfo, Class<T> type, CouchDbConnector db) {
        return Support.getInstance(logInfo, type, db, true);
    }

    protected Support(Class<T> type, CouchDbConnector db) {
        super(type, db);
    }

    protected Support(Class<T> type, CouchDbConnector db, boolean createIfNotExists) {
        super(type, db, createIfNotExists);
    }

    public CouchDbConnector getConnector() {
        return this.db;
    }

    public String getPath() {
        return this.getConnector().path();
    }

    public String getDesignDocumentId() {
        return NameConventions.designDocName((Class)this.type);
    }
}

