/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.elasticsearch.highlevel;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import nl.vpro.elasticsearchclient.ElasticSearchIterator;
import nl.vpro.jackson2.Jackson2Mapper;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.meeuw.math.windowed.WindowedEventRate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedElasticSearchIterator<T>
extends ElasticSearchIterator<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtendedElasticSearchIterator.class);
    private SearchSourceBuilder searchSourceBuilder;

    protected ExtendedElasticSearchIterator(@NonNull RestHighLevelClient client, Function<JsonNode, T> adapt, Class<T> adaptTo, Duration scrollContext, Boolean jsonRequests, Boolean requestVersion, String beanName, WindowedEventRate rateMeasurerer, List<String> routingIds) {
        super(client.getLowLevelClient(), adapt, adaptTo, scrollContext, null, false, jsonRequests, requestVersion, beanName, rateMeasurerer, routingIds);
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
    }

    public SearchSourceBuilder prepareSearchSource(String ... indices) {
        this.setIndices(Arrays.asList(indices));
        this.searchSourceBuilder = new SearchSourceBuilder();
        return this.searchSourceBuilder;
    }

    protected boolean firstBatch() {
        if (this.searchSourceBuilder != null) {
            ObjectNode jsonNode;
            byte[] json = XContentHelper.toXContent((ToXContent)this.searchSourceBuilder, (XContentType)XContentType.JSON, (ToXContent.Params)ToXContent.EMPTY_PARAMS, (boolean)false).toBytesRef().bytes;
            this.request = jsonNode = (ObjectNode)Jackson2Mapper.getLenientInstance().readTree(json);
        }
        return super.firstBatch();
    }

    @Generated
    public static <T> ExtendedBuilder<T> extendedBuilder() {
        return new ExtendedBuilder();
    }

    public static class ExtendedBuilder<T>
    extends ElasticSearchIterator.AbstractBuilder<T, ExtendedBuilder<T>> {
        @Generated
        private RestHighLevelClient client;
        @Generated
        private Function<JsonNode, T> adapt;
        @Generated
        private Class<T> adaptTo;
        @Generated
        private Duration scrollContext;
        @Generated
        private Boolean jsonRequests;
        @Generated
        private Boolean requestVersion;
        @Generated
        private String beanName;
        @Generated
        private WindowedEventRate rateMeasurerer;
        @Generated
        private List<String> routingIds;

        @Generated
        public ExtendedBuilder<T> client(@NonNull RestHighLevelClient client) {
            if (client == null) {
                throw new NullPointerException("client is marked non-null but is null");
            }
            this.client = client;
            return this;
        }

        @Generated
        public ExtendedBuilder<T> adapt(Function<JsonNode, T> adapt) {
            this.adapt = adapt;
            return this;
        }

        @Generated
        public ExtendedBuilder<T> adaptTo(Class<T> adaptTo) {
            this.adaptTo = adaptTo;
            return this;
        }

        @Generated
        public ExtendedBuilder<T> scrollContext(Duration scrollContext) {
            this.scrollContext = scrollContext;
            return this;
        }

        @Generated
        public ExtendedBuilder<T> jsonRequests(Boolean jsonRequests) {
            this.jsonRequests = jsonRequests;
            return this;
        }

        @Generated
        public ExtendedBuilder<T> requestVersion(Boolean requestVersion) {
            this.requestVersion = requestVersion;
            return this;
        }

        @Generated
        public ExtendedBuilder<T> beanName(String beanName) {
            this.beanName = beanName;
            return this;
        }

        @Generated
        public ExtendedBuilder<T> rateMeasurerer(WindowedEventRate rateMeasurerer) {
            this.rateMeasurerer = rateMeasurerer;
            return this;
        }

        @Generated
        public ExtendedBuilder<T> routingIds(List<String> routingIds) {
            this.routingIds = routingIds;
            return this;
        }

        @Generated
        public ExtendedElasticSearchIterator<T> build() {
            return new ExtendedElasticSearchIterator<T>(this.client, this.adapt, this.adaptTo, this.scrollContext, this.jsonRequests, this.requestVersion, this.beanName, this.rateMeasurerer, this.routingIds);
        }

        @Generated
        public String toString() {
            return "ExtendedElasticSearchIterator.ExtendedBuilder(client=" + this.client + ", adapt=" + this.adapt + ", adaptTo=" + this.adaptTo + ", scrollContext=" + this.scrollContext + ", jsonRequests=" + this.jsonRequests + ", requestVersion=" + this.requestVersion + ", beanName=" + this.beanName + ", rateMeasurerer=" + this.rateMeasurerer + ", routingIds=" + this.routingIds + ")";
        }
    }
}

