/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.elasticsearch.highlevel;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.management.ObjectName;
import lombok.Generated;
import lombok.NonNull;
import nl.vpro.elasticsearch.ElasticSearchIteratorInterface;
import nl.vpro.elasticsearch.highlevel.HighLevelElasticSearchIteratorMXBean;
import nl.vpro.elasticsearchclient.ElasticSearchIterator;
import nl.vpro.jackson2.Jackson2Mapper;
import nl.vpro.jmx.MBeans;
import nl.vpro.util.ThreadPools;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.meeuw.math.windowed.WindowedEventRate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighLevelElasticSearchIterator<T>
implements ElasticSearchIteratorInterface<T>,
HighLevelElasticSearchIteratorMXBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HighLevelElasticSearchIterator.class);
    private static long instances = 0L;
    private final long instance = instances++;
    private final Function<SearchHit, T> adapt;
    private final RestHighLevelClient client;
    private SearchResponse response;
    private Long count = -1L;
    private SearchHits hits;
    private String scrollId;
    private boolean hasNext;
    private int i = -1;
    private T next;
    private boolean needsNext = true;
    private String[] indices;
    private String[] routing;
    private Instant start;
    private Duration duration = Duration.ofMillis(0L);
    private SearchSourceBuilder searchSourceBuilder;
    private final Duration scrollContext;
    private Long totalSize = null;
    private ElasticSearchIteratorInterface.TotalRelation totalRelation = ElasticSearchIteratorInterface.TotalRelation.EQUAL_TO;
    private final Boolean requestVersion;
    private final WindowedEventRate rate;
    private final ObjectName objectName;
    private RequestOptions requestOptions;

    public static Builder<SearchHit> searchHitsBuilder(RestHighLevelClient client) {
        return HighLevelElasticSearchIterator.builder().client(client);
    }

    public static HighLevelElasticSearchIterator<SearchHit> searchHits(RestHighLevelClient client) {
        return HighLevelElasticSearchIterator.searchHitsBuilder(client).build();
    }

    public static HighLevelElasticSearchIterator<JsonNode> sources(RestHighLevelClient client) {
        return HighLevelElasticSearchIterator.builder().client(client).adapt(HighLevelElasticSearchIterator.adapterTo(JsonNode.class)).build();
    }

    protected HighLevelElasticSearchIterator(@NonNull RestHighLevelClient client, Function<SearchHit, T> adapt, Class<T> adaptTo, Duration scrollContext, String beanName, WindowedEventRate rateMeasurerer, List<String> routingIds, RequestOptions requestOptions, Boolean requestVersion) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.adapt = HighLevelElasticSearchIterator.adapterTo(adapt, adaptTo);
        this.client = client;
        Duration duration = this.scrollContext = scrollContext == null ? Duration.ofSeconds(30L) : scrollContext;
        if (this.scrollContext.isNegative()) {
            throw new IllegalArgumentException();
        }
        this.objectName = beanName != null ? MBeans.registerBean((Object)this, (String)(this.instance + "-" + beanName)) : null;
        this.rate = rateMeasurerer == null ? WindowedEventRate.builder().bucketCount(Integer.valueOf(5)).bucketDuration(Duration.ofMinutes(1L)).build() : rateMeasurerer;
        this.routing = routingIds == null ? null : routingIds.toArray(new String[0]);
        this.requestOptions = requestOptions == null ? RequestOptions.DEFAULT : requestOptions;
        this.requestVersion = requestVersion;
    }

    public static <T> Function<SearchHit, T> adapterTo(Class<T> clazz) {
        return searchHit -> {
            try {
                return Jackson2Mapper.getLenientInstance().readValue(searchHit.getSourceRef().toBytesRef().bytes, clazz);
            }
            catch (Exception e) {
                log.warn("{}: {}", searchHit, (Object)e.getMessage());
                return null;
            }
        };
    }

    private static <T> Function<SearchHit, T> adapterTo(Function<SearchHit, T> adapter, Class<T> clazz) {
        if (adapter != null && clazz != null) {
            throw new IllegalArgumentException();
        }
        if (clazz != null) {
            return HighLevelElasticSearchIterator.adapterTo(clazz);
        }
        if (adapter == null) {
            return searchHit -> searchHit;
        }
        return adapter;
    }

    public SearchSourceBuilder prepareSearchSource(String ... indices) {
        this.indices = indices;
        this.searchSourceBuilder = new SearchSourceBuilder();
        return this.searchSourceBuilder;
    }

    public boolean hasNext() {
        this.findNext();
        return this.hasNext;
    }

    public void start() {
        if (this.response != null) {
            throw new IllegalStateException();
        }
        this.firstBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findNext() {
        if (this.needsNext) {
            HighLevelElasticSearchIterator highLevelElasticSearchIterator = this;
            synchronized (highLevelElasticSearchIterator) {
                long start = System.nanoTime();
                try {
                    boolean newHasNext;
                    if (this.response == null && !this.firstBatch()) {
                        return;
                    }
                    ++this.i;
                    boolean bl = newHasNext = this.i < this.hits.getHits().length;
                    if (!newHasNext) {
                        this.nextBatch();
                    } else {
                        this.hasNext = true;
                    }
                    if (this.hasNext) {
                        this.next = this.adapt.apply(this.hits.getHits()[this.i]);
                    } else {
                        this.close();
                    }
                    this.needsNext = false;
                }
                finally {
                    this.duration = this.duration.plusNanos(System.nanoTime() - start);
                }
            }
        }
    }

    public float getFraction() {
        long total = Duration.between(this.start, Instant.now()).toMillis();
        long es = this.duration.toMillis();
        return (float)es / (float)total;
    }

    protected boolean firstBatch() {
        String newScrollId;
        if (this.searchSourceBuilder == null) {
            throw new IllegalStateException("prepareSearch not called");
        }
        try {
            SearchRequest searchRequest = new SearchRequest(this.indices, this.searchSourceBuilder);
            if (this.requestVersion != null) {
                this.searchSourceBuilder.version(this.requestVersion);
            }
            this.start = Instant.now();
            searchRequest.scroll(this.getScroll());
            this.response = this.client.search(searchRequest, this.requestOptions);
        }
        catch (IOException ioe) {
            throw new RuntimeException("For request " + this.searchSourceBuilder.toString() + ":" + ioe.getMessage(), ioe);
        }
        if (this.hits == null) {
            this.readResponse();
        }
        if ((newScrollId = this.response.getScrollId()) != null) {
            log.debug("Scroll id {} -> {}", (Object)this.scrollId, (Object)newScrollId);
            this.scrollId = newScrollId;
            SCROLL_IDS.add(this.scrollId);
        }
        TotalHits total = this.hits.getTotalHits();
        this.totalSize = total.value;
        if (this.totalSize == 0L) {
            this.hasNext = false;
            this.needsNext = false;
            this.close();
            return false;
        }
        return true;
    }

    private Scroll getScroll() {
        return new Scroll(new TimeValue(this.scrollContext.toMillis(), TimeUnit.MILLISECONDS));
    }

    private void nextBatch() {
        if (this.scrollId != null) {
            try {
                SearchScrollRequest searchScrollRequest = new SearchScrollRequest(this.scrollId);
                searchScrollRequest.scroll(this.getScroll());
                this.response = this.client.scroll(searchScrollRequest, this.requestOptions);
                log.debug("New scroll");
                String newScrollId = this.response.getScrollId();
                if (!this.scrollId.equals(newScrollId)) {
                    log.info("new scroll id {}", (Object)newScrollId);
                    SCROLL_IDS.remove(this.scrollId);
                    this.scrollId = newScrollId;
                    SCROLL_IDS.add(this.scrollId);
                }
                this.readResponse();
                this.i = 0;
                this.hasNext = this.hits.getHits().length > 0;
            }
            catch (ResponseException re) {
                log.warn(re.getMessage());
                this.hits = null;
                this.hasNext = false;
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage());
                throw new RuntimeException("For request " + this.searchSourceBuilder.toString() + ":" + ioe.getMessage(), ioe);
            }
        } else {
            log.warn("No scroll id found, so not possible to scroll next batch");
            this.hasNext = false;
        }
    }

    protected void readResponse() {
        this.hits = this.response.getHits();
        if (this.hits != null) {
            TotalHits total = this.hits.getTotalHits();
            this.totalSize = total.value;
        }
    }

    public T next() {
        this.findNext();
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        Long l = this.count;
        Long l2 = this.count = Long.valueOf(this.count + 1L);
        this.needsNext = true;
        this.rate.newEvent();
        return this.next;
    }

    public @org.checkerframework.checker.nullness.qual.NonNull Optional<Long> getSize() {
        this.findNext();
        return Optional.ofNullable(this.totalSize);
    }

    public Optional<ElasticSearchIteratorInterface.TotalRelation> getSizeQualifier() {
        this.findNext();
        if (this.hits != null) {
            TotalHits total = this.hits.getTotalHits();
            this.totalRelation = ElasticSearchIteratorInterface.TotalRelation.valueOf((String)total.relation.name());
            this.totalSize = total.value;
        }
        return Optional.ofNullable(this.totalRelation);
    }

    public SearchResponse getResponse() {
        this.findNext();
        return this.response;
    }

    public String toString() {
        return this.client + " " + this.searchSourceBuilder + " " + this.count;
    }

    public void close() {
        if (this.objectName != null) {
            ThreadPools.backgroundExecutor.schedule(() -> MBeans.unregister((ObjectName)this.objectName), 2L, TimeUnit.MINUTES);
        }
        if (this.scrollId != null) {
            try {
                ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                clearScrollRequest.addScrollId(this.scrollId);
                ClearScrollResponse clearScrollResponse = this.client.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
                if (clearScrollResponse.isSucceeded()) {
                    log.debug("Deleted {} {}", (Object)this.scrollId, (Object)clearScrollResponse);
                    SCROLL_IDS.remove(this.scrollId);
                } else {
                    log.warn("Something wrong deleting scroll id {} {}", (Object)this.scrollId, (Object)clearScrollResponse);
                }
                this.scrollId = null;
            }
            catch (ResponseException re) {
                if (re.getResponse().getStatusLine().getStatusCode() == 404) {
                    log.debug("Not found to delete");
                } else {
                    log.warn(re.getMessage());
                }
                EntityUtils.consumeQuietly((HttpEntity)re.getResponse().getEntity());
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        } else {
            log.debug("no need to close");
        }
    }

    public double getSpeed() {
        return this.rate.getRate();
    }

    @Generated
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated
    public long getInstance() {
        return this.instance;
    }

    @Generated
    public Long getCount() {
        return this.count;
    }

    @Generated
    public String[] getRouting() {
        return this.routing;
    }

    @Generated
    public void setRouting(String[] routing) {
        this.routing = routing;
    }

    @Generated
    public Instant getStart() {
        return this.start;
    }

    @Generated
    public Duration getDuration() {
        return this.duration;
    }

    @Generated
    public WindowedEventRate getRate() {
        return this.rate;
    }

    @Generated
    public RequestOptions getRequestOptions() {
        return this.requestOptions;
    }

    @Generated
    public void setRequestOptions(RequestOptions requestOptions) {
        this.requestOptions = requestOptions;
    }

    public static class Builder<T>
    extends ElasticSearchIterator.AbstractBuilder<T, Builder<T>> {
        @Generated
        private RestHighLevelClient client;
        @Generated
        private Function<SearchHit, T> adapt;
        @Generated
        private Class<T> adaptTo;
        @Generated
        private Duration scrollContext;
        @Generated
        private String beanName;
        @Generated
        private WindowedEventRate rateMeasurerer;
        @Generated
        private List<String> routingIds;
        @Generated
        private RequestOptions requestOptions;
        @Generated
        private Boolean requestVersion;

        @Generated
        public Builder<T> client(@NonNull RestHighLevelClient client) {
            if (client == null) {
                throw new NullPointerException("client is marked non-null but is null");
            }
            this.client = client;
            return this;
        }

        @Generated
        public Builder<T> adapt(Function<SearchHit, T> adapt) {
            this.adapt = adapt;
            return this;
        }

        @Generated
        public Builder<T> adaptTo(Class<T> adaptTo) {
            this.adaptTo = adaptTo;
            return this;
        }

        @Generated
        public Builder<T> scrollContext(Duration scrollContext) {
            this.scrollContext = scrollContext;
            return this;
        }

        @Generated
        public Builder<T> beanName(String beanName) {
            this.beanName = beanName;
            return this;
        }

        @Generated
        public Builder<T> rateMeasurerer(WindowedEventRate rateMeasurerer) {
            this.rateMeasurerer = rateMeasurerer;
            return this;
        }

        @Generated
        public Builder<T> routingIds(List<String> routingIds) {
            this.routingIds = routingIds;
            return this;
        }

        @Generated
        public Builder<T> requestOptions(RequestOptions requestOptions) {
            this.requestOptions = requestOptions;
            return this;
        }

        @Generated
        public Builder<T> requestVersion(Boolean requestVersion) {
            this.requestVersion = requestVersion;
            return this;
        }

        @Generated
        public HighLevelElasticSearchIterator<T> build() {
            return new HighLevelElasticSearchIterator<T>(this.client, this.adapt, this.adaptTo, this.scrollContext, this.beanName, this.rateMeasurerer, this.routingIds, this.requestOptions, this.requestVersion);
        }

        @Generated
        public String toString() {
            return "HighLevelElasticSearchIterator.Builder(client=" + this.client + ", adapt=" + this.adapt + ", adaptTo=" + this.adaptTo + ", scrollContext=" + this.scrollContext + ", beanName=" + this.beanName + ", rateMeasurerer=" + this.rateMeasurerer + ", routingIds=" + this.routingIds + ", requestOptions=" + this.requestOptions + ", requestVersion=" + this.requestVersion + ")";
        }
    }
}

