/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.elasticsearch;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.PostConstruct;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import nl.vpro.elasticsearch.ClientFactorySwitcherMBean;
import nl.vpro.elasticsearch.ESClientFactory;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientFactorySwitcher
implements ESClientFactory,
ClientFactorySwitcherMBean {
    private static final Logger log = LoggerFactory.getLogger(ClientFactorySwitcher.class);
    private final Map<String, ESClientFactory> map = new HashMap<String, ESClientFactory>();
    private String configured;
    private String name = ClientFactorySwitcher.class.getName();
    private boolean testAfterConstruct = false;

    public ClientFactorySwitcher(String configured, String name, Map<String, ESClientFactory> map) {
        this.name = name;
        this.map.putAll(map);
        this.setConfigured(configured);
    }

    @PostConstruct
    public void init() throws MalformedObjectNameException, NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName oname = new ObjectName("nl.vpro.elasticsearch:name=" + this.name);
        mbs.registerMBean(this, oname);
        if (this.testAfterConstruct) {
            try {
                log.info("Using {}", (Object)this.map.get(this.configured));
                Client client = this.client("afterconstruct");
                long count = ((SearchResponse)client.prepareSearch(new String[0]).execute().get()).getHits().getTotalHits();
                client.close();
                log.info("Found {} objects in {}", (Object)count, (Object)this);
            }
            catch (InterruptedException | ExecutionException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public Client client(String logName) {
        return this.map.get(this.configured).client(logName);
    }

    @Override
    public void setConfigured(String configured) {
        if (!this.map.containsKey(configured)) {
            throw new IllegalArgumentException("Configured should be one of " + this.map.keySet());
        }
        this.configured = configured;
    }

    @Override
    public String getConfigured() {
        return this.configured;
    }

    public String toString() {
        return String.valueOf(this.map) + " (" + this.configured + ")";
    }

    public void setTestAfterConstruct(boolean testAfterConstruct) {
        this.testAfterConstruct = testAfterConstruct;
    }
}

