/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.elasticsearch;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import nl.vpro.elasticsearch.ESClientFactory;
import org.apache.commons.io.IOUtils;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexHelper {
    private final Logger log;
    private Supplier<String> indexNameSupplier;
    private Supplier<String> settings;
    private ESClientFactory clientFactory;
    private final Map<String, Supplier<String>> mappings = new HashMap<String, Supplier<String>>();

    private static String getResourceAsString(String resource) {
        try {
            StringWriter e = new StringWriter();
            InputStream inputStream = IndexHelper.class.getClassLoader().getResourceAsStream(resource);
            if (inputStream == null) {
                throw new IllegalStateException("Could not find " + resource);
            }
            IOUtils.copy((InputStream)inputStream, (Writer)e, (Charset)StandardCharsets.UTF_8);
            return e.toString();
        }
        catch (IOException var3) {
            throw new IllegalStateException(var3);
        }
    }

    private IndexHelper(Logger log, ESClientFactory client, Supplier<String> indexNameSupplier, Supplier<String> settings, Map<String, Supplier<String>> mappings) {
        this.log = log == null ? LoggerFactory.getLogger(IndexHelper.class) : log;
        this.clientFactory = client;
        this.indexNameSupplier = indexNameSupplier;
        this.settings = settings;
        if (mappings != null) {
            this.mappings.putAll(mappings);
        }
    }

    public static IndexHelper of(Logger log, ESClientFactory client, String indexName, String objectType) {
        return IndexHelper.builder().log(log).client(client).indexName(indexName).settingsResource("es/setting.json").mappingResource(objectType, String.format("es/%s.json", objectType)).build();
    }

    public static IndexHelper of(Logger log, ESClientFactory client, Supplier<String> indexName, String objectType) {
        return IndexHelper.builder().log(log).client(client).indexNameSupplier(indexName).settingsResource("es/setting.json").mappingResource(objectType, String.format("es/%s.json", objectType)).build();
    }

    public IndexHelper mapping(String type, Supplier<String> mapping) {
        this.mappings.put(type, mapping);
        return this;
    }

    public Client client() {
        return this.clientFactory.client(IndexHelper.class.getName() + "." + this.indexNameSupplier.get());
    }

    public void createIndex() {
        if (this.indexNameSupplier == null) {
            throw new IllegalStateException("No index name configured");
        }
        try {
            String indexName = this.indexNameSupplier.get();
            CreateIndexRequestBuilder createIndexRequestBuilder = this.client().admin().indices().prepareCreate(indexName).setSettings(this.settings.get(), XContentType.JSON);
            for (Map.Entry<String, Supplier<String>> e : this.mappings.entrySet()) {
                createIndexRequestBuilder.addMapping(e.getKey(), e.getValue().get(), XContentType.JSON);
            }
            this.log.debug("Creating index {} with mappings {}", (Object)indexName, this.mappings.keySet());
            CreateIndexResponse response = (CreateIndexResponse)createIndexRequestBuilder.execute().actionGet();
            if (response.isAcknowledged()) {
                this.log.info("Created index {} with mappings {}", (Object)indexName, this.mappings.keySet());
            } else {
                this.log.warn("Could not create index {}", (Object)indexName);
            }
        }
        catch (ResourceAlreadyExistsException e) {
            this.log.info("Index exists");
        }
    }

    public void prepareIndex() {
        try {
            boolean exists = ((IndicesExistsResponse)this.client().admin().indices().prepareExists(new String[]{this.getIndexName()}).execute().actionGet()).isExists();
            if (!exists) {
                this.log.info("Index '{}' not existing in {}, now creating", (Object)this.getIndexName(), (Object)this.clientFactory);
                try {
                    this.createIndex();
                }
                catch (Exception e) {
                    String c = e.getCause() != null ? " " + e.getCause().getMessage() : "";
                    this.log.error(e.getMessage() + c);
                }
            } else {
                this.log.info("Found {} objects in '{}' of {}", new Object[]{this.count(), this.getIndexName(), this.clientFactory});
            }
        }
        catch (NoNodeAvailableException noNodeAvailableException) {
            this.log.error(noNodeAvailableException.getMessage());
        }
    }

    public void deleteIndex() {
        this.client().admin().indices().prepareDelete(new String[]{this.getIndexName()}).execute().actionGet();
    }

    public RefreshResponse refresh() {
        return (RefreshResponse)this.client().admin().indices().prepareRefresh(new String[]{this.getIndexName()}).get();
    }

    public long count() {
        return ((SearchResponse)this.client().prepareSearch(new String[]{this.getIndexName()}).setSource(new SearchSourceBuilder().size(0)).get()).getHits().getTotalHits();
    }

    public void setIndexName(String indexName) {
        this.indexNameSupplier = () -> indexName;
    }

    public String getIndexName() {
        return this.indexNameSupplier.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "IndexHelper(log=" + this.getLog() + ", indexNameSupplier=" + this.getIndexNameSupplier() + ", settings=" + this.getSettings() + ", clientFactory=" + this.getClientFactory() + ", mappings=" + this.getMappings() + ")";
    }

    public Logger getLog() {
        return this.log;
    }

    public Supplier<String> getIndexNameSupplier() {
        return this.indexNameSupplier;
    }

    public Supplier<String> getSettings() {
        return this.settings;
    }

    public ESClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public Map<String, Supplier<String>> getMappings() {
        return this.mappings;
    }

    public void setIndexNameSupplier(Supplier<String> indexNameSupplier) {
        this.indexNameSupplier = indexNameSupplier;
    }

    public void setSettings(Supplier<String> settings) {
        this.settings = settings;
    }

    public void setClientFactory(ESClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public static class Builder {
        private Logger log;
        private ESClientFactory client;
        private Supplier<String> indexNameSupplier;
        private Supplier<String> settings;
        private final Map<String, Supplier<String>> mappings = new HashMap<String, Supplier<String>>();

        public Builder mapping(String type, Supplier<String> mapping) {
            this.mappings.put(type, mapping);
            return this;
        }

        public Builder mappingResource(String type, String mapping) {
            return this.mapping(type, () -> IndexHelper.getResourceAsString(mapping));
        }

        public Builder mappings(Map<String, Supplier<String>> mappings) {
            this.mappings.putAll(mappings);
            return this;
        }

        public Builder settingsResource(String resource) {
            return this.settings(() -> IndexHelper.getResourceAsString(resource));
        }

        public Builder indexName(String indexName) {
            return this.indexNameSupplier(() -> indexName);
        }

        Builder() {
        }

        public Builder log(Logger log) {
            this.log = log;
            return this;
        }

        public Builder client(ESClientFactory client) {
            this.client = client;
            return this;
        }

        public Builder indexNameSupplier(Supplier<String> indexNameSupplier) {
            this.indexNameSupplier = indexNameSupplier;
            return this;
        }

        public Builder settings(Supplier<String> settings) {
            this.settings = settings;
            return this;
        }

        public IndexHelper build() {
            return new IndexHelper(this.log, this.client, this.indexNameSupplier, this.settings, this.mappings);
        }

        public String toString() {
            return "IndexHelper.Builder(log=" + this.log + ", client=" + this.client + ", indexNameSupplier=" + this.indexNameSupplier + ", settings=" + this.settings + ", mappings=" + this.mappings + ")";
        }
    }
}

