/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.elasticsearch;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl.vpro.elasticsearch.ESClientFactory;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.InternalSettingsPreparer;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.transport.Netty4Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

@Deprecated
public class JoinClusterClientFactory
implements ESClientFactory {
    private static final Logger log = LoggerFactory.getLogger(JoinClusterClientFactory.class);
    private Node node;
    private Client client;
    private String clusterName = "myCluster";
    private String nodeName = JoinClusterClientFactory.class.getSimpleName();
    private boolean httpEnabled = false;
    private String unicastHosts = null;
    private int defaultPort = 9300;
    private String tcpPort = "9350-9400";
    private String networkHost = null;
    private String pathHome = "/tmp/";
    private Map<String, String> additionalSettings = new HashMap<String, String>();

    private Settings getSettings(Logger logger) {
        if (logger == null) {
            logger = NOPLogger.NOP_LOGGER;
        }
        Settings.Builder settings = Settings.builder();
        if (this.httpEnabled) {
            settings.put("http.enabled", this.httpEnabled).put("transport.profiles.default.port", this.defaultPort);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.unicastHosts)) {
            settings.put("discovery.zen.ping.unicast.hosts", this.unicastHosts);
        } else {
            logger.warn("No unicast hosts set. Will use multicast");
        }
        if (this.networkHost != null) {
            settings.put("network.host", this.networkHost);
        }
        if (StringUtils.isBlank((CharSequence)this.tcpPort)) {
            this.tcpPort = "9350-9400";
        }
        settings.put("transport.tcp.port", this.tcpPort).put(Node.NODE_NAME_SETTING.getKey(), this.nodeName).put(this.additionalSettings).put(Node.NODE_MASTER_SETTING.getKey(), false).put(Node.NODE_DATA_SETTING.getKey(), false).put("transport.type", "netty4").put("http.type", "netty4").put("path.home", this.pathHome).put("cluster.name", this.clusterName);
        return settings.build();
    }

    public Callable<Client> client(Logger logger) {
        return () -> {
            if (this.client != null) {
                return this.client;
            }
            JoinClusterClientFactory joinClusterClientFactory = this;
            synchronized (joinClusterClientFactory) {
                if (this.client == null) {
                    Settings settings = this.getSettings(logger);
                    List<Class<? extends Plugin>> plugins = Collections.singletonList(Netty4Plugin.class);
                    this.node = new PluginConfigurableNode(settings, plugins).start();
                    this.node.start();
                    this.client = this.node.client();
                }
            }
            return this.client;
        };
    }

    private void reset() {
        this.shutdown();
        this.client = null;
        this.node = null;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.reset();
        this.clusterName = clusterName;
    }

    public boolean isHttpEnabled() {
        return this.httpEnabled;
    }

    public void setHttpEnabled(boolean httpEnabled) {
        this.reset();
        this.httpEnabled = httpEnabled;
    }

    public String getPathHome() {
        return this.pathHome;
    }

    public void setPathHome(String pathHome) {
        this.reset();
        this.pathHome = pathHome;
    }

    public String getUnicastHosts() {
        return this.unicastHosts;
    }

    public void setUnicastHosts(String unicastHosts) {
        this.unicastHosts = unicastHosts;
        this.reset();
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public void setDefaultPort(int defaultPort) {
        this.defaultPort = defaultPort;
        this.reset();
    }

    public String getTcpPort() {
        return this.tcpPort;
    }

    public void setTcpPort(String tcpPort) {
        this.tcpPort = tcpPort;
        this.reset();
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
        this.reset();
    }

    public String getNetworkHost() {
        return this.networkHost;
    }

    public void setNetworkHost(String networkName) {
        this.networkHost = networkName;
        this.reset();
    }

    public Map<String, String> getAdditionalSettings() {
        return this.additionalSettings;
    }

    public void setAdditionalSettings(Map<String, String> additionalSettings) {
        this.additionalSettings = additionalSettings;
        this.reset();
    }

    @Override
    public Client client(String logName) {
        try {
            return this.client(LoggerFactory.getLogger((String)logName)).call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PostConstruct
    public void init() {
        log.info("Created {}", (Object)this);
    }

    @PreDestroy
    public void shutdown() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.node != null) {
            try {
                this.node.close();
            }
            catch (IOException ioe) {
                log.warn(ioe.getMessage());
            }
        }
    }

    public String toString() {
        return "ES " + (this.nodeName == null ? "" : this.nodeName + "@") + this.clusterName + (StringUtils.isNotBlank((CharSequence)this.unicastHosts) ? " (" + this.unicastHosts + ")" : "") + this.getSettings(null).getAsMap();
    }

    private static class PluginConfigurableNode
    extends Node {
        public PluginConfigurableNode(Settings settings, Collection<Class<? extends Plugin>> classpathPlugins) {
            super(InternalSettingsPreparer.prepareEnvironment((Settings)settings, null), classpathPlugins);
        }
    }
}

