/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.elasticsearch;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import nl.vpro.elasticsearch.ESClientFactory;
import nl.vpro.util.UrlProvider;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportClientFactory
implements ESClientFactory {
    private static final Logger log = LoggerFactory.getLogger(TransportClientFactory.class);
    private List<UrlProvider> transportAddresses = Collections.emptyList();
    private String clusterName;
    private boolean implicitHttpToJavaPort = false;
    private boolean ignoreClusterName = false;
    private Client client = null;

    Client buildClient() {
        return this.client("test");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client client(String logName) {
        if (this.client == null) {
            TransportClientFactory transportClientFactory = this;
            synchronized (transportClientFactory) {
                if (this.client == null) {
                    try {
                        this.client = this.constructClient(logName);
                        log.info("Constructed client {} ({} {}) (on behalf of {}", new Object[]{this.client, this.transportAddresses, this.clusterName, logName});
                    }
                    catch (UnknownHostException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    log.debug("Construction client on behalf of {} not needed (already happend in other thread)", (Object)logName);
                }
            }
        }
        return this.client;
    }

    private Client constructClient(String logName) throws UnknownHostException {
        Settings.Builder builder = Settings.builder();
        if (this.ignoreClusterName || StringUtils.isBlank((CharSequence)this.clusterName)) {
            builder.put("client.transport.ignore_cluster_name", true);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clusterName)) {
            builder.put("cluster.name", this.clusterName);
        }
        PreBuiltTransportClient transportClient = new PreBuiltTransportClient(builder.build(), new Class[0]);
        for (UrlProvider urlProvider : this.transportAddresses) {
            int port = urlProvider.getPort();
            if (this.implicitHttpToJavaPort && port < 9300 && port >= 9200) {
                log.info("Port is configured {}, but we need a java protocol port. Taking {}", (Object)port, (Object)(port + 100));
                port += 100;
            }
            transportClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(urlProvider.getHost()), port));
        }
        log.debug("Build es client {} {} ({})", new Object[]{logName, this.transportAddresses, this.clusterName});
        return transportClient;
    }

    public void setElasticSearchHosts(String string) {
        int defaultPort;
        String hosts;
        int index = string.lastIndexOf(":");
        if (index > 0) {
            hosts = string.substring(0, index);
            defaultPort = Integer.parseInt(string.substring(index + 1, string.length()));
        } else {
            hosts = string;
            defaultPort = 9300;
        }
        this.transportAddresses = Arrays.stream(hosts.split("\\s*,\\s*")).map(s -> {
            String[] split = s.split(":", 2);
            return new UrlProvider(split[0], split.length < 2 ? -1 : Integer.parseInt(split[1]));
        }).collect(Collectors.toList());
        for (UrlProvider u : this.transportAddresses) {
            if (u.getPort() != -1) continue;
            u.setPort(defaultPort);
        }
        this.reset();
    }

    public void setTransportAddresses(UrlProvider ... transportAddresses) {
        this.transportAddresses = Arrays.asList(transportAddresses);
        this.reset();
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
        this.reset();
    }

    public void setImplicitHttpToJavaPort(boolean implicitHttpToJavaPort) {
        this.implicitHttpToJavaPort = implicitHttpToJavaPort;
        this.reset();
    }

    public void setIgnoreClusterName(boolean ignoreClusterName) {
        this.reset();
        this.ignoreClusterName = ignoreClusterName;
    }

    private void reset() {
        this.shutdown();
        this.client = null;
    }

    @PreDestroy
    public void shutdown() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public String toString() {
        return this.transportAddresses + " " + this.clusterName;
    }

    public List<UrlProvider> getTransportAddresses() {
        return this.transportAddresses;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public boolean isImplicitHttpToJavaPort() {
        return this.implicitHttpToJavaPort;
    }

    public boolean isIgnoreClusterName() {
        return this.ignoreClusterName;
    }
}

