/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.elasticsearch7;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import nl.vpro.elasticsearch.ElasticSearchIteratorInterface;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchIterator<T>
implements ElasticSearchIteratorInterface<T> {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchIterator.class);
    final Function<SearchHit, T> adapt;
    final Client client;
    boolean version = true;
    SearchRequestBuilder builder;
    SearchResponse response;
    SearchHit[] hits;
    private long count = -1L;
    boolean hasNext;
    int i = -1;
    T next;
    boolean needsNext;

    public static ElasticSearchIterator<SearchHit> searchHits(Client client) {
        return new ElasticSearchIterator<SearchHit>(client, sh -> sh);
    }

    public ElasticSearchIterator(Client client, Function<SearchHit, T> adapt) {
        this(client, adapt, false);
    }

    protected ElasticSearchIterator(Client client, Function<SearchHit, T> adapt, boolean version) {
        this.adapt = adapt;
        this.client = client;
        this.needsNext = true;
        this.version = version;
    }

    public SearchRequestBuilder prepareSearch(String ... indices) {
        this.builder = this.client.prepareSearch(indices);
        this.builder.setVersion(true);
        this.builder.setScroll(TimeValue.timeValueSeconds((long)60L));
        this.builder.setSize(1000);
        return this.builder;
    }

    public boolean hasNext() {
        this.findNext();
        return this.hasNext;
    }

    protected void findNext() {
        if (this.needsNext) {
            boolean newHasNext;
            if (this.response == null) {
                if (this.builder == null) {
                    throw new IllegalStateException("prepareSearch not called");
                }
                this.response = (SearchResponse)this.builder.get();
                this.hits = this.response.getHits().getHits();
                if (this.hits.length == 0) {
                    this.hasNext = false;
                    this.needsNext = false;
                    this.close();
                    return;
                }
            }
            ++this.i;
            boolean bl = newHasNext = this.i < this.hits.length;
            if (!newHasNext) {
                if (this.response.getScrollId() != null) {
                    this.response = (SearchResponse)this.client.prepareSearchScroll(this.response.getScrollId()).setScroll(new TimeValue(60000L)).execute().actionGet();
                    this.hits = this.response.getHits().getHits();
                    this.i = 0;
                    this.hasNext = this.hits.length > 0;
                } else {
                    log.warn("No scroll id found, so not possible to scroll next batch");
                    this.hasNext = false;
                }
            } else {
                this.hasNext = true;
            }
            if (this.hasNext) {
                this.next = this.adapt.apply(this.hits[this.i]);
            } else {
                this.close();
            }
            this.needsNext = false;
        }
    }

    public T next() {
        this.findNext();
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        ++this.count;
        this.needsNext = true;
        return this.next;
    }

    public Optional<Long> getSize() {
        this.findNext();
        return this.response == null ? Optional.empty() : Optional.of(this.response.getHits().getTotalHits().value);
    }

    public Optional<ElasticSearchIteratorInterface.TotalRelation> getSizeQualifier() {
        this.findNext();
        return this.response == null ? Optional.empty() : Optional.of(ElasticSearchIteratorInterface.TotalRelation.valueOf((String)this.response.getHits().getTotalHits().relation.name()));
    }

    public Long getCount() {
        return this.count;
    }

    public void close() {
        if (this.response != null && this.response.getScrollId() != null) {
            ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
            clearScrollRequest.addScrollId(this.response.getScrollId());
            ActionFuture clearScrollResponseActionFuture = this.client.clearScroll(clearScrollRequest);
            log.debug("{}", (Object)clearScrollResponseActionFuture);
            this.response = null;
        } else {
            log.debug("no need to close");
        }
    }

    public static <T> ElasticSearchIteratorBuilder<T> builder() {
        return new ElasticSearchIteratorBuilder();
    }

    public boolean isVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public static class ElasticSearchIteratorBuilder<T> {
        private Client client;
        private Function<SearchHit, T> adapt;
        private boolean version;

        ElasticSearchIteratorBuilder() {
        }

        public ElasticSearchIteratorBuilder<T> client(Client client) {
            this.client = client;
            return this;
        }

        public ElasticSearchIteratorBuilder<T> adapt(Function<SearchHit, T> adapt) {
            this.adapt = adapt;
            return this;
        }

        public ElasticSearchIteratorBuilder<T> version(boolean version) {
            this.version = version;
            return this;
        }

        public ElasticSearchIterator<T> build() {
            return new ElasticSearchIterator<T>(this.client, this.adapt, this.version);
        }

        public String toString() {
            return "ElasticSearchIterator.ElasticSearchIteratorBuilder(client=" + this.client + ", adapt=" + this.adapt + ", version=" + this.version + ")";
        }
    }
}

