/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.elasticsearch7;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import nl.vpro.elasticsearch.CreateIndex;
import nl.vpro.elasticsearch.ElasticSearchIndex;
import nl.vpro.elasticsearch.IndexHelperInterface;
import nl.vpro.elasticsearch7.ESClientFactory;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexHelper
implements IndexHelperInterface<Client> {
    private final Logger log;
    private Supplier<String> indexNameSupplier;
    private Supplier<Settings> settings;
    private ESClientFactory clientFactory;
    private final Map<String, Supplier<String>> mappings = new HashMap<String, Supplier<String>>();

    private IndexHelper(Logger log, ESClientFactory client, Supplier<String> indexNameSupplier, Supplier<String> settings, Map<String, Supplier<String>> mappings) {
        this.log = log == null ? LoggerFactory.getLogger(IndexHelper.class) : log;
        this.clientFactory = client;
        this.indexNameSupplier = indexNameSupplier;
        Supplier<Settings> supplier = this.settings = settings == null ? null : () -> Settings.builder().loadFromSource((String)settings.get(), XContentType.JSON).build();
        if (mappings != null) {
            this.mappings.putAll(mappings);
        }
    }

    public static IndexHelper of(Logger log, ESClientFactory client, String indexName, String objectType) {
        return IndexHelper.builder().log(log).client(client).indexName(indexName).settingsResource("es/setting.json").mappingResource(objectType, String.format("es/%s.json", objectType)).build();
    }

    public static Builder of(Logger log, ESClientFactory client, Supplier<String> indexName, String objectType) {
        return IndexHelper.builder().log(log).client(client).indexNameSupplier(indexName).settingsResource("es/setting.json").mappingResource(objectType, String.format("es/%s.json", objectType));
    }

    public static Builder of(Logger log, ESClientFactory client, ElasticSearchIndex index) {
        return IndexHelper.builder().log(log).client(client).indexNameSupplier(() -> ((ElasticSearchIndex)index).getIndexName()).settingsResource(index.getSettingsResource()).mappings(index.mappingsAsMap());
    }

    public IndexHelper mapping(String type, Supplier<String> mapping) {
        this.mappings.put(type, mapping);
        return this;
    }

    public Client client() {
        return this.clientFactory.client(IndexHelper.class.getName() + "." + this.indexNameSupplier.get());
    }

    public void createIndex(CreateIndex createIndex) {
        if (this.indexNameSupplier == null) {
            throw new IllegalStateException("No index name configured");
        }
        try {
            String indexName = this.indexNameSupplier.get();
            Settings s = this.settings.get();
            if (createIndex.isForReindex()) {
                s = Settings.builder().put(s).put("index.number_of_replicas", 0).put("refresh_interval", -1).build();
            }
            if (createIndex.getNumberOfReplicas() != null) {
                s = Settings.builder().put(s).put("index.number_of_shards", createIndex.getShards().intValue()).build();
            }
            if (createIndex.getShards() != null) {
                s = Settings.builder().put(s).put("index.number_of_shards", createIndex.getShards().intValue()).build();
            }
            if (createIndex.isCreateAliases() && createIndex.isUseNumberPostfix()) {
                throw new UnsupportedOperationException();
            }
            if (this.mappings.isEmpty() && createIndex.isRequireMappings()) {
                throw new IllegalStateException("No mappings provided in " + this);
            }
            CreateIndexRequestBuilder createIndexRequestBuilder = this.client().admin().indices().prepareCreate(indexName).setSettings(s);
            for (Map.Entry<String, Supplier<String>> e : this.mappings.entrySet()) {
                createIndexRequestBuilder.addMapping(e.getKey(), e.getValue().get(), XContentType.JSON);
            }
            this.log.debug("Creating index {} with mappings {}", (Object)indexName, this.mappings.keySet());
            CreateIndexResponse response = (CreateIndexResponse)createIndexRequestBuilder.execute().actionGet();
            if (response.isAcknowledged()) {
                this.log.info("Created index {} with mappings {}", (Object)indexName, this.mappings.keySet());
            } else {
                this.log.warn("Could not create index {}", (Object)indexName);
            }
        }
        catch (ResourceAlreadyExistsException e) {
            this.log.info("Index exists {}", (Object)e.getMessage());
        }
    }

    public boolean checkIndex() {
        return ((IndicesExistsResponse)this.client().admin().indices().prepareExists(new String[]{this.getIndexName()}).execute().actionGet()).isExists();
    }

    public void deleteIndex() {
        this.client().admin().indices().prepareDelete(new String[]{this.getIndexName()}).execute().actionGet();
    }

    public RefreshResponse refresh() {
        return (RefreshResponse)this.client().admin().indices().prepareRefresh(new String[]{this.getIndexName()}).get();
    }

    public long count() {
        return ((SearchResponse)this.client().prepareSearch((String[])new String[]{this.getIndexName()}).setSource((SearchSourceBuilder)new SearchSourceBuilder().size((int)0)).get()).getHits().getTotalHits().value;
    }

    public void setIndexName(String indexName) {
        this.indexNameSupplier = () -> indexName;
    }

    public String getIndexName() {
        return this.indexNameSupplier.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "IndexHelper(log=" + this.getLog() + ", indexNameSupplier=" + this.getIndexNameSupplier() + ", settings=" + this.getSettings() + ", clientFactory=" + this.getClientFactory() + ", mappings=" + this.getMappings() + ")";
    }

    public Logger getLog() {
        return this.log;
    }

    public Supplier<String> getIndexNameSupplier() {
        return this.indexNameSupplier;
    }

    public Supplier<Settings> getSettings() {
        return this.settings;
    }

    public ESClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public Map<String, Supplier<String>> getMappings() {
        return this.mappings;
    }

    public void setIndexNameSupplier(Supplier<String> indexNameSupplier) {
        this.indexNameSupplier = indexNameSupplier;
    }

    public void setSettings(Supplier<Settings> settings) {
        this.settings = settings;
    }

    public void setClientFactory(ESClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public static class Builder {
        private Logger log;
        private ESClientFactory client;
        private Supplier<String> indexNameSupplier;
        private Supplier<String> settings;
        private final Map<String, Supplier<String>> mappings = new HashMap<String, Supplier<String>>();

        public Builder mapping(String type, Supplier<String> mapping) {
            this.mappings.put(type, mapping);
            return this;
        }

        public Builder mappingResource(String type, String mapping) {
            return this.mapping(type, () -> ElasticSearchIndex.resourceToString((String)mapping));
        }

        public Builder mappings(Map<String, Supplier<String>> mappings) {
            this.mappings.putAll(mappings);
            return this;
        }

        public Builder settingsResource(String resource) {
            return this.settings(() -> ElasticSearchIndex.resourceToString((String)resource));
        }

        public Builder indexName(String indexName) {
            return this.indexNameSupplier(() -> indexName);
        }

        Builder() {
        }

        public Builder log(Logger log) {
            this.log = log;
            return this;
        }

        public Builder client(ESClientFactory client) {
            this.client = client;
            return this;
        }

        public Builder indexNameSupplier(Supplier<String> indexNameSupplier) {
            this.indexNameSupplier = indexNameSupplier;
            return this;
        }

        public Builder settings(Supplier<String> settings) {
            this.settings = settings;
            return this;
        }

        public IndexHelper build() {
            return new IndexHelper(this.log, this.client, this.indexNameSupplier, this.settings, this.mappings);
        }

        public String toString() {
            return "IndexHelper.Builder(log=" + this.log + ", client=" + this.client + ", indexNameSupplier=" + this.indexNameSupplier + ", settings=" + this.settings + ", mappings=" + this.mappings + ")";
        }
    }
}

