/*
 * Decompiled with CFR 0.152.
 */
package nl.vpro.hibernate.search;

import java.time.Instant;
import java.util.Date;
import nl.vpro.util.DateUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.builtin.NumberBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;

public class InstantToMinuteBridge
extends NumberBridge
implements MetadataProvidingFieldBridge {
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value != null) {
            if (value instanceof Date) {
                value = DateUtils.toInstant((Date)((Date)value));
            }
            Instant instance = (Instant)value;
            document.add((IndexableField)new NumericDocValuesField(name, instance.toEpochMilli()));
        }
    }

    public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
        builder.field(name, FieldType.LONG).sortable(true);
    }

    public Object stringToObject(String stringValue) {
        return Instant.ofEpochMilli(Long.parseLong(stringValue));
    }
}

